/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.StdDungeonMonster;
import examples.StdDungeonPlayer;
import examples.StdScoring;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.platform.StdGame;

public class DungeonsOfHack
extends StdGame {
    public static final int WALL_T = 1;
    public static final int SHWALL_T = 2;
    public static final int DOOR_T = 4;
    public static final int PLAYER_T = 16;
    public static final int MONSTER_T = 32;
    public static final int GEN_T = 64;
    public static final int BONUS_T = 128;
    public static final int KEY_T = 256;
    public static final int HEALTH_T = 512;
    public static final int PLAYERBLOCK_T = 71;
    public static final int MONSTERBLOCK_T = 999;
    public static final int BULLETBLOCK_T = 901;
    boolean do_scroll = false;
    JGObject player = null;
    int keys = 0;
    int health = 0;
    int kills = 0;
    int gold_left = 0;
    public int nr_mushrooms = 0;
    public int nr_demons = 0;
    JGFont scoring_font = new JGFont("Arial", 0, 8.0);

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("Please supply \"scroll\" or \"noscroll\" as first argument.");
            System.exit(0);
        }
        boolean bl = false;
        if (stringArray[0].equals("scroll")) {
            bl = true;
        }
        new DungeonsOfHack(DungeonsOfHack.parseSizeArgs(stringArray, 1), bl);
    }

    public DungeonsOfHack() {
        this.initEngineApplet();
    }

    public DungeonsOfHack(JGPoint jGPoint, boolean bl) {
        this.do_scroll = bl;
        this.initEngine(jGPoint.x, jGPoint.y);
    }

    public void initCanvas() {
        if (this.isApplet()) {
            boolean bl = this.do_scroll = this.getParameter("scrolling") != null;
        }
        if (this.isMidlet()) {
            this.do_scroll = true;
        }
        if (this.isMidlet()) {
            this.setCanvasSettings(18, 18, 10, 10, null, null, null);
            this.setScalingPreferences(0.75, 1.3333333333333333, 0, 4, 0, 4);
        } else if (this.do_scroll) {
            this.setCanvasSettings(20, 15, 10, 10, null, null, null);
        } else {
            this.setCanvasSettings(60, 40, 10, 10, null, null, null);
        }
    }

    public void initGame() {
        this.defineMedia("dungeons_of_hack.tbl");
        this.setVideoSyncedUpdate(true);
        if (this.isMidlet()) {
            this.setFrameRate(10.0, 1.0);
            this.setGameSpeed(1.8);
        } else {
            this.setFrameRate(30.0, 4.0);
        }
        this.startgame_ticks = 1000;
        this.gameover_ingame = true;
        this.title_font = new JGFont("Helvetica", 1, 17.0);
        this.setPFSize(60, 40);
    }

    public void initNewGame(int n) {
        this.health = 10;
        this.keys = 0;
        this.level = 0;
        this.kills = 0;
    }

    public void defineLevel() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int[][] nArray;
        int[] nArray2;
        int[] nArray3;
        this.fillBG("");
        this.removeObjects(null, 0);
        this.player = new Player(10.0, 10.0, 5.0, this.key_up, this.key_down, this.key_left, this.key_right);
        this.setViewOffset((int)this.player.x - 8, (int)this.player.y - 8, true);
        double d = this.random(0.0, 1.0);
        double d2 = this.random(0.0, 0.6);
        if (this.random(0.0, 1.0) > 0.42) {
            nArray3 = this.defineWallPos(2, 8, this.pfTilesX() - 1, true);
            nArray2 = this.defineWallPos(2, 8, this.pfTilesY() - 1, true);
            nArray = this.defineCells(nArray3.length + 1, nArray2.length + 1, this.random(0.0, 0.1));
            n11 = 4;
            n10 = 10;
            n9 = 5;
            n8 = 5;
            n7 = 10;
            n6 = 10;
            n5 = 80;
            n4 = 100;
            n3 = 200;
            n2 = 250;
        } else {
            nArray3 = this.defineWallPos(9, 16, this.pfTilesX() - 1, false);
            nArray2 = this.defineWallPos(9, 16, this.pfTilesY() - 1, false);
            nArray = this.defineCells(nArray3.length + 1, nArray2.length + 1, this.random(0.0, 0.15));
            n11 = 10;
            n10 = 25;
            n9 = 12;
            n8 = 12;
            n7 = 25;
            n6 = 25;
            n5 = 140;
            n4 = 200;
            n3 = 120;
            n2 = 180;
        }
        for (n = 0; n < this.pfTilesX(); ++n) {
            this.setTile(n, 0, "#");
            this.setTile(n, this.pfTilesY() - 1, "#");
        }
        for (n = 0; n < this.pfTilesY(); ++n) {
            this.setTile(0, n, "#");
            this.setTile(this.pfTilesX() - 1, n, "#");
        }
        for (n = 0; n < nArray[0].length; ++n) {
            for (int i = 0; i < nArray.length; ++i) {
                int n12;
                String string;
                int n13 = i == 0 ? 0 : nArray3[i - 1];
                int n14 = i == nArray3.length ? this.pfTilesX() - 1 : nArray3[i];
                int n15 = n == 0 ? 0 : nArray2[n - 1];
                int n16 = n == nArray2.length ? this.pfTilesY() - 1 : nArray2[n];
                this.setTile(n13, n15, "#");
                this.setTile(n13, n16, "#");
                this.setTile(n14, n15, "#");
                this.setTile(n14, n16, "#");
                if (i < nArray3.length) {
                    String string2 = this.random(0.0, 1.0) < d ? "|" : (string = this.random(0.0, 1.0) < d2 ? "%" : "#");
                    if (!this.and(nArray[i][n], 8)) {
                        for (n12 = n15 + 1; n12 < n16; ++n12) {
                            this.setTile(n14, n12, string);
                        }
                    }
                }
                if (n >= nArray2.length) continue;
                String string3 = this.random(0.0, 1.0) < d ? "-" : (string = this.random(0.0, 1.0) < d2 ? "%" : "#");
                if (this.and(nArray[i][n], 2)) continue;
                for (n12 = n13 + 1; n12 < n14; ++n12) {
                    this.setTile(n12, n16, string);
                }
            }
        }
        for (n = 0; n < n10; ++n) {
            this.setTile(this.getFreeTile(), "o");
        }
        for (n = 0; n < n11; ++n) {
            this.setTile(this.getFreeTile(), "k");
        }
        for (n = 0; n < n9; ++n) {
            this.setTile(this.getFreeTile(), "h");
        }
        for (n = 0; n < n7; ++n) {
            JGPoint jGPoint = this.getTileCoord(this.getFreeTile());
            new Generator(jGPoint.x, jGPoint.y, (int)(this.random(n5, (double)n5 * 1.5) / this.getGameSpeed()), 0);
        }
        for (n = 0; n < n8; ++n) {
            JGPoint jGPoint = this.getTileCoord(this.getFreeTile());
            new Generator(jGPoint.x, jGPoint.y, (int)(this.random(n4, (double)n4 * 1.5) / this.getGameSpeed()), (int)((double)n2 / this.getGameSpeed()));
        }
        for (n = 0; n < n6; ++n) {
            JGPoint jGPoint = this.getTileCoord(this.getFreeTile());
            new Turret(jGPoint.x, jGPoint.y, (int)(this.random((double)n3 / this.getGameSpeed(), (double)n3 * 2.5) / this.getGameSpeed()));
        }
        this.gold_left = this.countTiles(128);
    }

    public JGPoint getFreeTile() {
        int n;
        int n2;
        while (this.and(this.getTileCid(n2 = this.random(1, this.pfTilesX() - 2, 1), n = this.random(1, this.pfTilesY() - 2, 1)), 1023) || n2 < 6 && n < 6) {
        }
        return new JGPoint(n2, n);
    }

    public int[][] defineCells(int n, int n2, double d) {
        int[][] nArray = new int[n][n2];
        this.digMazePath(nArray, 0, 0, d);
        return nArray;
    }

    public void digMazePath(int[][] nArray, int n, int n2, double d) {
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray2 = nArray[n];
        int n7 = n2;
        nArray2[n7] = nArray2[n7] | 0x10;
        int[] nArray3 = new int[]{1, 2, 4, 8};
        for (n6 = 0; n6 < 9; ++n6) {
            n5 = this.random(0, 3, 1);
            n4 = this.random(0, 3, 1);
            n3 = nArray3[n5];
            nArray3[n5] = nArray3[n4];
            nArray3[n4] = n3;
        }
        for (n6 = 0; n6 < 4; ++n6) {
            n5 = 0;
            n4 = 0;
            n3 = 0;
            if (nArray3[n6] == 1) {
                n4 = -1;
                n3 = 2;
            }
            if (nArray3[n6] == 2) {
                n4 = 1;
                n3 = 1;
            }
            if (nArray3[n6] == 4) {
                n5 = -1;
                n3 = 8;
            }
            if (nArray3[n6] == 8) {
                n5 = 1;
                n3 = 4;
            }
            if (n + n5 < 0 || n2 + n4 < 0 || n + n5 >= nArray.length || n2 + n4 >= nArray[0].length || this.and(nArray[n + n5][n2 + n4], 16) && this.random(0.001, 1.0) > d) continue;
            int[] nArray4 = nArray[n];
            int n8 = n2;
            nArray4[n8] = nArray4[n8] | nArray3[n6];
            int[] nArray5 = nArray[n + n5];
            int n9 = n2 + n4;
            nArray5[n9] = nArray5[n9] | n3;
            this.digMazePath(nArray, n + n5, n2 + n4, d);
        }
    }

    public int[] defineWallPos(int n, int n2, int n3, boolean bl) {
        int n4;
        int[] nArray = new int[this.random(n, n2, 1)];
        for (n4 = 0; n4 < nArray.length; ++n4) {
            nArray[n4] = (int)(((double)n4 + 1.0) / ((double)nArray.length + 1.0) * (double)n3);
        }
        if (nArray.length == 0) {
            return nArray;
        }
        if (!bl) {
            return nArray;
        }
        for (n4 = 0; n4 < nArray.length * 3; ++n4) {
            int n5 = this.random(0, nArray.length - 1, 1);
            int n6 = n5 == 0 ? 0 : nArray[n5 - 1];
            int n7 = n5 == nArray.length - 1 ? n3 : nArray[n5 + 1];
            nArray[n5] = this.random(n6 + 2, n7 - 2, 1);
        }
        return nArray;
    }

    public void startTitle() {
        this.removeObjects(null, 0);
    }

    public void startGameOver() {
        if (this.player != null) {
            new JGObject("zexplo", true, this.player.x, this.player.y, 0, "explo", 48);
            this.player.remove();
        }
    }

    public void doFrameInGame() {
        this.moveObjects();
        this.checkCollision(4, 2);
        this.checkCollision(12, 1);
        this.checkBGCollision(903, 10);
        this.checkBGCollision(896, 1);
        this.nr_mushrooms = this.countObjects("mushroom", 0);
        this.nr_demons = this.countObjects("demon", 0);
        if (this.gold_left <= 0) {
            this.levelDone();
        }
        if (this.health < 0) {
            this.gameOver();
        }
        if (this.player != null) {
            this.setViewOffset((int)this.player.x - 8, (int)this.player.y - 8, true);
        }
    }

    public void incrementLevel() {
        ++this.level;
        ++this.stage;
        this.keys = 0;
        if (this.health <= 5) {
            this.health = 6;
        }
    }

    public void paintFrame() {
        this.setFont(this.status_font);
        this.setColor(this.status_color);
        this.drawString("GP " + this.score, 8.0, 0.0, -1);
        this.drawString("Kills " + this.kills, 70.0, 0.0, -1);
        this.drawString("Lvl " + (this.level + 1), 145.0, 0.0, -1);
        if (this.isMidlet()) {
            this.drawString("Keys " + this.keys, 8.0, this.viewHeight() - 15, -1);
            this.drawString("HP " + this.health, this.viewWidth() - 8, this.viewHeight() - 15, 1);
        } else if (!this.do_scroll) {
            this.drawCount(this.keys, "key", this.viewWidth() - 280, 0, 12);
            this.drawCount(this.health, "health", this.viewWidth() - 10 * this.health, 0, 10);
        } else {
            this.drawCount(this.keys, "key", 0, this.viewHeight() - 10, 12);
            this.drawCount(this.health, "health", this.viewWidth() - 10 * this.health, this.viewHeight() - 10, 10);
        }
    }

    public void paintFrameTitle() {
        this.drawImage(this.viewWidth() / 2 - 68, this.viewHeight() / 3 - 20, "splash_image", false);
        this.drawString("Press " + this.getKeyDesc(this.key_startgame) + " to start", this.viewWidth() / 2, 250.0, 0, this.title_font, this.title_color);
    }

    void openDoor(int n, int n2) {
        if (!this.and(this.getTileCid(n, n2), 4)) {
            return;
        }
        this.setTile(n, n2, "");
        if (n > 0) {
            this.openDoor(n - 1, n2);
        }
        if (n2 > 0) {
            this.openDoor(n, n2 - 1);
        }
        if (n < this.pfTilesX() - 1) {
            this.openDoor(n + 1, n2);
        }
        if (n2 < this.pfTilesY() - 1) {
            this.openDoor(n, n2 + 1);
        }
    }

    public class Bullet
    extends JGObject {
        public Bullet(double d, double d2, int n, int n2, double d3) {
            super("bullet", true, d, d2, 2, "axe", 35);
            this.setDirSpeed(n, n2, d3);
        }

        public void hit(JGObject jGObject) {
            ++DungeonsOfHack.this.kills;
            new JGObject("zexplo", true, jGObject.x, jGObject.y, 0, "explo", 12);
            jGObject.remove();
            this.remove();
        }

        public void hit_bg(int n) {
            this.remove();
        }

        public void hit_bg(int n, int n2, int n3) {
            if (Bullet.and(n, 2)) {
                DungeonsOfHack.this.setTile(n2, n3, "");
            }
        }
    }

    public class Player
    extends StdDungeonPlayer {
        int prevxdir = 1;
        int prevydir = 0;

        public Player(double d, double d2, double d3, int n, int n2, int n3, int n4) {
            super("player", d, d2, 1, "human_l", false, false, 71, 16, 2.3, n, n2, n3, n4);
            this.stopAnim();
        }

        public void move() {
            int n = 0;
            int n2 = 0;
            if (DungeonsOfHack.this.getKey(this.key_left)) {
                n = -1;
                this.prevxdir = -1;
                this.prevydir = 0;
            }
            if (DungeonsOfHack.this.getKey(this.key_right)) {
                n = 1;
                this.prevxdir = 1;
                this.prevydir = 0;
            }
            if (DungeonsOfHack.this.getKey(this.key_up)) {
                n2 = -1;
                this.prevxdir = 0;
                this.prevydir = -1;
            }
            if (DungeonsOfHack.this.getKey(this.key_down)) {
                n2 = 1;
                this.prevxdir = 0;
                this.prevydir = 1;
            }
            if (DungeonsOfHack.this.getKey(DungeonsOfHack.this.key_fire)) {
                this.stop_moving = true;
                JGPoint jGPoint = this.getCenterTile();
                if (Player.and(DungeonsOfHack.this.getTileCid(jGPoint, this.prevxdir, this.prevydir), 4) && DungeonsOfHack.this.keys > 0) {
                    DungeonsOfHack.this.openDoor(jGPoint.x + this.prevxdir, jGPoint.y + this.prevydir);
                    --DungeonsOfHack.this.keys;
                }
            } else {
                this.stop_moving = false;
            }
            n = 0;
            n2 = 0;
            if (DungeonsOfHack.this.getKey(DungeonsOfHack.this.key_fireleft)) {
                n = -1;
            }
            if (DungeonsOfHack.this.getKey(DungeonsOfHack.this.key_fireright)) {
                n = 1;
            }
            if (DungeonsOfHack.this.getKey(DungeonsOfHack.this.key_fireup)) {
                n2 = -1;
            }
            if (DungeonsOfHack.this.getKey(DungeonsOfHack.this.key_firedown)) {
                n2 = 1;
            }
            if (DungeonsOfHack.this.countObjects("bullet", 0) < 1 && (n != 0 || n2 != 0)) {
                new Bullet(this.x, this.y, n, n2, 6.0);
            }
            super.move();
            if (this.xdir > 0) {
                this.setGraphic("human_r");
            }
            if (this.xdir < 0) {
                this.setGraphic("human_l");
            }
        }

        public void hit_bg(int n, int n2, int n3) {
            if (Player.and(n, 128)) {
                DungeonsOfHack.this.setTile(n2, n3, "");
                ++DungeonsOfHack.this.score;
                --DungeonsOfHack.this.gold_left;
            } else if (Player.and(n, 256)) {
                ++DungeonsOfHack.this.keys;
                DungeonsOfHack.this.setTile(n2, n3, "");
            } else if (Player.and(n, 512) && DungeonsOfHack.this.health < 15) {
                DungeonsOfHack.this.health += 2;
                DungeonsOfHack.this.setTile(n2, n3, "");
                new StdScoring("msg", this.x, this.y - 10.0, 0.0, -0.5, 40, "Potion! +2 health", new JGFont("Helvetica", 0, 10.0), new JGColor[]{JGColor.white, JGColor.red}, 2);
            }
        }

        public void hit(JGObject jGObject) {
            if (jGObject.colid == 4) {
                jGObject.remove();
                DungeonsOfHack.this.health -= 2;
                new StdScoring("msg", this.x, this.y - 10.0, 0.0, -0.5, 40, "Hit! -2 health", new JGFont("Helvetica", 0, 10.0), new JGColor[]{JGColor.white, JGColor.magenta}, 2);
            } else if (jGObject.colid == 8) {
                jGObject.remove();
                --DungeonsOfHack.this.health;
                new StdScoring("msg", this.x, this.y - 10.0, 0.0, -0.5, 40, "Shot! -1 health", new JGFont("Helvetica", 0, 10.0), new JGColor[]{JGColor.white, JGColor.blue}, 2);
            }
        }
    }

    public class Demon
    extends StdDungeonMonster {
        int firerate;
        int firecount;

        public Demon(double d, double d2, int n) {
            super("demon", true, d, d2, 4, "face", false, false, 999, 32, 1.0, null, false, 0.0);
            this.home_in = DungeonsOfHack.this.player;
            this.firerate = n;
            this.firecount = (int)DungeonsOfHack.this.random(0.0, n);
            if (DungeonsOfHack.this.isMidlet()) {
                this.expiry = -4.0;
            }
        }

        public void move() {
            super.move();
            if (DungeonsOfHack.this.player != null) {
                this.avoid = !(Math.abs(this.x - DungeonsOfHack.this.player.x) + Math.abs(this.y - DungeonsOfHack.this.player.y) > 150.0);
            }
            if (this.firecount-- <= 0) {
                this.firecount = this.firerate;
                if (DungeonsOfHack.this.player != null) {
                    double d = DungeonsOfHack.this.atan2(DungeonsOfHack.this.player.x - this.x, DungeonsOfHack.this.player.y - this.y);
                    new TurretBullet(this.x, this.y, 1.0 * Math.sin(d), 1.0 * Math.cos(d), 120);
                }
            }
        }
    }

    public class Generator
    extends StdDungeonMonster {
        int genspeed;
        int gencount;
        int monster_firerate;

        public Generator(double d, double d2, int n, int n2) {
            super("generator", true, d, d2, 4, null, 64);
            this.genspeed = n;
            this.gencount = (int)DungeonsOfHack.this.random(0.0, n);
            this.monster_firerate = n2;
            if (n2 == 0) {
                this.setGraphic("hole");
            } else {
                this.setGraphic("coffin");
            }
            if (DungeonsOfHack.this.isMidlet()) {
                this.expiry = -4.0;
            }
        }

        public void move() {
            super.move();
            if (!Generator.and(DungeonsOfHack.this.getTileCid(this.getCenterTile(), 0, 0), 32) && this.gencount-- <= 0) {
                this.gencount = this.genspeed;
                if (this.monster_firerate == 0) {
                    if (DungeonsOfHack.this.nr_mushrooms < 80) {
                        StdDungeonMonster stdDungeonMonster = new StdDungeonMonster("mushroom", true, this.x, this.y, 4, "mushroom", false, false, 999, 32, 1.0, DungeonsOfHack.this.player, false, 0.0);
                        if (DungeonsOfHack.this.isMidlet()) {
                            stdDungeonMonster.expiry = -4.0;
                        }
                    }
                } else if (DungeonsOfHack.this.nr_demons < 40) {
                    new Demon(this.x, this.y, this.monster_firerate);
                }
            }
        }
    }

    public class TurretBullet
    extends JGObject {
        public TurretBullet(double d, double d2, double d3, double d4, int n) {
            super("turretbullet", true, d, d2, 8, "bullet", d3, d4, n);
        }

        public void hit_bg(int n) {
            this.remove();
        }

        public void hit_bg(int n, int n2, int n3) {
            if (TurretBullet.and(n, 2)) {
                DungeonsOfHack.this.setTile(n2, n3, "");
            }
        }
    }

    public class Turret
    extends StdDungeonMonster {
        int bulletrate;
        int bulletcount;

        public Turret(double d, double d2, int n) {
            super("turret", true, d, d2, 4, "turret", 32);
            this.bulletrate = n;
            this.bulletcount = (int)DungeonsOfHack.this.random(0.0, n);
            if (DungeonsOfHack.this.isMidlet()) {
                this.expiry = -4.0;
            }
        }

        public void move() {
            super.move();
            if (this.bulletcount-- <= 0) {
                this.bulletcount = this.bulletrate;
            }
            if (this.bulletcount < (int)(50.0 / gamespeed) && this.bulletcount % (int)(8.0 / gamespeed) == 0 && DungeonsOfHack.this.player != null) {
                double d = DungeonsOfHack.this.atan2(DungeonsOfHack.this.player.x - this.x, DungeonsOfHack.this.player.y - this.y);
                new TurretBullet(this.x, this.y, 2.0 * Math.sin(d), 2.0 * Math.cos(d), 70);
            }
        }
    }
}

