/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.StdMazeMonster;
import examples.StdMazePlayer;
import examples.StdScoring;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.platform.StdGame;

public class PubMan
extends StdGame {
    Player player = null;
    JGObject ghost_house = null;
    int nr_pills;
    double powerpilltime = 0.0;
    double powerpillmax;
    int powerpillcaught;
    JGFont scorefont = new JGFont("Helvetica", 0, 18.0);

    public static void main(String[] stringArray) {
        new PubMan(PubMan.parseSizeArgs(stringArray, 0));
    }

    public PubMan() {
        this.initEngineApplet();
    }

    public PubMan(JGPoint jGPoint) {
        this.initEngine(jGPoint.x, jGPoint.y);
    }

    public void initCanvas() {
        this.setCanvasSettings(19, 15, 16, 16, null, null, null);
        if (this.isMidlet()) {
            this.setScalingPreferences(0.75, 1.3333333333333333, 0, 5, 5, 5);
        }
    }

    public void initGame() {
        this.defineMedia("pub_man.tbl");
        this.setVideoSyncedUpdate(true);
        if (this.isMidlet()) {
            this.setFrameRate(15.0, 4.0);
            this.setGameSpeed(2.0);
        } else {
            this.setFrameRate(40.0, 4.0);
        }
        this.startgame_ticks = 80;
        this.leveldone_ticks = 80;
        this.lifelost_ticks = 80;
        this.gameover_ticks = 120;
        this.startgame_ingame = true;
        this.stage = 1;
        this.defineLevel();
    }

    public void doFrameInGame() {
        this.moveObjects();
        this.checkBGCollision(2, 1);
        this.checkBGCollision(4, 1);
        this.checkCollision(9, 2);
        this.checkCollision(4, 1);
        if (this.powerpilltime > 0.0) {
            this.powerpilltime -= this.getGameSpeed();
        }
    }

    public void paintFrame() {
        this.setFont(this.scorefont);
        this.drawString("" + this.score, 16.0, 0.0, -1);
        for (int i = 1; i < this.lives; ++i) {
            this.drawImage(this.pfWidth() - 16 - 16 * i, 0.0, "player_d7");
        }
    }

    public void paintFrameTitle() {
        this.drawImage(90.0, 72.0, "splash_image");
        if (!this.isMidlet()) {
            this.drawImageString("PRESS " + this.getKeyDesc(this.key_startgame).toUpperCase(), this.pfWidth() / 2, 140.0, 0, "font_map", 32, 2);
        } else {
            this.drawImageString("STAR TO START", this.pfWidth() / 2, 130.0, 0, "font_map", 32, 2);
            this.drawImageString("POUND TO QUIT", this.pfWidth() / 2, 160.0, 0, "font_map", 32, 2);
        }
    }

    public void paintFrameLifeLost() {
        int n = this.posWalkForwards(-16, this.pfHeight(), this.seqtimer, 80, 75, 10, 30);
        this.drawImageString("CAUGHT!", this.pfWidth() / 2, n, 0, "font_map", 32, 2);
    }

    public void paintFrameGameOver() {
        this.drawImageString("GAME OVER!", this.pfWidth() / 2, 75.0, 0, "font_map", 32, 2);
    }

    public void paintFrameLevelDone() {
        int n = this.posWalkForwards(-16, this.pfHeight(), this.seqtimer, 80, 75, 10, 30);
        this.drawImageString("LEVEL CLEAR!", this.pfWidth() / 2, n, 0, "font_map", 32, 2);
    }

    public void paintFrameStartLevel() {
        int n = this.posWalkForwards(this.pfHeight() - 8, this.pfHeight() - 8, this.seqtimer, 80, 113, 55, 10);
        this.drawImageString("LEVEL " + (this.stage + 1), this.pfWidth() / 2, n, 0, "font_map", 32, 2);
    }

    public void paintFrameStartGame() {
        int n = this.posWalkForwards(this.pfHeight() + 24, this.pfHeight() + 24, this.seqtimer, 80, 145, 55, 10);
        this.drawImageString("READY!", this.pfWidth() / 2, n, 0, "font_map", 32, 2);
    }

    public void incrementLevel() {
        ++this.level;
        ++this.stage;
        if (this.level >= 9) {
            this.level = 6;
        }
    }

    public void startInGame() {
        this.powerpillmax = 250 - 22 * this.level;
        this.powerpilltime = 0.0;
        this.removeObjects("enemy", 0);
        this.player = new Player(144.0, 176.0, this.key_up, this.key_down, this.key_left, this.key_right);
        this.ghost_house = new JGObject("ghost_house", false, 9 * this.tileWidth(), 5 * this.tileHeight() - 2, 8, null);
        this.ghost_house.setBBox(0, 0, 16, 16);
        for (int i = 0; i < 4 + this.level / 3; ++i) {
            new Enemy(9.0, 5.0, 0, -1, 1.5 + (double)i * 0.1);
        }
    }

    public void startGameOver() {
        this.removeObjects(null, 0);
    }

    public void defineLevel() {
        int n;
        int n2;
        int n3;
        this.removeObjects(null, 0);
        this.fillBG(".");
        for (n3 = 0; n3 < this.pfTilesY(); ++n3) {
            for (n2 = 0; n2 <= this.pfTilesX() / 2; ++n2) {
                if (!this.and(n2, 1) && !this.and(n3, 1)) {
                    this.setTile(n2, n3, "#" + this.stage % 5);
                    continue;
                }
                if (n2 != 0 && n2 != this.pfTilesX() - 1 && n3 != 0 && n3 != this.pfTilesY() - 1) continue;
                this.setTile(n2, n3, "#" + this.stage % 5);
            }
        }
        this.setTile(8, 3, "f");
        this.setTile(9, 3, "f");
        this.setTile(6, 1, "g");
        this.setTile(7, 3, "g");
        this.setTile(7, 4, "f");
        this.setTile(7, 5, "f");
        for (n3 = 6; n3 <= 9; ++n3) {
            this.setTile(n3, 11, "f");
        }
        this.setTile(9, 12, "f");
        for (n3 = 0; n3 < 5 - this.level % 3; ++n3) {
            while (this.and(this.getTileCid((n2 = this.random(2, this.pfTilesX() / 2 - 2, 2)) - 1, n = this.random(2, this.pfTilesY() - 4, 4) + ((n2 & 2) != 0 ? 0 : 2)) | this.getTileCid(n2 + 1, n) | this.getTileCid(n2, n - 1) | this.getTileCid(n2, n + 1), 21)) {
            }
            if (this.random(0.0, 1.0) > 0.5 || n2 >= 4 && n2 <= 6 && n >= 4 && n <= 6) {
                this.setTile(n2 + 1, n, "d");
                this.setTile(n2 - 1, n, "d");
                this.setTile(n2, n - 1, "v");
                this.setTile(n2, n + 1, "^");
                continue;
            }
            this.setTile(n2 + 1, n, "<");
            this.setTile(n2 - 1, n, ">");
            this.setTile(n2, n - 1, "d");
            this.setTile(n2, n + 1, "d");
        }
        for (n3 = 0; n3 < 10; ++n3) {
            while (this.and(this.getTileCid(n2 = this.random(1, this.pfTilesX() / 2, 1), n = this.random(1, this.pfTilesY() - 1, 2) + ((n2 & 1) != 0 ? 1 : 0)), 101) || n2 == 5 && n == 6 || n2 == 5 && n == 8) {
            }
            this.setTile(n2, n, "#" + this.stage % 5);
        }
        this.setTile(9, 4, "=");
        this.setTile(8, 5, "#" + this.stage % 5);
        this.setTile(8, 6, "#" + this.stage % 5);
        this.setTile(9, 6, "#" + this.stage % 5);
        for (n3 = 0; n3 < this.pfTilesY(); ++n3) {
            for (n2 = 0; n2 < this.pfTilesX() / 2; ++n2) {
                String string = this.getTileStr(n2, n3);
                if (string.equals(">")) {
                    string = "<";
                } else if (string.equals("<")) {
                    string = ">";
                }
                this.setTile(this.pfTilesX() - 1 - n2, n3, string);
            }
        }
        this.floodFillPills(9, 11);
        block9: for (n3 = 1; n3 < this.pfTilesY(); n3 += this.pfTilesY() - 3) {
            for (n2 = 1; n2 < this.pfTilesX() / 2 - 1; ++n2) {
                if (!this.and(this.getTileCid(n2, n3), 2)) continue;
                new JGObject("powerpill", true, n2 * this.tileWidth(), n3 * this.tileHeight(), 4, "powerpill");
                new JGObject("powerpill", true, (this.pfTilesX() - 1 - n2) * this.tileWidth(), n3 * this.tileHeight(), 4, "powerpill");
                continue block9;
            }
        }
        this.nr_pills = this.countTiles(2);
    }

    void floodFillPills(int n, int n2) {
        if (this.and(this.getTileCid(n, n2), 11)) {
            return;
        }
        if (!this.and(this.getTileCid(n, n2), 36)) {
            this.setTile(n, n2, "o");
        }
        if (n > 0) {
            this.floodFillPills(n - 1, n2);
        }
        if (n2 > 0) {
            this.floodFillPills(n, n2 - 1);
        }
        if (n < this.pfTilesX() - 1) {
            this.floodFillPills(n + 1, n2);
        }
        if (n2 < this.pfTilesY() - 1) {
            this.floodFillPills(n, n2 + 1);
        }
    }

    public class Enemy
    extends StdMazeMonster {
        boolean is_eaten = false;
        boolean is_restored = false;

        public Enemy(double d, double d2, int n, int n2, double d3) {
            super("enemy", true, 16.0 * d, 16.0 * d2, 2, "enemy_", true, 5, n, n2, d3, null, false, 0.4);
        }

        public void move() {
            if (this.is_eaten) {
                this.avoid = false;
                this.home_in = PubMan.this.ghost_house;
                this.gfx_prefix = "enemy_bk_";
                this.block_mask = 1;
                this.random_proportion = 0.25;
            } else {
                this.random_proportion = 0.4;
                this.block_mask = 5;
                if (PubMan.this.powerpilltime >= PubMan.this.powerpillmax) {
                    this.xdir = -this.xdir;
                    this.ydir = -this.ydir;
                }
                if (PubMan.this.powerpilltime > 0.0 && !this.is_restored) {
                    this.home_in = PubMan.this.player;
                    this.avoid = true;
                    this.gfx_prefix = PubMan.this.powerpilltime < 80.0 && ((int)PubMan.this.powerpilltime & 8) != 0 ? "enemy_w_" : "enemy_b_";
                } else if (PubMan.this.powerpilltime <= 0.0 || PubMan.this.powerpilltime >= PubMan.this.powerpillmax) {
                    this.is_restored = false;
                    this.home_in = PubMan.this.player;
                    this.avoid = false;
                    this.gfx_prefix = "enemy_";
                } else {
                    this.home_in = PubMan.this.player;
                    this.avoid = false;
                    this.gfx_prefix = "enemy_";
                }
            }
            super.move();
        }

        public void hit(JGObject jGObject) {
            if (!(jGObject instanceof Player)) {
                if (this.is_eaten) {
                    this.is_eaten = false;
                    this.is_restored = true;
                }
            } else {
                if (PubMan.this.powerpilltime > 0.0 && !this.is_eaten && !this.is_restored) {
                    this.is_eaten = true;
                    this.xdir = -this.xdir;
                    this.ydir = -this.ydir;
                    PubMan.this.score += 100 * (1 << PubMan.this.powerpillcaught);
                    new StdScoring("Scoring", this.x + 8.0, this.y + 4.0, 0.0, 0.0, 80, "" + 100 * (1 << PubMan.this.powerpillcaught), new JGFont("Helvetica", 0, 10.0), new JGColor[]{JGColor.white, JGColor.green}, 16);
                    ++PubMan.this.powerpillcaught;
                }
                if ((PubMan.this.powerpilltime <= 0.0 && !this.is_eaten || this.is_restored) && !((Player)jGObject).is_dead) {
                    ((Player)jGObject).is_dead = true;
                    PubMan.this.lifeLost();
                }
            }
        }
    }

    public class Player
    extends StdMazePlayer {
        public boolean is_dead = false;

        public Player(double d, double d2, int n, int n2, int n3, int n4) {
            super("player", d, d2, 1, "player_", true, false, 9, 3.0, n, n2, n3, n4);
        }

        public void move() {
            super.move();
        }

        public void hit(JGObject jGObject) {
            jGObject.remove();
            PubMan.this.score += 50;
            PubMan.this.powerpilltime = PubMan.this.powerpillmax + 1.0;
            PubMan.this.powerpillcaught = 0;
        }

        public void hit_bg(int n, int n2, int n3, int n4, int n5) {
            JGPoint jGPoint;
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n4; ++j) {
                    if (!Player.and(PubMan.this.getTileCid(n2 + j, n3 + i), 2)) continue;
                    PubMan.this.setTile(n2 + j, n3 + i, ".");
                    --PubMan.this.nr_pills;
                    PubMan.this.score += 5;
                }
            }
            if (PubMan.this.nr_pills <= 0) {
                PubMan.this.levelDone();
            }
            if (Player.and(PubMan.this.getTileCid(jGPoint = this.getCenterTile(), 0, 0), 4)) {
                String string = PubMan.this.getTileStr(jGPoint, 0, 0);
                if (string.equals("^")) {
                    PubMan.this.setTile(jGPoint.x, jGPoint.y, ".");
                    PubMan.this.setTile(jGPoint.x, jGPoint.y - 2, ".");
                    PubMan.this.setTile(jGPoint.x - 1, jGPoint.y - 1, ">");
                    PubMan.this.setTile(jGPoint.x + 1, jGPoint.y - 1, "<");
                } else if (string.equals("v")) {
                    PubMan.this.setTile(jGPoint.x, jGPoint.y, ".");
                    PubMan.this.setTile(jGPoint.x, jGPoint.y + 2, ".");
                    PubMan.this.setTile(jGPoint.x - 1, jGPoint.y + 1, ">");
                    PubMan.this.setTile(jGPoint.x + 1, jGPoint.y + 1, "<");
                } else if (string.equals("<")) {
                    PubMan.this.setTile(jGPoint.x, jGPoint.y, ".");
                    PubMan.this.setTile(jGPoint.x - 2, jGPoint.y, ".");
                    PubMan.this.setTile(jGPoint.x - 1, jGPoint.y - 1, "v");
                    PubMan.this.setTile(jGPoint.x - 1, jGPoint.y + 1, "^");
                } else if (string.equals(">")) {
                    PubMan.this.setTile(jGPoint.x, jGPoint.y, ".");
                    PubMan.this.setTile(jGPoint.x + 2, jGPoint.y, ".");
                    PubMan.this.setTile(jGPoint.x + 1, jGPoint.y - 1, "v");
                    PubMan.this.setTile(jGPoint.x + 1, jGPoint.y + 1, "^");
                }
            }
        }
    }
}

