/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.StdScoring;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.platform.StdGame;

public class Ramjet
extends StdGame {
    Player player = null;
    JGFont scoring_font = new JGFont("Arial", 0, 8.0);
    JGColor[] explo_col = new JGColor[]{JGColor.red, JGColor.yellow, JGColor.green, JGColor.cyan, JGColor.blue, JGColor.magenta};
    JGFont scoringfont = new JGFont("Helvetica", 0, 12.0);
    JGFont scoringfontl = new JGFont("Helvetica", 0, 20.0);
    JGColor[] scoringcolors = new JGColor[]{JGColor.blue, JGColor.red};

    public static void main(String[] stringArray) {
        new Ramjet(Ramjet.parseSizeArgs(stringArray, 0));
    }

    public Ramjet() {
        this.initEngineApplet();
    }

    public Ramjet(JGPoint jGPoint) {
        this.initEngine(jGPoint.x, jGPoint.y);
    }

    public void initCanvas() {
        this.setCanvasSettings(80, 60, 8, 8, null, null, null);
    }

    public void initGame() {
        this.setFrameRate(45.0, 1.0);
        this.defineImage("brown", "#", 1, "gfx/empty-brown8.gif", "-");
        this.defineImage("nullimg", ".", 0, "null", "-");
        this.setTileSettings("#", 1, 0);
        this.defineMedia("ramjet.tbl");
        this.leveldone_ingame = true;
        this.startgame_ingame = true;
        this.lifelost_ingame = true;
        this.gameover_ingame = true;
    }

    public void startTitle() {
        this.playAudio("music", "titlemusic", true);
        new JGObject("_title", false, 187.0, 84.0, 0, "splash_image");
    }

    public void paintFrameTitle() {
        this.drawString("Press " + this.getKeyDesc(this.key_startgame) + " to start", this.pfWidth() / 2, 250.0, 0, this.title_font, this.title_color);
        this.drawString("Press " + this.getKeyDesc(this.key_gamesettings) + " for settings", this.pfWidth() / 2, 350.0, 0, this.title_font, this.title_color);
    }

    public void doFrameTitle() {
        new ShortExplo(this.random(180, 460, 1), (double)this.random(80, 150, 1), 2, 6, false, false);
        this.moveObjects();
    }

    public void initNewLife() {
        this.player = new Player(this.pfWidth() / 2, this.pfHeight() / 2);
    }

    public void initNewGame(int n) {
        super.initNewGame(n);
        this.removeObjects("_title", 0);
        this.stopAudio();
        this.lives = 4;
        this.player = new Player(this.pfWidth() / 2, this.pfHeight() / 2);
    }

    public void defineLevel() {
        int n;
        this.removeObjects(null, 28);
        for (n = 0; n < 3 + this.level; ++n) {
            int n2;
            do {
                n2 = this.random(0, this.pfWidth(), 1);
            } while (this.player != null && !((double)n2 < this.player.x - 100.0) && !((double)n2 > this.player.x + 100.0));
            new Boulder(n2, this.random(0.0, this.pfHeight()), (double)this.random(-1, 1, 2) * this.random(0.5, 1.5), (double)this.random(-1, 1, 2) * this.random(0.5, 1.5), 50);
        }
        for (n = 0; n < this.pfTilesX() / 2; ++n) {
        }
        for (n = this.pfTilesX() / 2; n < this.pfTilesX(); ++n) {
        }
    }

    public void startGameOver() {
        this.removeObjects(null, 0);
        this.stopAudio("music");
    }

    public void doFrameInGame() {
        this.moveObjects();
        if (this.countObjects("boulder", 0) == 0) {
            this.levelDone();
        }
        this.checkCollision(2, 12);
        this.checkCollision(28, 1);
        this.checkCollision(4, 8);
        this.checkCollision(1, 32);
        this.checkBGCollision(1, 1);
        if (this.checkTime(100, 100000, 500 - this.level * 2)) {
            if (this.random(0, 1, 1) == 0) {
                new UFO(this.pfWidth(), this.random(16.0, this.pfHeight() - 32), -2.0, this.random(-0.8, 0.8));
            } else {
                new UFO(0.0, this.random(16.0, this.pfHeight() - 32), 2.0, this.random(-0.8, 0.8));
            }
        }
        if (this.countObjects("ufo", 0) == 0) {
            this.stopAudio("ufo");
        } else {
            this.playAudio("ufo", "ufo", true);
        }
    }

    public void incrementLevel() {
        if (this.level < 9) {
            ++this.level;
        }
        ++this.stage;
    }

    public class Player
    extends JGObject {
        double orient = 0.0;
        int bullettime = 0;
        boolean togglefire = true;
        int thrusting = 0;
        int invulnerability = 180;

        public Player(double d, double d2) {
            super("player", false, d, d2, 1, null);
            this.setBBox(-6, -6, 12, 12);
        }

        public void move() {
            if (this.x < 10.0 && this.xspeed < 0.0) {
                this.xspeed = -this.xspeed;
            }
            if (this.y < 10.0 && this.yspeed < 0.0) {
                this.yspeed = -this.yspeed;
            }
            if (this.x > (double)(Ramjet.this.pfWidth() - 10) && this.xspeed > 0.0) {
                this.xspeed = -this.xspeed;
            }
            if (this.y > (double)(Ramjet.this.pfHeight() - 10) && this.yspeed > 0.0) {
                this.yspeed = -this.yspeed;
            }
            if (Ramjet.this.getKey(Ramjet.this.key_right)) {
                this.orient -= 5.0;
            }
            if (Ramjet.this.getKey(Ramjet.this.key_left)) {
                this.orient += 5.0;
            }
            if (this.orient < 0.0) {
                this.orient += 400.0;
            }
            if (this.orient >= 400.0) {
                this.orient -= 400.0;
            }
            double d = this.orient / 200.0 * Math.PI;
            this.thrusting = 0;
            if (Ramjet.this.getKey(Ramjet.this.key_up)) {
                this.xspeed -= 0.3 * Math.sin(d);
                this.yspeed -= 0.3 * Math.cos(d);
                this.thrusting = 1;
            }
            if (Ramjet.this.getKey(Ramjet.this.key_fireleft)) {
                // empty if block
            }
            if (Ramjet.this.getKey(Ramjet.this.key_fireright)) {
                // empty if block
            }
            if (Ramjet.this.getKey(Ramjet.this.key_down)) {
                this.xspeed *= 0.93;
                this.yspeed *= 0.93;
                if (Math.abs(this.xspeed) > 0.1 && Math.abs(this.yspeed) > 0.1) {
                    this.thrusting = 2;
                }
            }
            if (this.thrusting != 0) {
                Ramjet.this.playAudio("thrust", "thrust", true);
            } else {
                Ramjet.this.stopAudio("thrust");
            }
            this.togglefire = false;
            if (Ramjet.this.getKey(Ramjet.this.key_fire)) {
                this.togglefire = true;
            }
            if (this.togglefire && this.bullettime <= 0) {
                new Bullet(this.x - 8.0 * Math.sin(d), this.y - 8.0 * Math.cos(d), this.xspeed - 10.0 * Math.sin(d), this.yspeed - 10.0 * Math.cos(d), d);
                this.bullettime = 8;
            }
            if (this.bullettime > 0) {
                --this.bullettime;
            }
            if (this.invulnerability > 0) {
                --this.invulnerability;
            }
        }

        public void paint() {
            double d = this.orient / 200.0 * Math.PI;
            Ramjet.this.setColor(JGColor.yellow);
            if (this.invulnerability == 0 || Ramjet.this.gametime % 8.0 < 4.0) {
                Ramjet.this.drawLine((int)(this.x - 10.0 * Math.sin(d)), (int)(this.y - 10.0 * Math.cos(d)), (int)(this.x + 10.0 * Math.sin(d - 0.5)), (int)(this.y + 10.0 * Math.cos(d - 0.5)));
                Ramjet.this.drawLine((int)(this.x - 10.0 * Math.sin(d)), (int)(this.y - 10.0 * Math.cos(d)), (int)(this.x + 10.0 * Math.sin(d + 0.5)), (int)(this.y + 10.0 * Math.cos(d + 0.5)));
            }
            if (this.thrusting == 1) {
                Ramjet.this.setColor(JGColor.red);
                Ramjet.this.drawLine((int)(this.x + 15.0 * Math.sin(d)), (int)(this.y + 15.0 * Math.cos(d)), (int)(this.x + 8.0 * Math.sin(d - 0.5)), (int)(this.y + 8.0 * Math.cos(d - 0.5)));
                Ramjet.this.drawLine((int)(this.x + 15.0 * Math.sin(d)), (int)(this.y + 15.0 * Math.cos(d)), (int)(this.x + 8.0 * Math.sin(d + 0.5)), (int)(this.y + 8.0 * Math.cos(d + 0.5)));
            }
        }

        public void hit(JGObject jGObject) {
            if (this.invulnerability == 0) {
                new ShortExplo(this.x, this.y, 25, 6, true, true);
                this.remove();
                Ramjet.this.lifeLost();
            }
        }

        public void hit_bg(int n, int n2, int n3) {
        }

        public void tryAllDirs(double d, double d2) {
            if (this.checkBGCollision(this.xspeed, this.yspeed) == 0) {
                return;
            }
            if (this.checkBGCollision(this.xspeed, -this.yspeed) == 0) {
                this.yspeed = -this.yspeed;
                return;
            }
            if (this.checkBGCollision(-this.xspeed, -this.yspeed) == 0) {
                this.xspeed = -this.xspeed;
                this.yspeed = -this.yspeed;
                return;
            }
            if (this.checkBGCollision(-this.xspeed, this.yspeed) == 0) {
                this.xspeed = -this.xspeed;
            }
        }
    }

    public class Bonus
    extends JGObject {
        int timer = 300;

        public Bonus(double d, double d2) {
            super("bonus", true, d, d2, 32, null);
            this.setBBox(-6, -6, 12, 12);
        }

        public void move() {
            if (Ramjet.this.player != null) {
                this.xspeed = this.x < Ramjet.this.player.x ? (this.xspeed += 0.01) : (this.xspeed -= 0.01);
                this.yspeed = this.y < Ramjet.this.player.y ? (this.yspeed += 0.01) : (this.yspeed -= 0.01);
            }
            this.xspeed = this.xspeed > 0.0 ? (this.xspeed -= 0.005) : (this.xspeed += 0.005);
            this.yspeed = this.yspeed > 0.0 ? (this.yspeed -= 0.005) : (this.yspeed += 0.005);
            if (this.timer-- <= 0) {
                this.remove();
            }
        }

        public void hit(JGObject jGObject) {
            this.remove();
            Ramjet.this.score += 25;
            new StdScoring("Pts", this.x, this.y, this.xspeed, this.yspeed, 50, "25", Ramjet.this.scoringfont, Ramjet.this.scoringcolors, 4);
            Ramjet.this.playAudio("pickup");
        }

        public void paint() {
            Ramjet.this.setColor(JGColor.magenta);
            Ramjet.this.drawOval((int)this.x, (int)this.y, 5.0 + 3.0 * Math.sin(Ramjet.this.gametime), 5.0 + 3.0 * Math.cos(Ramjet.this.gametime), false, true);
        }
    }

    public class ShortExplo
    extends JGObject {
        int size;
        boolean spawn;

        public ShortExplo(double d, double d2, int n, int n2, boolean bl, boolean bl2) {
            super("explo", true, d, d2, 0, null, 6);
            if (bl) {
                Ramjet.this.playAudio("explo");
            }
            this.size = n;
            this.expiry = n2 + Ramjet.this.random(0, 5, 1);
            this.spawn = bl2;
        }

        public void move() {
            if (this.spawn && (int)this.expiry == 0 && this.size > 2) {
                for (double d = Ramjet.this.random(0.0, 0.6); d < Math.PI * 2; d += 1.2) {
                    ShortExplo shortExplo = new ShortExplo(this.x + (double)((int)((double)this.size * Math.sin(d))) + Ramjet.this.random(-3.0, 3.0), this.y + (double)((int)((double)this.size * Math.cos(d))) + Ramjet.this.random(-3.0, 3.0), this.size / 2, 6, false, true);
                    shortExplo.xspeed = Math.sin(d);
                    shortExplo.yspeed = Math.cos(d);
                }
            }
        }

        public void paint() {
            Ramjet.this.setColor(Ramjet.this.explo_col[(int)this.expiry % 6]);
            if (this.size >= 3) {
                Ramjet.this.drawOval(this.x, this.y, this.size, this.size, true, true);
            } else {
                Ramjet.this.drawLine(this.x, this.y, this.x + 1.0, this.y);
            }
        }
    }

    public class Bullet
    extends JGObject {
        double orient = 0.0;

        public Bullet(double d, double d2, double d3, double d4, double d5) {
            super("bullet", true, d, d2, 2, null, -2);
            this.setBBox(-3, -3, 6, 6);
            this.setSpeed(d3, d4);
            this.orient = d5;
            Ramjet.this.playAudio("shoot");
        }

        public void paint() {
            Ramjet.this.setColor(JGColor.orange);
            Ramjet.this.drawLine(this.x - 5.0 * Math.sin(this.orient), this.y - 5.0 * Math.cos(this.orient), this.x + 5.0 * Math.sin(this.orient), this.y + 5.0 * Math.cos(this.orient));
        }
    }

    public class UfoBullet
    extends JGObject {
        public UfoBullet(double d, double d2, double d3, double d4) {
            super("bullet", true, d, d2, 16, null, d3, d4, -2);
            this.setBBox(-3, -3, 6, 6);
        }

        public void paint() {
            Ramjet.this.setColor(JGColor.yellow);
            Ramjet.this.drawOval((int)this.x, (int)this.y, 5.0 + 3.0 * Math.sin(Ramjet.this.gametime), 5.0 + 3.0 * Math.sin(Ramjet.this.gametime), true, true);
        }
    }

    public class UFO
    extends JGObject {
        int timer = 30;

        public UFO(double d, double d2, double d3, double d4) {
            super("ufo", true, d, d2, 8, null, d3, d4, -2);
            this.setBBox(-5, -5, 10, 10);
        }

        public void move() {
            if (this.timer == 0) {
                this.timer = 100;
                if (Ramjet.this.player != null) {
                    double d = Math.atan2(Ramjet.this.player.x - this.x, Ramjet.this.player.y - this.y);
                    new UfoBullet(this.x, this.y, 3.0 * Math.sin(d), 3.0 * Math.cos(d));
                    Ramjet.this.playAudio("ufoshoot");
                }
            } else {
                --this.timer;
            }
        }

        public void paint() {
            Ramjet.this.setColor(JGColor.pink);
            Ramjet.this.drawLine(this.x, this.y - 6.0, this.x - 6.0, this.y + 6.0);
            Ramjet.this.drawLine(this.x, this.y - 6.0, this.x + 6.0, this.y + 6.0);
            Ramjet.this.drawLine(this.x - 6.0, this.y + 6.0, this.x + 6.0, this.y + 6.0);
        }

        public void hit(JGObject jGObject) {
            this.remove();
            jGObject.remove();
            Ramjet.this.score += 200;
            new ShortExplo(this.x, this.y, 20, 10, true, true);
            new StdScoring("Pts", this.x, this.y, 0.0, -0.5, 50, "200", Ramjet.this.scoringfontl, Ramjet.this.scoringcolors, 4);
        }
    }

    public class Boulder
    extends JGObject {
        int size;

        public Boulder(double d, double d2, double d3, double d4, int n) {
            super("boulder", true, d, d2, 4, null);
            this.setSpeed(d3, d4);
            this.setBBox(-n / 2, -n / 2, n, n);
            this.size = n;
        }

        public void move() {
            if (this.x < (double)this.size && this.xspeed < 0.0) {
                this.xspeed = -this.xspeed;
            }
            if (this.y < (double)this.size && this.yspeed < 0.0) {
                this.yspeed = -this.yspeed;
            }
            if (this.x > (double)(Ramjet.this.pfWidth() - this.size) && this.xspeed > 0.0) {
                this.xspeed = -this.xspeed;
            }
            if (this.y > (double)(Ramjet.this.pfHeight() - this.size) && this.yspeed > 0.0) {
                this.yspeed = -this.yspeed;
            }
        }

        public void paint() {
            Ramjet.this.setColor(JGColor.white);
            Ramjet.this.drawOval((int)this.x, (int)this.y, this.size, this.size, false, true);
        }

        public void hit(JGObject jGObject) {
            this.remove();
            jGObject.remove();
            if (this.size > 18) {
                for (int i = 0; i < 3; ++i) {
                    new Boulder(this.x, this.y, (double)Ramjet.this.random(-1, 1, 2) * Ramjet.this.random(0.5, 1.5), (double)Ramjet.this.random(-1, 1, 2) * Ramjet.this.random(0.5, 1.5), this.size / 2);
                }
                new ShortExplo(this.x, this.y, this.size, 6, true, false);
                Ramjet.this.score += 5;
            } else {
                new ShortExplo(this.x, this.y, this.size, 6, true, true);
                new Bonus(this.x, this.y);
                Ramjet.this.score += 10;
            }
        }
    }
}

