/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.StdScoring;
import jgame.Highscore;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.platform.StdGame;

public class SpaceRun
extends StdGame {
    JGFont scoring_font = new JGFont("Arial", 0, 8.0);

    public static void main(String[] stringArray) {
        new SpaceRun(SpaceRun.parseSizeArgs(stringArray, 0));
    }

    public SpaceRun() {
        this.initEngineApplet();
    }

    public SpaceRun(JGPoint jGPoint) {
        this.initEngine(jGPoint.x, jGPoint.y);
    }

    public void initCanvas() {
        this.setCanvasSettings(20, 15, 16, 16, null, null, null);
    }

    public void initGame() {
        this.defineMedia("space_run.tbl");
        if (this.isMidlet()) {
            this.setFrameRate(20.0, 1.0);
            this.setGameSpeed(2.0);
        } else {
            this.setFrameRate(45.0, 1.0);
        }
        this.setHighscores(10, new Highscore(0, "nobody"), 15);
    }

    public void initNewLife() {
        this.removeObjects(null, 0);
        new Player(16.0, this.pfHeight() / 2, 5.0);
    }

    public void startGameOver() {
        this.removeObjects(null, 0);
    }

    public void doFrameInGame() {
        this.moveObjects();
        this.checkCollision(6, 1);
        if (this.checkTime(0, 800, 8 - this.level / 2)) {
            new JGObject("enemy", true, this.pfWidth(), this.random(0.0, this.pfHeight() - 16), 2, "enemy", 0, 0, 16, 16, -3.0 - (double)this.level, this.random(-1.0, 1.0), -2);
        }
        if (this.checkTime(0, 800, 20 - this.level)) {
            new JGObject("pod", true, this.pfWidth(), this.random(0.0, this.pfHeight() - 16), 4, "pod", 0, 0, 14, 14, -3.0 - (double)this.level, 0.0, -2);
        }
        if (this.gametime >= 800.0 && this.countObjects("enemy", 0) == 0) {
            this.levelDone();
        }
    }

    public void incrementLevel() {
        if (this.level < 7) {
            ++this.level;
        }
        ++this.stage;
    }

    public class Player
    extends JGObject {
        public Player(double d, double d2, double d3) {
            super("player", true, d, d2, 1, "ship", 0, 0, 32, 16, 0, 0, d3, d3, -1);
        }

        public void move() {
            this.setDir(0, 0);
            if (SpaceRun.this.getKey(SpaceRun.this.key_up) && this.y > this.yspeed) {
                this.ydir = -1;
            }
            if (SpaceRun.this.getKey(SpaceRun.this.key_down) && this.y < (double)(SpaceRun.this.pfHeight() - 16) - this.yspeed) {
                this.ydir = 1;
            }
            if (SpaceRun.this.getKey(SpaceRun.this.key_left) && this.x > this.xspeed) {
                this.xdir = -1;
            }
            if (SpaceRun.this.getKey(SpaceRun.this.key_right) && this.x < (double)(SpaceRun.this.pfWidth() - 32) - this.yspeed) {
                this.xdir = 1;
            }
        }

        public void hit(JGObject jGObject) {
            if (Player.and(jGObject.colid, 2)) {
                SpaceRun.this.lifeLost();
            } else {
                SpaceRun.this.score += 5;
                jGObject.remove();
                new StdScoring("pts", jGObject.x, jGObject.y, 0.0, -1.0, 40, "5 pts", SpaceRun.this.scoring_font, new JGColor[]{JGColor.red, JGColor.yellow}, 2);
            }
        }
    }
}

