/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.StdScoring;
import jgame.Highscore;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.platform.StdGame;

public class SpaceRunII
extends StdGame {
    JGFont scoring_font = new JGFont("Arial", 0, 8.0);

    public static void main(String[] stringArray) {
        new SpaceRunII(SpaceRunII.parseSizeArgs(stringArray, 0));
    }

    public SpaceRunII() {
        this.initEngineApplet();
    }

    public SpaceRunII(JGPoint jGPoint) {
        this.initEngine(jGPoint.x, jGPoint.y);
    }

    public void initCanvas() {
        this.setCanvasSettings(20, 15, 16, 16, null, null, null);
    }

    public void initGame() {
        this.defineMedia("space_run.tbl");
        if (this.isMidlet()) {
            this.setFrameRate(20.0, 1.0);
            this.setGameSpeed(2.0);
        } else {
            this.setFrameRate(45.0, 1.0);
        }
        this.lives_img = "ship";
        this.startgame_ingame = true;
        this.leveldone_ingame = true;
        this.title_color = JGColor.yellow;
        this.title_bg_color = new JGColor(140, 0, 0);
        this.title_font = new JGFont("Arial", 0, 20.0);
        this.setHighscores(10, new Highscore(0, "nobody"), 15);
        this.highscore_title_color = JGColor.red;
        this.highscore_title_font = new JGFont("Arial", 0, 20.0);
        this.highscore_color = JGColor.yellow;
        this.highscore_font = new JGFont("Arial", 0, 16.0);
    }

    public void initNewLife() {
        this.removeObjects(null, 0);
        new Player(16.0, this.pfHeight() / 2, 5.0);
    }

    public void startGameOver() {
        this.removeObjects(null, 0);
    }

    public void doFrameInGame() {
        this.moveObjects();
        this.checkCollision(6, 1);
        if (this.checkTime(0, 800, 8 - this.level / 2)) {
            new JGObject("enemy", true, this.pfWidth(), this.random(0.0, this.pfHeight() - 16), 2, "enemy", 0, 0, 16, 16, -3.0 - (double)this.level, this.random(-1.0, 1.0), -2);
        }
        if (this.checkTime(0, 800, 20 - this.level)) {
            new JGObject("pod", true, this.pfWidth(), this.random(0.0, this.pfHeight() - 16), 4, "pod", 0, 0, 14, 14, -3.0 - (double)this.level, 0.0, -2);
        }
        if (this.gametime >= 800.0 && this.countObjects("enemy", 0) == 0) {
            this.levelDone();
        }
    }

    public void incrementLevel() {
        if (this.level < 7) {
            ++this.level;
        }
        ++this.stage;
    }

    public void paintFrameLifeLost() {
        this.setColor(this.title_bg_color);
        this.drawRect(160.0, 50.0, this.seqtimer * 7.0, this.seqtimer * 5.0, true, true, false);
        int n = this.posWalkForwards(-24, this.viewHeight(), this.seqtimer, 80, 50, 20, 10);
        this.drawString("You're hit !", 160.0, n, 0, this.getZoomingFont(this.title_font, this.seqtimer, 0.2, 0.025), this.title_color);
    }

    public void paintFrameGameOver() {
        this.setColor(this.title_bg_color);
        this.setStroke(1.0);
        this.drawRect(160.0, 51.0, this.seqtimer * 2.0, this.seqtimer / 2.0, true, true, false);
        this.drawString("Game Over !", 160.0, 50.0, 0, this.getZoomingFont(this.title_font, this.seqtimer, 0.2, 0.008333333333333333), this.title_color);
    }

    public void paintFrameStartGame() {
        this.drawString("Get Ready!", 160.0, 50.0, 0, this.getZoomingFont(this.title_font, this.seqtimer, 0.2, 0.0125), this.title_color);
    }

    public void paintFrameStartLevel() {
        this.drawString("Stage " + (this.stage + 1), 160.0, 50.0 + this.seqtimer, 0, this.getZoomingFont(this.title_font, this.seqtimer, 0.2, 0.0125), this.title_color);
    }

    public void paintFrameLevelDone() {
        this.drawString("Stage " + (this.stage + 1) + " Clear !", 160.0, 50.0, 0, this.getZoomingFont(this.title_font, this.seqtimer + 80.0, 0.2, 0.0125), this.title_color);
    }

    public void paintFrameTitle() {
        this.drawString("Space Run III", 160.0, 50.0, 0, this.getZoomingFont(this.title_font, this.seqtimer + 20.0, 0.3, 0.03), this.title_color);
        this.drawString("Press " + this.getKeyDesc(this.key_startgame) + " to start", 160.0, 120.0, 0, this.getZoomingFont(this.title_font, this.seqtimer + 5.0, 0.3, 0.03), this.title_color);
        if (!this.isMidlet()) {
            this.drawString("Press " + this.getKeyDesc(this.key_gamesettings) + " for settings", 160.0, 160.0, 0, this.getZoomingFont(this.title_font, this.seqtimer, 0.3, 0.03), this.title_color);
        }
    }

    public class Player
    extends JGObject {
        public Player(double d, double d2, double d3) {
            super("player", true, d, d2, 1, "ship", 0, 0, 32, 16, 0, 0, d3, d3, -1);
        }

        public void move() {
            this.setDir(0, 0);
            if (SpaceRunII.this.getKey(SpaceRunII.this.key_up) && this.y > this.yspeed) {
                this.ydir = -1;
            }
            if (SpaceRunII.this.getKey(SpaceRunII.this.key_down) && this.y < (double)(SpaceRunII.this.pfHeight() - 16) - this.yspeed) {
                this.ydir = 1;
            }
            if (SpaceRunII.this.getKey(SpaceRunII.this.key_left) && this.x > this.xspeed) {
                this.xdir = -1;
            }
            if (SpaceRunII.this.getKey(SpaceRunII.this.key_right) && this.x < (double)(SpaceRunII.this.pfWidth() - 32) - this.yspeed) {
                this.xdir = 1;
            }
        }

        public void hit(JGObject jGObject) {
            if (Player.and(jGObject.colid, 2)) {
                SpaceRunII.this.lifeLost();
            } else {
                SpaceRunII.this.score += 5;
                jGObject.remove();
                new StdScoring("pts", jGObject.x, jGObject.y, 0.0, -1.0, 40, "5 pts", SpaceRunII.this.scoring_font, new JGColor[]{JGColor.red, JGColor.yellow}, 2);
            }
        }
    }
}

