/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.StdScoring;
import jgame.Highscore;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.platform.StdGame;

public class SpaceRunIII
extends StdGame {
    JGFont scoring_font = new JGFont("Arial", 0, 8.0);

    public static void main(String[] stringArray) {
        new SpaceRunIII(SpaceRunIII.parseSizeArgs(stringArray, 0));
    }

    public SpaceRunIII() {
        this.initEngineApplet();
    }

    public SpaceRunIII(JGPoint jGPoint) {
        this.initEngine(jGPoint.x, jGPoint.y);
    }

    public void initCanvas() {
        this.setCanvasSettings(20, 15, 16, 16, null, null, null);
        if (this.isMidlet()) {
            this.setScalingPreferences(0.75, 1.3333333333333333, 0, 7, 0, 7);
        }
    }

    public void initGame() {
        this.defineMedia("space_run.tbl");
        if (this.isMidlet()) {
            this.setFrameRate(18.0, 1.0);
            this.setGameSpeed(2.0);
        } else {
            this.setFrameRate(45.0, 1.0);
        }
        this.lives_img = "ship";
        this.startgame_ingame = true;
        this.leveldone_ingame = true;
        this.title_color = JGColor.yellow;
        this.title_bg_color = new JGColor(140, 0, 0);
        this.title_font = new JGFont("Arial", 0, 20.0);
        this.setHighscores(10, new Highscore(0, "nobody"), 15);
        this.highscore_title_color = JGColor.red;
        this.highscore_title_font = new JGFont("Arial", 0, 20.0);
        this.highscore_color = JGColor.yellow;
        this.highscore_font = new JGFont("Arial", 0, 16.0);
    }

    public void defineLevel() {
        this.removeObjects(null, 0);
        switch (this.stage % 2) {
            case 0: {
                this.leveldone_ingame = true;
                this.setPFSize(150, 40);
                this.setPFWrap(false, false, 0, 0);
                int n = 11 - this.level / 2;
                int n2 = this.pfTilesY() / 2 - n / 2;
                this.fillBG("#");
                int n3 = 15;
                int n4 = 0;
                for (int i = 0; i < this.pfTilesX(); ++i) {
                    for (int j = n2; j < n2 + n; ++j) {
                        this.setTile(i, j, "");
                    }
                    if (n3 > 0) {
                        --n3;
                        continue;
                    }
                    if (this.random(0.0, 5.0) < 1.0) {
                        new JGObject("enemy", true, this.tileWidth() * i, this.tileHeight() * (n4 + n / 2), 2, "enemy", 0, 0, 16, 16, -1.0, 0.0, -4);
                    }
                    if (this.random(0.0, 5.0) < 1.0) {
                        new JGObject("pod", true, this.tileWidth() * i, this.tileHeight() * (n4 + this.random(2, n - 3, 1)), 4, "pod", 0, 0, 14, 14, 0.0, 0.0, -4);
                    }
                    n4 = n2;
                    if ((n2 += this.random(-1, 1, 2)) < 1) {
                        n2 = 1;
                    }
                    if (n2 + n < this.pfTilesY() - 1) continue;
                    n2 = this.pfTilesY() - n - 1;
                }
                break;
            }
            case 1: {
                this.leveldone_ingame = false;
                this.setPFSize(21, 16);
                this.setPFWrap(true, true, -8, -8);
                this.fillBG("");
                for (int i = 0; i < 5 + this.level / 2; ++i) {
                    new BombDropper();
                    new JGObject("pod", true, this.random(this.pfWidth() / 2, this.pfWidth()), this.random(0.0, this.pfHeight()), 4, "pod", 0, 0, 14, 14, 0.0, this.random(0.5, 1.2), -1);
                }
                break;
            }
        }
        new Player(0.0, this.pfHeight() / 2, 3.0);
    }

    public void initNewLife() {
        this.defineLevel();
    }

    public void startGameOver() {
        this.removeObjects(null, 0);
    }

    public void doFrameInGame() {
        this.moveObjects();
        this.checkCollision(6, 1);
        this.checkBGCollision(1, 1);
        if (this.stage % 2 == 1 && this.countObjects("pod", 0) == 0) {
            this.levelDone();
        }
        this.setViewOffset((int)this.getObject((String)"player").x + 100, (int)this.getObject((String)"player").y, true);
    }

    public void incrementLevel() {
        if (this.level < 10) {
            ++this.level;
        }
        ++this.stage;
    }

    public void paintFrameLifeLost() {
        this.setColor(this.title_bg_color);
        this.drawRect(160.0, 50.0, this.seqtimer * 7.0, this.seqtimer * 5.0, true, true, false);
        int n = this.posWalkForwards(-24, this.viewHeight(), this.seqtimer, 80, 50, 20, 10);
        this.drawString("You're hit !", 160.0, n, 0, this.getZoomingFont(this.title_font, this.seqtimer, 0.2, 0.025), this.title_color);
    }

    public void paintFrameGameOver() {
        this.setColor(this.title_bg_color);
        this.setStroke(1.0);
        this.drawRect(160.0, 51.0, this.seqtimer * 2.0, this.seqtimer / 2.0, true, true, false);
        this.drawString("Game Over !", 160.0, 50.0, 0, this.getZoomingFont(this.title_font, this.seqtimer, 0.2, 0.008333333333333333), this.title_color);
    }

    public void paintFrameStartGame() {
        this.drawString("Get Ready!", 160.0, 50.0, 0, this.getZoomingFont(this.title_font, this.seqtimer, 0.2, 0.0125), this.title_color);
    }

    public void paintFrameStartLevel() {
        this.drawString("Stage " + (this.stage + 1), 160.0, 50.0 + this.seqtimer, 0, this.getZoomingFont(this.title_font, this.seqtimer, 0.2, 0.0125), this.title_color);
    }

    public void paintFrameLevelDone() {
        this.drawString("Stage " + (this.stage + 1) + " Clear !", 160.0, 50.0, 0, this.getZoomingFont(this.title_font, this.seqtimer + 80.0, 0.2, 0.0125), this.title_color);
    }

    public void paintFrameTitle() {
        this.drawString("Space Run III", 160.0, 50.0, 0, this.getZoomingFont(this.title_font, this.seqtimer + 20.0, 0.3, 0.03), this.title_color);
        this.drawString("Press " + this.getKeyDesc(this.key_startgame) + " to start", 160.0, 120.0, 0, this.getZoomingFont(this.title_font, this.seqtimer + 5.0, 0.3, 0.03), this.title_color);
        if (!this.isMidlet()) {
            this.drawString("Press " + this.getKeyDesc(this.key_gamesettings) + " for settings", 160.0, 160.0, 0, this.getZoomingFont(this.title_font, this.seqtimer, 0.3, 0.03), this.title_color);
        }
    }

    class BombDropper
    extends JGObject {
        public BombDropper() {
            super("enemy", true, SpaceRunIII.this.random(SpaceRunIII.this.pfWidth() / 3, SpaceRunIII.this.pfWidth()), SpaceRunIII.this.random(0.0, SpaceRunIII.this.pfHeight()), 2, "enemy");
            this.setSpeed(SpaceRunIII.this.random(-0.7, -0.3), SpaceRunIII.this.random(-0.5, 0.5));
        }

        public void move() {
            if (SpaceRunIII.this.random(0.0, 1.0) < 0.005) {
                JGPoint jGPoint = this.getCenterTile();
                SpaceRunIII.this.setTile(jGPoint.x, jGPoint.y, "#");
            }
        }
    }

    public class Player
    extends JGObject {
        public Player(double d, double d2, double d3) {
            super("player", false, d, d2, 1, "ship", 0, 0, d3, d3, -1);
        }

        public void move() {
            this.setDir(0, 0);
            if (SpaceRunIII.this.getKey(SpaceRunIII.this.key_up)) {
                this.ydir = -1;
            }
            if (SpaceRunIII.this.getKey(SpaceRunIII.this.key_down)) {
                this.ydir = 1;
            }
            this.x = SpaceRunIII.this.getKey(SpaceRunIII.this.key_right) ? (this.x += SpaceRunIII.this.getGameSpeed() * 3.0 * this.xspeed / 2.0) : (this.x += SpaceRunIII.this.getGameSpeed() * this.xspeed);
            if (!this.isOnPF(0, 0)) {
                SpaceRunIII.this.levelDone();
            }
        }

        public void hit(JGObject jGObject) {
            if (Player.and(jGObject.colid, 2)) {
                SpaceRunIII.this.lifeLost();
            } else {
                SpaceRunIII.this.score += 5;
                jGObject.remove();
                new StdScoring("pts", jGObject.x, jGObject.y, 0.0, -1.0, 40, "5 pts", SpaceRunIII.this.scoring_font, new JGColor[]{JGColor.red, JGColor.yellow}, 2);
            }
        }

        public void hit_bg(int n) {
            SpaceRunIII.this.lifeLost();
        }
    }
}

