/*
 * Decompiled with CFR 0.152.
 */
package examples.ogrotron;

import jgame.Highscore;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.platform.StdGame;

public class Ogrotron
extends StdGame {
    Player player = null;
    JGFont scoring_font = new JGFont("Arial", 0, 8.0);

    public static void main(String[] stringArray) {
        new Ogrotron(Ogrotron.parseSizeArgs(stringArray, 0));
    }

    public Ogrotron() {
        this.initEngineApplet();
    }

    public Ogrotron(JGPoint jGPoint) {
        this.initEngine(jGPoint.x, jGPoint.y);
    }

    public void initCanvas() {
        this.setCanvasSettings(15, 15, 8, 8, null, null, null);
    }

    public void initGame() {
        this.defineMedia("ogrotron.tbl");
        this.setSmoothing(false);
        this.setVideoSyncedUpdate(true);
        if (this.isMidlet()) {
            this.setFrameRate(22.0, 1.0);
            this.setGameSpeed(2.0);
        } else {
            this.setFrameRate(45.0, 1.0);
            this.title_font = new JGFont("Arial", 0, 11.0);
            this.highscore_title_font = new JGFont("Arial", 0, 11.0);
            this.highscore_font = new JGFont("Arial", 0, 11.0);
        }
        this.leveldone_ingame = true;
        this.startgame_ingame = true;
        this.lifelost_ingame = true;
        this.setHighscores(10, new Highscore(0, "nobody"), 15);
    }

    public void doFrameTitle() {
        if (this.getMouseButton(1)) {
            this.clearMouseButton(1);
            this.startGame();
        }
    }

    public void defineLevel() {
        int n;
        this.removeObjects(null, 0);
        this.fillBG("");
        this.player = new Player(this.pfWidth() / 2, this.pfHeight() / 2);
        for (n = 0; n < 8 + this.level * 2; ++n) {
            new Ogre(this.random(0.0, this.pfWidth() - 8), this.random(0.0, this.pfWidth() - 8), this.random(0.45, 0.9));
        }
        for (n = 0; n < 8 + this.level; ++n) {
            this.setTile(this.random(0, this.pfTilesX(), 1), this.random(0, this.pfTilesY(), 1), this.level % 2 == 0 ? "$" : "%");
        }
    }

    public void initNewLife() {
        this.player = new Player(this.pfWidth() / 2, this.pfHeight() / 2);
    }

    public void startGameOver() {
        this.removeObjects(null, 0);
    }

    public void doFrameInGame() {
        this.moveObjects();
        this.checkCollision(12, 1);
        this.checkBGCollision(1, 1);
        this.checkCollision(2, 4);
        if (this.countObjects("ogre", 0) == 0) {
            this.levelDone();
        }
    }

    public void incrementLevel() {
        if (this.level < 8) {
            ++this.level;
        }
        ++this.stage;
    }

    public class Player
    extends JGObject {
        double bullettimer = 0.0;
        double invultimer = 100.0;
        double bulxspeed = 0.0;
        double bulyspeed = 0.0;

        public Player(double d, double d2) {
            super("player", false, d, d2, 1, "player", 1.0, 1.0, -1);
        }

        public void move() {
            if (Ogrotron.this.getMouseButton(1)) {
                double d = Ogrotron.this.atan2((double)Ogrotron.this.getMouseX() - this.x, (double)Ogrotron.this.getMouseY() - this.y);
                this.xspeed = 2.0 * Math.sin(d);
                this.yspeed = 2.0 * Math.cos(d);
                this.xdir = 1;
                this.ydir = 1;
                this.bulxspeed = this.xspeed * (double)this.xdir;
                this.bulyspeed = this.yspeed * (double)this.ydir;
                if (this.xspeed < 0.0) {
                    this.setGraphic("player_l");
                } else {
                    this.setGraphic("player_r");
                }
            } else {
                this.xspeed = 2.0;
                this.yspeed = 2.0;
                this.setDir(0, 0);
                if (Ogrotron.this.getKey(Ogrotron.this.key_up) && this.y > this.yspeed) {
                    this.ydir = -1;
                }
                if (Ogrotron.this.getKey(Ogrotron.this.key_down) && this.y < (double)(Ogrotron.this.pfHeight() - 8)) {
                    this.ydir = 1;
                }
                if (Ogrotron.this.getKey(Ogrotron.this.key_left) && this.x > this.xspeed) {
                    this.xdir = -1;
                    this.setGraphic("player_l");
                }
                if (Ogrotron.this.getKey(Ogrotron.this.key_right) && this.x < (double)(Ogrotron.this.pfWidth() - 8)) {
                    this.xdir = 1;
                    this.setGraphic("player_r");
                }
                if (this.xdir != 0 || this.ydir != 0) {
                    this.bulxspeed = this.xspeed * (double)this.xdir;
                    this.bulyspeed = this.yspeed * (double)this.ydir;
                }
            }
            if (this.bullettimer <= 0.0) {
                if (this.bulxspeed != 0.0 || this.bulyspeed != 0.0) {
                    this.bullettimer = 8.0;
                    new JGObject("bullet", true, this.x, this.y, 2, "bullet", -2.0 * this.bulxspeed, -2.0 * this.bulyspeed, -2);
                }
            } else {
                this.bullettimer -= gamespeed;
            }
            this.invultimer -= gamespeed;
        }

        public void hit_bg(int n, int n2, int n3) {
            Ogrotron.this.setTile(n2, n3, "");
            Ogrotron.this.score += 25;
            new JGObject("pts", true, n2 * tilewidth, n3 * tileheight, 0, "pts", 0.0, -0.25, 80);
        }

        public void hit(JGObject jGObject) {
            if (this.invultimer < 0.0) {
                this.remove();
                Ogrotron.this.lifeLost();
                new JGObject("explo", true, this.x, this.y, 0, "explo_u", 0.0, -3.0, -2);
                new JGObject("explo", true, this.x, this.y, 0, "explo_d", 0.0, 3.0, -2);
                new JGObject("explo", true, this.x, this.y, 0, "explo_u", 0.0, -1.5, -2);
                new JGObject("explo", true, this.x, this.y, 0, "explo_d", 0.0, 1.5, -2);
            }
        }
    }

    class Ogre
    extends JGObject {
        double newdirtimer = 0.0;

        Ogre(double d, double d2, double d3) {
            super("ogre", true, d, d2, 4, Ogrotron.this.level % 2 == 0 ? "ogre" : "ogre2", d3, d3, -1);
        }

        public void move() {
            if (this.newdirtimer <= 0.0) {
                this.newdirtimer = Ogrotron.this.random(15.0, 35.0);
                if (Ogrotron.this.player != null) {
                    if (Ogrotron.this.random(0.0, 1.0) > 0.5) {
                        this.xdir = Ogrotron.this.player.x > this.x ? 1 : -1;
                        this.ydir = Ogrotron.this.random(-1, 1, 1);
                    } else {
                        this.ydir = Ogrotron.this.player.y > this.y ? 1 : -1;
                        this.xdir = Ogrotron.this.random(-1, 1, 1);
                    }
                }
                if (this.x < 0.0 && this.xdir <= 0) {
                    this.xdir = 1;
                }
                if (this.x > (double)pfwidth && this.xdir >= 0) {
                    this.xdir = -1;
                }
                if (this.y < 0.0 && this.ydir <= 0) {
                    this.ydir = 1;
                }
                if (this.y > (double)pfheight && this.ydir >= 0) {
                    this.ydir = -1;
                }
            } else {
                this.newdirtimer -= gamespeed;
            }
        }

        public void hit(JGObject jGObject) {
            Ogrotron.this.score += 10;
            this.remove();
            jGObject.remove();
            new JGObject("explo", true, this.x, this.y, 0, "explo_u", 0.0, -4.0, -2);
            new JGObject("explo", true, this.x, this.y, 0, "explo_d", 0.0, 4.0, -2);
        }
    }
}

