/*
 * Decompiled with CFR 0.152.
 */
package jgame;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;
import jgame.impl.EngineLogic;

public class Highscore {
    public int score;
    public String name;
    public String[] fields = null;

    public Highscore(int n, String string) {
        this.score = n;
        this.name = string;
    }

    public Highscore(int n, String string, String string2) {
        this.score = n;
        this.name = string;
        this.fields = new String[]{string2};
    }

    public Highscore(int n, String string, String string2, String string3) {
        this.score = n;
        this.name = string;
        this.fields = new String[]{string2, string3};
    }

    public Highscore(int n, String string, String string2, String string3, String string4) {
        this.score = n;
        this.name = string;
        this.fields = new String[]{string2, string3, string4};
    }

    public static int findPos(Highscore[] highscoreArray, int n) {
        for (int i = 0; i < highscoreArray.length; ++i) {
            if (n <= highscoreArray[i].score) continue;
            return i;
        }
        return -1;
    }

    public static Highscore[] insert(Highscore[] highscoreArray, Highscore highscore) {
        if (Highscore.findPos(highscoreArray, highscore.score) >= 0) {
            highscoreArray[highscoreArray.length - 1] = highscore;
            return Highscore.sort(highscoreArray);
        }
        return highscoreArray;
    }

    public static Highscore[] load(InputStream inputStream) throws IOException {
        Highscore[] highscoreArray;
        String string;
        Vector<Object> vector = new Vector<Object>(20, 40);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        while ((string = EngineLogic.readline(inputStreamReader)) != null) {
            highscoreArray = new Vector(5, 10);
            Vector vector2 = EngineLogic.tokenizeString(string, '\t');
            Object object = vector2.elements();
            while (object.hasMoreElements()) {
                String string2 = (String)object.nextElement();
                if (string2.equals("`")) {
                    string2 = "";
                }
                highscoreArray.addElement(string2);
            }
            object = null;
            if (highscoreArray.size() == 1) {
                object = new Highscore(Integer.parseInt((String)highscoreArray.elementAt(0)), "");
            }
            if (highscoreArray.size() >= 2) {
                object = new Highscore(Integer.parseInt((String)highscoreArray.elementAt(0)), (String)highscoreArray.elementAt(1));
            }
            if (highscoreArray.size() >= 3) {
                ((Highscore)object).fields = new String[highscoreArray.size() - 2];
                for (int i = 2; i < highscoreArray.size(); ++i) {
                    ((Highscore)object).fields[i - 2] = (String)highscoreArray.elementAt(i);
                }
            }
            vector.addElement(object);
        }
        highscoreArray = new Highscore[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            highscoreArray[i] = (Highscore)vector.elementAt(i);
        }
        return highscoreArray;
    }

    public static void save(Highscore[] highscoreArray, OutputStream outputStream) throws IOException {
        PrintStream printStream = new PrintStream(outputStream);
        for (int i = 0; i < highscoreArray.length; ++i) {
            printStream.print(highscoreArray[i].score);
            printStream.print('\t');
            if (highscoreArray[i].name.equals("")) {
                printStream.print("`");
            } else {
                printStream.print(highscoreArray[i].name);
            }
            if (highscoreArray[i].fields != null) {
                for (int j = 0; j < highscoreArray[i].fields.length; ++j) {
                    printStream.print('\t');
                    printStream.print(highscoreArray[i].fields[j]);
                }
            }
            printStream.println();
        }
        printStream.flush();
    }

    static Highscore[] sort(Highscore[] highscoreArray) {
        int n;
        int n2 = highscoreArray.length - 1;
        for (int i = n = (n2 - 1) / 2; i >= 0; --i) {
            Highscore.BubbleDown(n2, i, highscoreArray);
        }
        while (n2 > 0) {
            Highscore.swap(highscoreArray, 0, n2);
            Highscore.BubbleDown(--n2, 0, highscoreArray);
        }
        return highscoreArray;
    }

    private static void BubbleDown(int n, int n2, Highscore[] highscoreArray) {
        int n3 = (n2 + 1) * 2 - 1;
        if (n3 < n && highscoreArray[n3 + 1].score < highscoreArray[n3].score) {
            ++n3;
        }
        if (n3 <= n && highscoreArray[n2].score > highscoreArray[n3].score) {
            Highscore.swap(highscoreArray, n2, n3);
            Highscore.BubbleDown(n, n3, highscoreArray);
        }
    }

    private static void swap(Highscore[] highscoreArray, int n, int n2) {
        Highscore highscore = highscoreArray[n];
        highscoreArray[n] = highscoreArray[n2];
        highscoreArray[n2] = highscore;
    }
}

