/*
 * Decompiled with CFR 0.152.
 */
package jgame.platform;

import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGImage;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.JGRectangle;
import jgame.JGTimer;
import jgame.impl.Animation;
import jgame.impl.EngineLogic;
import jgame.impl.JGEngineInterface;
import jgame.impl.JGameError;
import jgame.impl.SortedArray;
import jgame.platform.JREEngine;
import jgame.platform.JREImage;

public abstract class JGEngine
extends Applet
implements JGEngineInterface {
    JREImage imageutil = new JREImage();
    EngineLogic el = new EngineLogic(this.imageutil, true, true);
    JREEngine jre = new JREEngine(this.el, this);
    private Thread thread = null;
    JGCanvas canvas = null;
    boolean running = true;
    boolean i_am_applet = false;
    public static final int KeyBackspace = 8;
    public static final int KeyTab = 9;
    Graphics buf_gfx = null;
    Image background = null;
    Image buffer = null;
    Graphics bgg = null;
    int debugflags = 8;
    static final int BBOX_DEBUG = 1;
    static final int GAMESTATE_DEBUG = 2;
    static final int FULLSTACKTRACE_DEBUG = 4;
    static final int MSGSINPF_DEBUG = 8;
    private static int dbgframelog_expiry = 80;
    private JGFont debugmessage_font = new JGFont("Arial", 0, 12.0);
    JGColor debug_auxcolor1 = JGColor.green;
    JGColor debug_auxcolor2 = JGColor.magenta;
    private Hashtable dbgframelogs = new Hashtable();
    private Hashtable dbgnewframelogs = new Hashtable();
    private Hashtable dbgframelogs_new = new Hashtable();
    private Hashtable dbgframelogs_obj = new Hashtable();
    private Hashtable dbgframelogs_dead = new Hashtable();
    private BufferedImage null_image = new BufferedImage(1, 1, 2);

    public JGImage getImage(String string) {
        return this.el.getImage(string);
    }

    public JGPoint getImageSize(String string) {
        return this.el.getImageSize(string);
    }

    public void defineImage(String string, String string2, int n, String string3, String string4, int n2, int n3, int n4, int n5) {
        this.el.defineImage(this, string, string2, n, string3, string4, n2, n3, n4, n5);
    }

    public void defineImage(String string, String string2, int n, String string3, String string4) {
        this.el.defineImage(this, string, string2, n, string3, string4);
    }

    public void defineImage(String string, String string2, int n, String string3, int n2, String string4, int n3, int n4, int n5, int n6) {
        this.el.defineImage(string, string2, n, string3, n2, string4, n3, n4, n5, n6);
    }

    public void defineImage(String string, String string2, int n, String string3, int n2, String string4) {
        this.el.defineImage(string, string2, n, string3, n2, string4);
    }

    public void defineImageRotated(String string, String string2, int n, String string3, double d) {
        this.el.defineImageRotated(this, string, string2, n, string3, d);
    }

    public void defineImageMap(String string, String string2, int n, int n2, int n3, int n4, int n5, int n6) {
        this.el.defineImageMap(this, string, string2, n, n2, n3, n4, n5, n6);
    }

    public JGRectangle getImageBBox(String string) {
        return this.el.getImageBBox(string);
    }

    public void defineMedia(String string) {
        this.el.defineMedia(this, string);
    }

    public void markAddObject(JGObject jGObject) {
        this.el.markAddObject(jGObject);
    }

    public boolean existsObject(String string) {
        return this.el.existsObject(string);
    }

    public JGObject getObject(String string) {
        return this.el.getObject(string);
    }

    public void moveObjects(String string, int n) {
        this.el.moveObjects(this, string, n);
    }

    public void moveObjects() {
        this.el.moveObjects(this);
    }

    public void checkCollision(int n, int n2) {
        this.el.checkCollision(this, n, n2);
    }

    public int checkCollision(int n, JGObject jGObject) {
        return this.el.checkCollision(n, jGObject);
    }

    public int checkBGCollision(JGRectangle jGRectangle) {
        return this.el.checkBGCollision(jGRectangle);
    }

    public void checkBGCollision(int n, int n2) {
        this.el.checkBGCollision(this, n, n2);
    }

    public Vector getObjects(String string, int n, boolean bl, JGRectangle jGRectangle) {
        return this.el.getObjects(string, n, bl, jGRectangle);
    }

    public void removeObject(JGObject jGObject) {
        this.el.removeObject(jGObject);
    }

    public void removeObjects(String string, int n) {
        this.el.removeObjects(string, n);
    }

    public void removeObjects(String string, int n, boolean bl) {
        this.el.removeObjects(string, n, bl);
    }

    public int countObjects(String string, int n) {
        return this.el.countObjects(string, n);
    }

    public int countObjects(String string, int n, boolean bl) {
        return this.el.countObjects(string, n, bl);
    }

    void drawObject(Graphics graphics, JGObject jGObject) {
        if (!jGObject.is_suspended) {
            this.drawImage(graphics, (int)jGObject.x, (int)jGObject.y, jGObject.getImageName(), true);
            try {
                jGObject.paint();
            }
            catch (JGameError jGameError) {
                this.exitEngine(this.dbgExceptionToString(jGameError));
            }
            catch (Exception exception) {
                this.dbgShowException(jGObject.getName(), exception);
            }
        }
        if ((this.debugflags & 1) != 0) {
            this.setColor(graphics, this.el.fg_color);
            JGRectangle jGRectangle = jGObject.getBBox();
            if (jGRectangle != null) {
                jGRectangle = this.el.scalePos(jGRectangle, true);
                graphics.drawRect(jGRectangle.x, jGRectangle.y, jGRectangle.width, jGRectangle.height);
            }
            if ((jGRectangle = jGObject.getTileBBox()) != null) {
                jGRectangle = this.el.scalePos(jGRectangle, true);
                graphics.drawRect(jGRectangle.x, jGRectangle.y, jGRectangle.width, jGRectangle.height);
                this.setColor(graphics, this.debug_auxcolor1);
                jGRectangle = jGObject.getTileBBox();
                jGRectangle = this.getTiles(jGRectangle);
                jGRectangle.x *= this.el.tilex;
                jGRectangle.y *= this.el.tiley;
                jGRectangle.width *= this.el.tilex;
                jGRectangle.height *= this.el.tiley;
                jGRectangle = this.el.scalePos(jGRectangle, true);
                graphics.drawRect(jGRectangle.x, jGRectangle.y, jGRectangle.width, jGRectangle.height);
                this.setColor(graphics, this.debug_auxcolor2);
                jGRectangle = jGObject.getCenterTiles();
                jGRectangle.x *= this.el.tilex;
                jGRectangle.y *= this.el.tiley;
                jGRectangle.width *= this.el.tilex;
                jGRectangle.height *= this.el.tiley;
                jGRectangle = this.el.scalePos(jGRectangle, true);
                graphics.drawRect(jGRectangle.x + 2, jGRectangle.y + 2, jGRectangle.width - 4, jGRectangle.height - 4);
            }
        }
    }

    public void setBGImage(String string) {
        this.el.setBGImage(string, 0, true, true);
    }

    public void setBGImage(int n, String string, boolean bl, boolean bl2) {
        this.el.setBGImage(string, n, bl, bl2);
    }

    public void setTileSettings(String string, int n, int n2) {
        this.el.setTileSettings(string, n, n2);
    }

    public void fillBG(String string) {
        this.el.fillBG(string);
    }

    public void setTileCid(int n, int n2, int n3, int n4) {
        this.el.setTileCid(n, n2, n3, n4);
    }

    public void setTile(int n, int n2, String string) {
        this.el.setTile(n, n2, string);
    }

    void setColor(Graphics graphics, JGColor jGColor) {
        jGColor.impl = new Color(jGColor.r, jGColor.g, jGColor.b);
        graphics.setColor((Color)jGColor.impl);
    }

    public void drawTile(int n, int n2, int n3) {
        Integer n4;
        JREImage jREImage;
        if (this.background == null) {
            return;
        }
        int n5 = this.el.moduloFloor(n + 1, this.el.viewnrtilesx + 3) * this.el.scaledtilex;
        int n6 = this.el.moduloFloor(n2 + 1, this.el.viewnrtilesy + 3) * this.el.scaledtiley;
        if (this.bgg == null) {
            this.bgg = this.background.getGraphics();
        }
        if ((jREImage = (JREImage)this.el.getTileImage(n4 = new Integer(n3))) == null || this.el.images_transp.containsKey(n4)) {
            EngineLogic.BGImage bGImage = (EngineLogic.BGImage)this.el.bg_images.get(0);
            if (bGImage == null) {
                this.setColor(this.bgg, this.el.bg_color);
                this.bgg.fillRect(n5, n6, this.el.scaledtilex, this.el.scaledtiley);
            } else {
                int n7 = this.el.moduloFloor(n, bGImage.tiles.x);
                int n8 = this.el.moduloFloor(n2, bGImage.tiles.y);
                this.bgg.drawImage(((JREImage)this.el.getImage((String)bGImage.imgname)).img, n5, n6, n5 + this.el.scaledtilex, n6 + this.el.scaledtiley, n7 * this.el.scaledtilex, n8 * this.el.scaledtiley, (n7 + 1) * this.el.scaledtilex, (n8 + 1) * this.el.scaledtiley, (Color)this.el.bg_color.impl, null);
            }
        }
        if (jREImage != null) {
            this.bgg.drawImage(jREImage.img, n5, n6, this);
        }
    }

    public int countTiles(int n) {
        return this.el.countTiles(n);
    }

    public int getTileCid(int n, int n2) {
        return this.el.getTileCid(n, n2);
    }

    public String getTileStr(int n, int n2) {
        return this.el.getTileStr(n, n2);
    }

    public int getTileCid(JGRectangle jGRectangle) {
        return this.el.getTileCid(jGRectangle);
    }

    public JGRectangle getTiles(JGRectangle jGRectangle) {
        return this.el.getTiles(jGRectangle);
    }

    public boolean getTiles(JGRectangle jGRectangle, JGRectangle jGRectangle2) {
        return this.el.getTiles(jGRectangle, jGRectangle2);
    }

    public void setTileCid(int n, int n2, int n3) {
        this.el.setTileCid(n, n2, n3);
    }

    public void orTileCid(int n, int n2, int n3) {
        this.el.orTileCid(n, n2, n3);
    }

    public void andTileCid(int n, int n2, int n3) {
        this.el.andTileCid(n, n2, n3);
    }

    public void setTile(JGPoint jGPoint, String string) {
        this.el.setTile(jGPoint, string);
    }

    public void setTiles(int n, int n2, String[] stringArray) {
        this.el.setTiles(n, n2, stringArray);
    }

    public void setTilesMulti(int n, int n2, String[] stringArray) {
        this.el.setTilesMulti(n, n2, stringArray);
    }

    public int getTileCidAtCoord(double d, double d2) {
        return this.el.getTileCidAtCoord(d, d2);
    }

    public int getTileCid(JGPoint jGPoint, int n, int n2) {
        return this.el.getTileCid(jGPoint, n, n2);
    }

    public String getTileStrAtCoord(double d, double d2) {
        return this.el.getTileStrAtCoord(d, d2);
    }

    public String getTileStr(JGPoint jGPoint, int n, int n2) {
        return this.el.getTileStr(jGPoint, n, n2);
    }

    public int tileStrToID(String string) {
        return this.el.tileStrToID(string);
    }

    public String tileIDToStr(int n) {
        return this.el.tileIDToStr(n);
    }

    void copyBGToBuf(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n3 <= n || n4 <= n2) {
            return;
        }
        int n7 = this.el.scaleXPos(this.el.moduloFloor(this.el.xofs, this.el.tilex), false);
        int n8 = this.el.scaleYPos(this.el.moduloFloor(this.el.yofs, this.el.tiley), false);
        int n9 = n == 0 ? n7 : 0;
        int n10 = n2 == 0 ? n8 : 0;
        n7 = n == 0 ? 0 : n7;
        n8 = n2 == 0 ? 0 : n8;
        int n11 = n5 + n3 - n;
        int n12 = n6 + n4 - n2;
        graphics.drawImage(this.background, n5 * this.el.scaledtilex - n9, n6 * this.el.scaledtiley - n10, n11 * this.el.scaledtilex - n9, n12 * this.el.scaledtiley - n10, n7 + n * this.el.scaledtilex, n8 + n2 * this.el.scaledtiley, n7 + n3 * this.el.scaledtilex, n8 + n4 * this.el.scaledtiley, this);
    }

    public double moduloXPos(double d) {
        return this.el.moduloXPos(d);
    }

    public double moduloYPos(double d) {
        return this.el.moduloYPos(d);
    }

    public void setProgressBar(double d) {
        this.canvas.setProgressBar(d);
    }

    public void setProgressMessage(String string) {
        this.canvas.setProgressMessage(string);
    }

    public void setAuthorMessage(String string) {
        this.canvas.setAuthorMessage(string);
    }

    private void refreshDbgFrameLogs() {
        this.dbgframelogs_new = new Hashtable();
        Enumeration enumeration = this.dbgnewframelogs.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = this.dbgnewframelogs.get(string);
            this.dbgframelogs.put(string, v);
            this.dbgframelogs_new.put(string, "yes");
        }
        this.dbgnewframelogs = new Hashtable();
    }

    void paintDbgFrameLogs(Graphics graphics) {
        Font font = new Font(this.debugmessage_font.name, this.debugmessage_font.style, (int)this.debugmessage_font.size);
        graphics.setFont(font);
        Enumeration enumeration = this.dbgframelogs.keys();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2;
            int n;
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)this.dbgframelogs.get(string);
            if (this.dbgframelogs_new.containsKey(string)) {
                this.setColor(graphics, this.el.fg_color);
            } else {
                this.setColor(graphics, this.debug_auxcolor1);
            }
            JGObject jGObject = this.el.getObject(string);
            if (jGObject == null) {
                jGObject = (JGObject)this.dbgframelogs_obj.get(string);
                this.setColor(graphics, this.debug_auxcolor2);
                if (jGObject != null) {
                    n = 0;
                    if (this.dbgframelogs_dead.containsKey(string)) {
                        n = (Integer)this.dbgframelogs_dead.get(string);
                    }
                    if (n < dbgframelog_expiry) {
                        this.dbgframelogs_dead.put(string, new Integer(n + 1));
                    } else {
                        this.dbgframelogs_obj.remove(string);
                        this.dbgframelogs_dead.remove(string);
                    }
                }
            }
            n = this.debugmessage_font.getSize() + 1;
            if (jGObject != null) {
                JGPoint jGPoint = this.el.scalePos(jGObject.x - (double)this.el.xofs, jGObject.y - (double)this.el.yofs + (double)(n / 3), false);
                jGPoint.y -= n * vector.size();
                enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    graphics.drawString((String)enumeration2.nextElement(), jGPoint.x, jGPoint.y);
                    jGPoint.y += n;
                }
                continue;
            }
            if (!string.equals("MAIN")) {
                this.dbgframelogs.remove(string);
                continue;
            }
            if (this.dbgframelogs_new.containsKey(string)) {
                this.setColor(graphics, this.el.fg_color);
            } else {
                this.setColor(this.debug_auxcolor1);
            }
            int n2 = this.el.scaleYPos(this.el.viewHeight(), false);
            n2 -= n * vector.size();
            enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                graphics.drawString((String)enumeration2.nextElement(), 0, n2);
                n2 += n;
            }
        }
    }

    public void dbgShowBoundingBox(boolean bl) {
        this.debugflags = bl ? (this.debugflags |= 1) : (this.debugflags &= 0xFFFFFFFE);
    }

    public void dbgShowGameState(boolean bl) {
        this.debugflags = bl ? (this.debugflags |= 2) : (this.debugflags &= 0xFFFFFFFD);
    }

    public void dbgShowFullStackTrace(boolean bl) {
        this.debugflags = bl ? (this.debugflags |= 4) : (this.debugflags &= 0xFFFFFFFB);
    }

    public void dbgShowMessagesInPf(boolean bl) {
        this.debugflags = bl ? (this.debugflags |= 8) : (this.debugflags &= 0xFFFFFFF7);
    }

    public void dbgSetMessageExpiry(int n) {
        dbgframelog_expiry = n;
    }

    public void dbgSetMessageFont(JGFont jGFont) {
        this.debugmessage_font = jGFont;
    }

    public void dbgSetDebugColor1(JGColor jGColor) {
        this.debug_auxcolor1 = jGColor;
    }

    public void dbgSetDebugColor2(JGColor jGColor) {
        this.debug_auxcolor2 = jGColor;
    }

    public void dbgPrint(String string) {
        this.dbgPrint("MAIN", string);
    }

    public void dbgPrint(String string, String string2) {
        if ((this.debugflags & 8) != 0) {
            Vector<String> vector = (Vector<String>)this.dbgnewframelogs.get(string);
            if (vector == null) {
                vector = new Vector<String>(5, 15);
            }
            if (vector.size() < 19) {
                vector.add(string2);
            } else if (vector.size() == 19) {
                vector.add("<messages truncated>");
            }
            this.dbgnewframelogs.put(string, vector);
            JGObject jGObject = this.el.getObject(string);
            if (jGObject != null) {
                this.dbgframelogs_obj.put(string, jGObject);
                this.dbgframelogs_dead.remove(string);
            }
        } else {
            System.out.println(string + ": " + string2);
        }
    }

    public void dbgShowException(String string, Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
        if ((this.debugflags & 4) != 0) {
            this.dbgPrint(string, byteArrayOutputStream.toString());
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(byteArrayOutputStream.toString(), "\n");
            this.dbgPrint(string, stringTokenizer.nextToken());
            this.dbgPrint(string, stringTokenizer.nextToken());
            if (stringTokenizer.hasMoreTokens()) {
                this.dbgPrint(string, stringTokenizer.nextToken());
            }
        }
    }

    public String dbgExceptionToString(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
        if ((this.debugflags & 4) != 0) {
            return byteArrayOutputStream.toString();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(byteArrayOutputStream.toString(), "\n");
        String string = stringTokenizer.nextToken() + "\n";
        string = string + stringTokenizer.nextToken() + "\n";
        if (stringTokenizer.hasMoreTokens()) {
            string = string + stringTokenizer.nextToken();
        }
        return string;
    }

    public void exitEngine(String string) {
        if (string != null) {
            System.err.println(string);
            this.el.exit_message = string;
        }
        System.err.println("Exiting JGEngine.");
        if (!this.i_am_applet) {
            System.exit(0);
        }
        this.destroy();
        this.canvas.repaint();
    }

    public JGEngine() {
        this.imageutil.setComponent(this);
    }

    public void initEngineComponent(int n, int n2) {
        this.i_am_applet = false;
        this.jre.create_frame = false;
        this.el.winwidth = n;
        this.el.winheight = n2;
        this.init();
    }

    public void initEngineApplet() {
        this.i_am_applet = true;
    }

    public void initEngine(int n, int n2) {
        this.i_am_applet = false;
        if (n == 0) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.el.winwidth = dimension.width;
            this.el.winheight = dimension.height;
            this.jre.win_decoration = false;
        } else {
            this.el.winwidth = n;
            this.el.winheight = n2;
            this.jre.win_decoration = true;
        }
        this.init();
    }

    public void setCanvasSettings(int n, int n2, int n3, int n4, JGColor jGColor, JGColor jGColor2, JGFont jGFont) {
        this.el.nrtilesx = n;
        this.el.nrtilesy = n2;
        this.el.viewnrtilesx = n;
        this.el.viewnrtilesy = n2;
        this.el.tilex = n3;
        this.el.tiley = n4;
        this.setColorsFont(jGColor, jGColor2, jGFont);
        this.el.view_initialised = true;
    }

    public void setScalingPreferences(double d, double d2, int n, int n2, int n3, int n4) {
        this.el.min_aspect = d;
        this.el.max_aspect = d2;
        this.el.crop_top = n;
        this.el.crop_left = n2;
        this.el.crop_bottom = n3;
        this.el.crop_right = n4;
    }

    public void setSmoothing(boolean bl) {
        this.el.smooth_magnify = bl;
    }

    public void requestGameFocus() {
        this.canvas.requestFocus();
    }

    public boolean isApplet() {
        return this.i_am_applet;
    }

    public boolean isMidlet() {
        return false;
    }

    public boolean isOpenGL() {
        return false;
    }

    public int viewWidth() {
        return this.el.viewnrtilesx * this.el.tilex;
    }

    public int viewHeight() {
        return this.el.viewnrtilesy * this.el.tiley;
    }

    public int viewTilesX() {
        return this.el.viewnrtilesx;
    }

    public int viewTilesY() {
        return this.el.viewnrtilesy;
    }

    public int viewXOfs() {
        return this.el.pendingxofs;
    }

    public int viewYOfs() {
        return this.el.pendingyofs;
    }

    public int pfWidth() {
        return this.el.nrtilesx * this.el.tilex;
    }

    public int pfHeight() {
        return this.el.nrtilesy * this.el.tiley;
    }

    public int pfTilesX() {
        return this.el.nrtilesx;
    }

    public int pfTilesY() {
        return this.el.nrtilesy;
    }

    public boolean pfWrapX() {
        return this.el.pf_wrapx;
    }

    public boolean pfWrapY() {
        return this.el.pf_wrapy;
    }

    public int tileWidth() {
        return this.el.tilex;
    }

    public int tileHeight() {
        return this.el.tiley;
    }

    public int displayWidth() {
        return this.el.winwidth;
    }

    public int displayHeight() {
        return this.el.winheight;
    }

    public double getFrameRate() {
        return this.el.fps;
    }

    public double getGameSpeed() {
        return this.el.gamespeed;
    }

    public double getFrameSkip() {
        return this.el.maxframeskip;
    }

    public boolean getVideoSyncedUpdate() {
        return false;
    }

    public int getOffscreenMarginX() {
        return this.el.offscreen_margin_x;
    }

    public int getOffscreenMarginY() {
        return this.el.offscreen_margin_y;
    }

    public double getXScaleFactor() {
        return this.el.x_scale_fac;
    }

    public double getYScaleFactor() {
        return this.el.y_scale_fac;
    }

    public double getMinScaleFactor() {
        return this.el.min_scale_fac;
    }

    public void init() {
        this.jre.storeInit();
        if (this.el.winwidth == 0) {
            this.el.winwidth = this.getWidth();
            this.el.winheight = this.getHeight();
        }
        this.initCanvas();
        if (!this.el.view_initialised) {
            this.exitEngine("Canvas settings not initialised, use setCanvasSettings().");
        }
        if (!this.i_am_applet && this.jre.create_frame) {
            this.jre.createWindow(this, this.jre.win_decoration);
        }
        this.canvas = new JGCanvas(this.el.winwidth, this.el.winheight);
        this.jre.canvas = this.canvas;
        this.el.initPF();
        this.jre.clearKeymap();
        this.canvas.addMouseListener(this.jre);
        this.canvas.addMouseMotionListener(this.jre);
        this.canvas.addFocusListener(this.jre);
        this.canvas.setBackground(this.getAWTColor(this.el.bg_color));
        if (this.jre.my_win != null) {
            this.jre.my_win.setBackground(this.getAWTColor(this.el.bg_color));
        }
        this.el.msg_font = new JGFont("Helvetica", 0, (int)(16.0 / (640.0 / (double)(this.el.tilex * this.el.nrtilesx))));
        this.setLayout(new FlowLayout(3, 0, 0));
        this.add(this.canvas);
        if (!JGObject.setEngine(this)) {
            this.canvas.setInitPainter(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    Graphics graphics = (Graphics)object;
                    JGEngine.this.setFont(graphics, JGEngine.this.el.msg_font);
                    JGEngine.this.setColor(graphics, JGEngine.this.el.fg_color);
                    JGEngine.this.drawString(graphics, "JGame is already running in this VM", (double)(JGEngine.this.el.viewWidth() / 2), (double)(JGEngine.this.el.viewHeight() / 3), 0, false);
                    return null;
                }
            });
            return;
        }
        this.el.is_inited = true;
        this.canvas.setInitPainter(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JGImage jGImage;
                Graphics graphics = (Graphics)object;
                JGEngine.this.setFont(graphics, JGEngine.this.el.msg_font);
                JGEngine.this.setColor(graphics, JGEngine.this.el.fg_color);
                JGImage jGImage2 = jGImage = JGEngine.this.el.existsImage("splash_image") ? JGEngine.this.el.getImage("splash_image") : null;
                if (jGImage != null) {
                    JGPoint jGPoint = JGEngine.this.getImageSize("splash_image");
                    JGEngine.this.drawImage(graphics, JGEngine.this.viewWidth() / 2 - jGPoint.x / 2, Math.max(0, JGEngine.this.viewHeight() / 4 - jGPoint.y / 2), "splash_image", false);
                }
                JGEngine.this.drawString(graphics, JGEngine.this.canvas.progress_message, (double)(JGEngine.this.viewWidth() / 2), (double)(JGEngine.this.viewHeight() / 2), 0, false);
                JGEngine.this.setColor(graphics, JGEngine.this.el.bg_color);
                JGEngine.this.drawRect(graphics, (double)((int)((double)JGEngine.this.viewWidth() * (0.1 + 0.8 * JGEngine.this.canvas.progress_bar))), (double)((int)((double)JGEngine.this.viewHeight() * 0.6)), (double)((int)((double)JGEngine.this.viewWidth() * 0.8 * (1.0 - JGEngine.this.canvas.progress_bar))), (int)((double)JGEngine.this.viewHeight() * 0.05), true, false, false);
                JGEngine.this.setColor(graphics, JGEngine.this.el.fg_color);
                JGEngine.this.drawRect(graphics, (double)((int)((double)JGEngine.this.viewWidth() * 0.1)), (double)((int)((double)JGEngine.this.viewHeight() * 0.6)), (double)((int)((double)JGEngine.this.viewWidth() * 0.8 * JGEngine.this.canvas.progress_bar)), (int)((double)JGEngine.this.viewHeight() * 0.05), true, false, false);
                JGEngine.this.drawRect(graphics, (double)((int)((double)JGEngine.this.viewWidth() * 0.1)), (double)((int)((double)JGEngine.this.viewHeight() * 0.6)), (double)((int)((double)JGEngine.this.viewWidth() * 0.8)), (int)((double)JGEngine.this.viewHeight() * 0.008), true, false, false);
                JGEngine.this.drawRect(graphics, (double)((int)((double)JGEngine.this.viewWidth() * 0.1)), (double)((int)((double)JGEngine.this.viewHeight() * 0.646)), (double)((int)((double)JGEngine.this.viewWidth() * 0.8)), (int)((double)JGEngine.this.viewHeight() * 0.008), true, false, false);
                JGEngine.this.drawString(graphics, JGEngine.this.canvas.author_message, (double)(JGEngine.this.viewWidth() - 16), (double)JGEngine.this.viewHeight() - JGEngine.this.getFontHeight(graphics, JGEngine.this.el.msg_font) - 10.0, 1, false);
                return null;
            }
        });
        if (this.jre.my_win != null) {
            this.jre.my_win.setVisible(true);
            this.jre.my_win.validate();
            this.jre.setWindowSize(this.jre.win_decoration);
        }
        this.canvas.addKeyListener(this.jre);
        this.canvas.requestFocus();
        this.thread = new Thread(new JGEngineThread());
        this.thread.start();
    }

    public abstract void initCanvas();

    public abstract void initGame();

    public void start() {
        this.running = true;
    }

    public void stop() {
        this.running = false;
    }

    public void startApp() {
        if (!this.el.is_inited) {
            this.init();
        } else {
            this.start();
        }
    }

    public void pauseApp() {
        this.stop();
    }

    public void destroyApp(boolean bl) {
        this.destroy();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void wakeUpOnKey(int n) {
        this.jre.wakeUpOnKey(n);
    }

    public void destroy() {
        this.el.is_exited = true;
        if (this.thread != null) {
            if (!this.i_am_applet) {
                this.thread.interrupt();
            }
            try {
                this.thread.join(2000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (this.el.is_inited) {
            JGObject.setEngine(null);
        }
        this.disableAudio();
        System.out.println("JGame engine disposed.");
    }

    public void setViewOffset(int n, int n2, boolean bl) {
        this.el.setViewOffset(n, n2, bl);
    }

    public void setBGImgOffset(int n, double d, double d2, boolean bl) {
    }

    public void setViewZoomRotate(double d, double d2) {
    }

    public void setPFSize(int n, int n2) {
        this.el.setPFSize(n, n2);
    }

    public void setPFWrap(boolean bl, boolean bl2, int n, int n2) {
        this.el.setPFWrap(bl, bl2, n, n2);
    }

    public void setFrameRate(double d, double d2) {
        this.el.setFrameRate(d, d2);
    }

    public void setVideoSyncedUpdate(boolean bl) {
    }

    public void setGameSpeed(double d) {
        this.el.setGameSpeed(d);
    }

    public void setRenderSettings(int n, JGColor jGColor) {
        this.el.setRenderSettings(n, jGColor);
    }

    public void setOffscreenMargin(int n, int n2) {
        this.el.setOffscreenMargin(n, n2);
    }

    public void setBGColor(JGColor jGColor) {
        Color color = new Color(jGColor.r, jGColor.g, jGColor.b);
        if (this.canvas != null) {
            this.canvas.setBackground(color);
        }
        if (this.jre.my_win != null) {
            this.jre.my_win.setBackground(color);
        }
        this.el.bg_color = jGColor;
    }

    public void setFGColor(JGColor jGColor) {
        this.el.fg_color = jGColor;
    }

    public void setMsgFont(JGFont jGFont) {
        this.el.msg_font = jGFont;
    }

    public void setColorsFont(JGColor jGColor, JGColor jGColor2, JGFont jGFont) {
        if (jGFont != null) {
            this.el.msg_font = jGFont;
        }
        if (jGColor != null) {
            this.el.fg_color = jGColor;
        }
        if (jGColor2 != null) {
            this.setBGColor(jGColor2);
        }
    }

    public void setTextOutline(int n, JGColor jGColor) {
        this.el.outline_colour = jGColor;
        this.el.outline_thickness = n;
    }

    public void setMouseCursor(int n) {
        if (n == 0) {
            this.canvas.setCursor(new Cursor(0));
        } else if (n == 1) {
            this.canvas.setCursor(new Cursor(1));
        } else if (n == 2) {
            this.canvas.setCursor(new Cursor(12));
        } else if (n == 3) {
            this.canvas.setCursor(new Cursor(3));
        }
    }

    public void setMouseCursor(Object object) {
        if (object == null) {
            this.canvas.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(this.null_image, new Point(0, 0), "hidden"));
        } else {
            this.canvas.setCursor((Cursor)object);
        }
    }

    public void removeAllTimers() {
        this.el.removeAllTimers();
    }

    public void registerTimer(JGTimer jGTimer) {
        this.el.registerTimer(jGTimer);
    }

    public void setGameState(String string) {
        this.el.setGameState(string);
    }

    public void addGameState(String string) {
        this.el.addGameState(string);
    }

    public void removeGameState(String string) {
        this.el.removeGameState(string);
    }

    public void clearGameState() {
        this.el.clearGameState();
    }

    public boolean inGameState(String string) {
        return this.el.inGameState(string);
    }

    public boolean inGameStateNextFrame(String string) {
        return this.el.inGameStateNextFrame(string);
    }

    private void doFrameAll() {
        this.jre.audioNewFrame();
        this.el.flushRemoveList();
        this.el.flushAddList();
        this.el.tickTimers();
        this.el.flushRemoveList();
        this.el.flushAddList();
        this.el.gamestate = this.el.gamestate_nextframe;
        this.el.gamestate_nextframe = new Vector(10, 20);
        this.el.gamestate_nextframe.addAll(this.el.gamestate);
        this.invokeGameStateMethods("start", this.el.gamestate_new);
        this.el.gamestate_new.clear();
        this.el.flushRemoveList();
        this.el.flushAddList();
        try {
            this.doFrame();
        }
        catch (JGameError jGameError) {
            this.exitEngine(this.dbgExceptionToString(jGameError));
        }
        catch (Exception exception) {
            this.dbgShowException("MAIN", exception);
        }
        this.invokeGameStateMethods("doFrame", this.el.gamestate);
        this.el.frameFinished();
    }

    private void invokeGameStateMethods(String string, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            this.jre.tryMethod(this, string + string2, new Object[0]);
        }
    }

    public void doFrame() {
    }

    void paintFrame(Graphics graphics) {
        this.buf_gfx = graphics;
        this.setColor(graphics, this.el.fg_color);
        this.setFont(this.el.msg_font);
        try {
            this.paintFrame();
        }
        catch (JGameError jGameError) {
            this.exitEngine(this.dbgExceptionToString(jGameError));
        }
        catch (Exception exception) {
            this.dbgShowException("MAIN", exception);
        }
        this.invokeGameStateMethods("paintFrame", this.el.gamestate);
        if ((this.debugflags & 2) != 0) {
            String string = "{";
            Enumeration enumeration = this.el.gamestate.elements();
            while (enumeration.hasMoreElements()) {
                string = string + (String)enumeration.nextElement();
                if (!enumeration.hasMoreElements()) continue;
                string = string + ",";
            }
            string = string + "}";
            this.setFont(this.el.msg_font);
            this.setColor(graphics, this.el.fg_color);
            this.drawString(string, this.el.viewWidth(), this.el.viewHeight() - (int)this.getFontHeight(graphics, this.el.msg_font), 1);
        }
        if ((this.debugflags & 8) != 0) {
            this.paintDbgFrameLogs(this.buf_gfx);
        }
        this.buf_gfx = null;
    }

    public void paintFrame() {
    }

    public Graphics getBufferGraphics() {
        return this.buf_gfx;
    }

    public void setColor(JGColor jGColor) {
        if (this.buf_gfx != null) {
            this.setColor(this.buf_gfx, jGColor);
        }
    }

    public Color getAWTColor(JGColor jGColor) {
        return new Color(jGColor.r, jGColor.g, jGColor.b);
    }

    public void setFont(JGFont jGFont) {
        this.setFont(this.buf_gfx, jGFont);
    }

    public void setFont(Graphics graphics, JGFont jGFont) {
        if (this.canvas != null && graphics != null) {
            Font font = new Font(jGFont.name, jGFont.style, (int)jGFont.size);
            font = font.deriveFont((float)(jGFont.size * this.el.min_scale_fac));
            graphics.setFont(font);
        }
    }

    public void setStroke(double d) {
        Graphics2D graphics2D = (Graphics2D)this.buf_gfx;
        graphics2D.setStroke(new BasicStroke((float)(d * this.el.min_scale_fac)));
    }

    public void setBlendMode(int n, int n2) {
    }

    public double getFontHeight(JGFont jGFont) {
        if (this.buf_gfx != null) {
            return this.getFontHeight(this.buf_gfx, jGFont);
        }
        return 0.0;
    }

    double getFontHeight(Graphics graphics, JGFont jGFont) {
        Font font = jGFont == null ? graphics.getFont() : new Font(jGFont.name, jGFont.style, (int)jGFont.size);
        FontRenderContext fontRenderContext = ((Graphics2D)graphics).getFontRenderContext();
        Rectangle2D rectangle2D = font.getMaxCharBounds(fontRenderContext);
        return rectangle2D.getHeight();
    }

    void drawImage(Graphics graphics, double d, double d2, String string, boolean bl) {
        if (string == null) {
            return;
        }
        d = this.el.scaleXPos(d, bl);
        d2 = this.el.scaleYPos(d2, bl);
        JREImage jREImage = (JREImage)this.el.getImage(string);
        if (jREImage != null) {
            graphics.drawImage(jREImage.img, (int)d, (int)d2, this);
        }
    }

    public void drawLine(double d, double d2, double d3, double d4, double d5, JGColor jGColor) {
        if (jGColor != null) {
            this.setColor(jGColor);
        }
        this.setStroke(d5);
        this.drawLine(d, d2, d3, d4, true);
    }

    public void drawLine(double d, double d2, double d3, double d4) {
        this.drawLine(d, d2, d3, d4, true);
    }

    public void drawLine(double d, double d2, double d3, double d4, boolean bl) {
        if (this.buf_gfx == null) {
            return;
        }
        this.buf_gfx.drawLine(this.el.scaleXPos(d, bl), this.el.scaleYPos(d2, bl), this.el.scaleXPos(d3, bl), this.el.scaleYPos(d4, bl));
    }

    public void drawPolygon(double[] dArray, double[] dArray2, JGColor[] jGColorArray, int n, boolean bl, boolean bl2) {
        if (this.buf_gfx == null) {
            return;
        }
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        nArray[0] = this.el.scaleXPos(dArray[0], bl2);
        nArray2[0] = this.el.scaleYPos(dArray2[0], bl2);
        nArray[1] = this.el.scaleXPos(dArray[1], bl2);
        nArray2[1] = this.el.scaleYPos(dArray2[1], bl2);
        nArray[2] = this.el.scaleXPos(dArray[n - 1], bl2);
        nArray2[2] = this.el.scaleYPos(dArray2[n - 1], bl2);
        if (!bl) {
            if (jGColorArray != null) {
                this.setColor(this.buf_gfx, jGColorArray[1]);
            }
            this.buf_gfx.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
            if (jGColorArray != null) {
                this.setColor(this.buf_gfx, jGColorArray[0]);
            }
            this.buf_gfx.drawLine(nArray[2], nArray2[2], nArray[0], nArray2[0]);
        }
        for (int i = 2; i < n; ++i) {
            nArray[2] = this.el.scaleXPos(dArray[i], bl2);
            nArray2[2] = this.el.scaleYPos(dArray2[i], bl2);
            if (jGColorArray != null) {
                this.setColor(this.buf_gfx, jGColorArray[i]);
            }
            if (bl) {
                this.buf_gfx.fillPolygon(nArray, nArray2, 3);
            } else {
                this.buf_gfx.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
            }
            nArray[1] = nArray[2];
            nArray2[1] = nArray2[2];
        }
    }

    public void drawRect(double d, double d2, double d3, double d4, boolean bl, boolean bl2, double d5, JGColor jGColor) {
        if (jGColor != null) {
            this.setColor(jGColor);
        }
        this.setStroke(d5);
        this.drawRect(d, d2, d3, d4, bl, bl2, true);
    }

    public void drawRect(double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
        this.drawRect(d, d2, d3, d4, bl, bl2, true);
    }

    public void drawRect(double d, double d2, double d3, double d4, boolean bl, boolean bl2, boolean bl3) {
        if (this.buf_gfx == null) {
            return;
        }
        this.drawRect(this.buf_gfx, d, d2, d3, d4, bl, bl2, bl3);
    }

    public void drawRect(double d, double d2, double d3, double d4, boolean bl, boolean bl2, boolean bl3, JGColor[] jGColorArray) {
        this.drawRect(this.buf_gfx, d, d2, d3, d4, bl, bl2, bl3);
    }

    void drawRect(Graphics graphics, double d, double d2, double d3, double d4, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            d -= d3 / 2.0;
            d2 -= d4 / 2.0;
        }
        JGRectangle jGRectangle = this.el.scalePos(d, d2, d3, d4, bl3);
        if (bl) {
            graphics.fillRect(jGRectangle.x, jGRectangle.y, jGRectangle.width, jGRectangle.height);
        } else {
            graphics.drawRect(jGRectangle.x, jGRectangle.y, jGRectangle.width, jGRectangle.height);
        }
    }

    public void drawOval(double d, double d2, double d3, double d4, boolean bl, boolean bl2, double d5, JGColor jGColor) {
        if (jGColor != null) {
            this.setColor(jGColor);
        }
        this.setStroke(d5);
        this.drawOval(d, d2, d3, d4, bl, bl2, true);
    }

    public void drawOval(double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
        this.drawOval(d, d2, d3, d4, bl, bl2, true);
    }

    public void drawOval(double d, double d2, double d3, double d4, boolean bl, boolean bl2, boolean bl3) {
        if (this.buf_gfx == null) {
            return;
        }
        d = this.el.scaleXPos(d, bl3);
        d2 = this.el.scaleYPos(d2, bl3);
        d3 = this.el.scaleXPos(d3, false);
        d4 = this.el.scaleYPos(d4, false);
        if (bl2) {
            d -= d3 / 2.0;
            d2 -= d4 / 2.0;
        }
        if (bl) {
            this.buf_gfx.fillOval((int)d, (int)d2, (int)d3, (int)d4);
        } else {
            this.buf_gfx.drawOval((int)d, (int)d2, (int)d3, (int)d4);
        }
    }

    public void drawImage(double d, double d2, String string) {
        if (this.buf_gfx == null) {
            return;
        }
        this.drawImage(this.buf_gfx, d, d2, string, true);
    }

    public void drawImage(double d, double d2, String string, boolean bl) {
        if (this.buf_gfx == null) {
            return;
        }
        this.drawImage(this.buf_gfx, d, d2, string, bl);
    }

    public void drawImage(double d, double d2, String string, JGColor jGColor, double d3, double d4, double d5, boolean bl) {
        if (this.buf_gfx == null) {
            return;
        }
        this.drawImage(this.buf_gfx, d, d2, string, bl);
    }

    public void drawString(String string, double d, double d2, int n, JGFont jGFont, JGColor jGColor) {
        if (jGFont != null) {
            this.setFont(jGFont);
        }
        if (jGColor != null) {
            this.setColor(jGColor);
        }
        this.drawString(this.buf_gfx, string, d, d2, n, false);
    }

    public void drawString(String string, double d, double d2, int n) {
        this.drawString(this.buf_gfx, string, d, d2, n, false);
    }

    public void drawString(String string, double d, double d2, int n, boolean bl) {
        this.drawString(this.buf_gfx, string, d, d2, n, bl);
    }

    void drawString(Graphics graphics, String string, double d, double d2, int n, boolean bl) {
        int n2;
        int n3;
        if (graphics == null) {
            return;
        }
        if (string.equals("")) {
            return;
        }
        d = this.el.scaleXPos(d, bl);
        d2 = this.el.scaleYPos(d2, bl);
        Font font = graphics.getFont();
        FontRenderContext fontRenderContext = ((Graphics2D)graphics).getFontRenderContext();
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        if (n == -1) {
            n3 = (int)(d - rectangle2D.getMinX());
            n2 = (int)(d2 - rectangle2D.getMinY());
        } else if (n == 0) {
            n3 = (int)(d - rectangle2D.getCenterX());
            n2 = (int)(d2 - rectangle2D.getMinY());
        } else {
            n3 = (int)(d - rectangle2D.getMaxX());
            n2 = (int)(d2 - rectangle2D.getMinY());
        }
        if (this.el.outline_thickness > 0) {
            int n4;
            Color color = graphics.getColor();
            this.setColor(this.el.outline_colour);
            int n5 = Math.max(this.el.scaleXPos(this.el.outline_thickness, false), 1);
            for (n4 = -n5; n4 <= n5; ++n4) {
                if (n4 == 0) continue;
                graphics.drawString(string, n3 + n4, n2);
            }
            for (n4 = -n5; n4 <= n5; ++n4) {
                if (n4 == 0) continue;
                graphics.drawString(string, n3, n2 + n4);
            }
            graphics.setColor(color);
        }
        graphics.drawString(string, n3, n2);
    }

    public void drawImageString(String string, double d, double d2, int n, String string2, int n2, int n3) {
        this.el.drawImageString(this, string, d, d2, n, string2, n2, n3, false);
    }

    public void drawImageString(String string, double d, double d2, int n, String string2, int n2, int n3, boolean bl) {
        this.el.drawImageString(this, string, d, d2, n, string2, n2, n3, bl);
    }

    public JGPoint getMousePos() {
        return new JGPoint(this.jre.mousepos.x, this.jre.mousepos.y);
    }

    public int getMouseX() {
        return this.jre.mousepos.x;
    }

    public int getMouseY() {
        return this.jre.mousepos.y;
    }

    public boolean getMouseButton(int n) {
        return this.jre.mousebutton[n];
    }

    public void clearMouseButton(int n) {
        this.jre.mousebutton[n] = false;
    }

    public void setMouseButton(int n) {
        this.jre.mousebutton[n] = true;
    }

    public boolean getMouseInside() {
        return this.jre.mouseinside;
    }

    public boolean getKey(int n) {
        return this.jre.keymap[n];
    }

    public void clearKey(int n) {
        this.jre.keymap[n] = false;
    }

    public void setKey(int n) {
        this.jre.keymap[n] = true;
    }

    public int getLastKey() {
        return this.jre.lastkey;
    }

    public char getLastKeyChar() {
        return this.jre.lastkeychar;
    }

    public void clearLastKey() {
        this.jre.clearLastKey();
    }

    public String getKeyDesc(int n) {
        return JREEngine.getKeyDescStatic(n);
    }

    public static String getKeyDescStatic(int n) {
        return JREEngine.getKeyDescStatic(n);
    }

    public int getKeyCode(String string) {
        return JREEngine.getKeyCodeStatic(string);
    }

    public static int getKeyCodeStatic(String string) {
        return JREEngine.getKeyCodeStatic(string);
    }

    public void defineAnimation(String string, String[] stringArray, double d) {
        this.el.defineAnimation(string, stringArray, d);
    }

    public void defineAnimation(String string, String[] stringArray, double d, boolean bl) {
        this.el.defineAnimation(string, stringArray, d, bl);
    }

    public Animation getAnimation(String string) {
        return this.el.getAnimation(string);
    }

    public String getConfigPath(String string) {
        File file;
        if (this.isApplet()) {
            return null;
        }
        try {
            file = new File(System.getProperty("user.home"), ".jgame");
        }
        catch (Exception exception) {
            return null;
        }
        if (!file.exists() && !file.mkdir()) {
            return null;
        }
        if (!file.isDirectory()) {
            return null;
        }
        File file2 = new File(file, string);
        try {
            file2.createNewFile();
        }
        catch (IOException iOException) {
            return null;
        }
        if (!file2.canRead()) {
            return null;
        }
        if (!file2.canWrite()) {
            return null;
        }
        try {
            return file2.getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    void paintExitMessage(Graphics graphics) {
        try {
            this.setFont(graphics, this.debugmessage_font);
            int n = (int)(this.getFontHeight(graphics, null) / this.el.y_scale_fac);
            this.setColor(graphics, this.el.bg_color);
            this.drawRect(graphics, (double)(this.el.viewWidth() / 2), (double)(this.el.viewHeight() / 2), (double)(9 * this.el.viewWidth() / 10), n * 5, true, true, false);
            this.setColor(graphics, this.debug_auxcolor2);
            this.drawRect(graphics, (double)(this.el.viewWidth() / 2), (double)(this.el.viewHeight() / 2 - 5 * n / 2), (double)(9 * this.viewWidth() / 10), 5.0, true, true, false);
            this.drawRect(graphics, (double)(this.el.viewWidth() / 2), (double)(this.el.viewHeight() / 2 + 5 * n / 2), (double)(9 * this.viewWidth() / 10), 5.0, true, true, false);
            this.setColor(graphics, this.el.fg_color);
            int n2 = this.el.viewHeight() / 2 - 3 * n / 2;
            StringTokenizer stringTokenizer = new StringTokenizer(this.el.exit_message, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                this.drawString(graphics, stringTokenizer.nextToken(), (double)(this.el.viewWidth() / 2), (double)n2, 0, false);
                n2 += n + 1;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean and(int n, int n2) {
        return this.el.and(n, n2);
    }

    public double random(double d, double d2) {
        return this.el.random(d, d2);
    }

    public double random(double d, double d2, double d3) {
        return this.el.random(d, d2, d3);
    }

    public int random(int n, int n2, int n3) {
        return this.el.random(n, n2, n3);
    }

    public double atan2(double d, double d2) {
        return Math.atan2(d, d2);
    }

    public JGPoint getTileIndex(double d, double d2) {
        return this.el.getTileIndex(d, d2);
    }

    public JGPoint getTileCoord(int n, int n2) {
        return this.el.getTileCoord(n, n2);
    }

    public JGPoint getTileCoord(JGPoint jGPoint) {
        return this.el.getTileCoord(jGPoint);
    }

    public double snapToGridX(double d, double d2) {
        return this.el.snapToGridX(d, d2);
    }

    public double snapToGridY(double d, double d2) {
        return this.el.snapToGridY(d, d2);
    }

    public void snapToGrid(JGPoint jGPoint, int n, int n2) {
        this.el.snapToGrid(jGPoint, n, n2);
    }

    public boolean isXAligned(double d, double d2) {
        return this.el.isXAligned(d, d2);
    }

    public boolean isYAligned(double d, double d2) {
        return this.el.isYAligned(d, d2);
    }

    public double getXAlignOfs(double d) {
        return this.el.getXAlignOfs(d);
    }

    public double getYAlignOfs(double d) {
        return this.el.getYAlignOfs(d);
    }

    public double getXDist(double d, double d2) {
        return this.el.getXDist(d, d2);
    }

    public double getYDist(double d, double d2) {
        return this.el.getYDist(d, d2);
    }

    public void enableAudio() {
        this.jre.enableAudio();
    }

    public void disableAudio() {
        this.jre.disableAudio();
    }

    public void defineAudioClip(String string, String string2) {
        this.el.defineAudioClip(this, string, string2);
    }

    public String lastPlayedAudio(String string) {
        return this.jre.lastPlayedAudio(string);
    }

    public void playAudio(String string) {
        this.jre.playAudio(this, string);
    }

    public void playAudio(String string, String string2, boolean bl) {
        this.jre.playAudio(this, string, string2, bl);
    }

    public void stopAudio(String string) {
        this.jre.stopAudio(string);
    }

    public void stopAudio() {
        this.jre.stopAudio();
    }

    public void storeWriteInt(String string, int n) {
        this.jre.storeWriteInt(string, n);
    }

    public void storeWriteDouble(String string, double d) {
        this.jre.storeWriteDouble(string, d);
    }

    public void storeWriteString(String string, String string2) {
        this.jre.storeWriteString(string, string2);
    }

    public void storeRemove(String string) {
        this.jre.storeRemove(string);
    }

    public boolean storeExists(String string) {
        return this.jre.storeExists(string);
    }

    public int storeReadInt(String string, int n) {
        return this.jre.storeReadInt(string, n);
    }

    public double storeReadDouble(String string, double d) {
        return this.jre.storeReadDouble(string, d);
    }

    public String storeReadString(String string, String string2) {
        return this.jre.storeReadString(string, string2);
    }

    class JGEngineThread
    implements Runnable {
        private long target_time = 0L;
        private int frames_skipped = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    JGEngine.this.initGame();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new JGameError("Exception during initGame(): " + exception);
                }
                JGEngine.this.canvas.setInitialised();
                this.target_time = System.currentTimeMillis() + (long)(1000.0 / JGEngine.this.el.fps);
                while (!JGEngine.this.el.is_exited) {
                    int n;
                    SortedArray sortedArray;
                    if ((JGEngine.this.debugflags & 8) != 0) {
                        JGEngine.this.refreshDbgFrameLogs();
                    }
                    long l = System.currentTimeMillis();
                    if (!JGEngine.this.running) {
                        Thread.sleep(500L);
                        this.target_time = l + (long)(1000.0 / JGEngine.this.el.fps);
                        continue;
                    }
                    if (l < this.target_time + (long)(500.0 / JGEngine.this.el.fps)) {
                        sortedArray = JGEngine.this.el.objects;
                        synchronized (sortedArray) {
                            JGEngine.this.doFrameAll();
                            JGEngine.this.el.updateViewOffset();
                        }
                        JGEngine.this.canvas.repaint();
                        this.frames_skipped = 0;
                        if (l + 3L < this.target_time) {
                            Thread.sleep(this.target_time - l);
                        } else {
                            Thread.yield();
                        }
                        this.target_time = (long)((double)this.target_time + 1000.0 / JGEngine.this.el.fps);
                        continue;
                    }
                    sortedArray = JGEngine.this.el.objects;
                    synchronized (sortedArray) {
                        JGEngine.this.doFrameAll();
                        JGEngine.this.el.updateViewOffset();
                    }
                    ++this.frames_skipped;
                    if ((double)n > JGEngine.this.el.maxframeskip) {
                        JGEngine.this.canvas.repaint();
                        this.frames_skipped = 0;
                        this.target_time = l + (long)(1000.0 / JGEngine.this.el.fps);
                    } else {
                        this.target_time += (long)(1000.0 / JGEngine.this.el.fps);
                    }
                    Thread.yield();
                }
            }
            catch (InterruptedException interruptedException) {
                System.out.println("JGame thread exited.");
            }
            catch (Exception exception) {
                JGEngine.this.dbgShowException("MAIN", exception);
            }
            catch (JGameError jGameError) {
                JGEngine.this.exitEngine("Error in main:\n" + JGEngine.this.dbgExceptionToString(jGameError));
            }
        }
    }

    class JGCanvas
    extends Canvas {
        boolean is_initialised = false;
        private ListCellRenderer initpainter = null;
        String progress_message = "Please wait, loading files .....";
        String author_message = "JGame 3.4";
        double progress_bar = 0.0;

        public boolean isFocusTraversable() {
            return true;
        }

        public JGCanvas(int n, int n2) {
            this.setSize(n, n2);
        }

        void setInitialised() {
            this.is_initialised = true;
            this.initpainter = null;
        }

        void setInitPainter(ListCellRenderer listCellRenderer) {
            this.initpainter = listCellRenderer;
        }

        void setProgressBar(double d) {
            this.progress_bar = d;
            if (!this.is_initialised && this.initpainter != null) {
                this.repaint(100L);
            }
        }

        void setProgressMessage(String string) {
            this.progress_message = string;
            if (!this.is_initialised && this.initpainter != null) {
                this.repaint(100L);
            }
        }

        void setAuthorMessage(String string) {
            this.author_message = string;
            if (!this.is_initialised && this.initpainter != null) {
                this.repaint(100L);
            }
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics graphics) {
            block16: {
                try {
                    if (JGEngine.this.el.is_exited) {
                        JGEngine.this.paintExitMessage(graphics);
                        return;
                    }
                    if (!this.is_initialised) {
                        if (this.initpainter != null) {
                            this.initpainter.getListCellRendererComponent(null, this.getGraphics(), 0, false, false);
                        }
                        return;
                    }
                    if (JGEngine.this.background == null || !JREImage.isScratchImageValid(JGEngine.this.background)) {
                        JGEngine.this.background = JREImage.createScratchImage(JGEngine.this.el.width + 3 * JGEngine.this.el.scaledtilex, JGEngine.this.el.height + 3 * JGEngine.this.el.scaledtiley);
                        JGEngine.this.el.invalidateBGTiles();
                    }
                    if (JGEngine.this.buffer == null || !JREImage.isScratchImageValid(JGEngine.this.buffer)) {
                        JGEngine.this.buffer = JREImage.createScratchImage(JGEngine.this.el.width, JGEngine.this.el.height);
                    }
                    if (JGEngine.this.buffer == null || JGEngine.this.background == null) break block16;
                    SortedArray sortedArray = JGEngine.this.el.objects;
                    synchronized (sortedArray) {
                        Graphics graphics2;
                        JGEngine.this.el.repaintBG(JGEngine.this);
                        JGEngine.this.buf_gfx = graphics2 = JGEngine.this.buffer.getGraphics();
                        int n = JGEngine.this.el.moduloFloor(JGEngine.this.el.tilexofs + 1, JGEngine.this.el.viewnrtilesx + 3);
                        int n2 = JGEngine.this.el.moduloFloor(JGEngine.this.el.tileyofs + 1, JGEngine.this.el.viewnrtilesy + 3);
                        int n3 = n + 1;
                        int n4 = n2 + 1;
                        int n5 = JGEngine.this.el.viewnrtilesx + 3;
                        int n6 = JGEngine.this.el.viewnrtilesy + 3;
                        if (n5 - n3 > JGEngine.this.el.viewnrtilesx) {
                            n5 = n3 + JGEngine.this.el.viewnrtilesx;
                        }
                        if (n6 - n4 > JGEngine.this.el.viewnrtilesy) {
                            n6 = n4 + JGEngine.this.el.viewnrtilesy;
                        }
                        int n7 = n5 - n3;
                        int n8 = n6 - n4;
                        JGEngine.this.copyBGToBuf(graphics2, n3, n4, n5, n6, 0, 0);
                        n3 = 0;
                        n4 = 0;
                        n5 = n - 1;
                        n6 = n2 - 1;
                        JGEngine.this.copyBGToBuf(graphics2, n3, n4, n5, n6, n7, n8);
                        n3 = 0;
                        n4 = n2 + 1;
                        n5 = n - 1;
                        n6 = JGEngine.this.el.viewnrtilesy + 3;
                        if (n6 - n4 > JGEngine.this.el.viewnrtilesy) {
                            n6 = n4 + JGEngine.this.el.viewnrtilesy;
                        }
                        JGEngine.this.copyBGToBuf(graphics2, n3, n4, n5, n6, n7, 0);
                        n3 = n + 1;
                        n4 = 0;
                        n5 = JGEngine.this.el.viewnrtilesx + 3;
                        n6 = n2 - 1;
                        if (n5 - n3 > JGEngine.this.el.viewnrtilesx) {
                            n5 = n3 + JGEngine.this.el.viewnrtilesx;
                        }
                        JGEngine.this.copyBGToBuf(graphics2, n3, n4, n5, n6, 0, n8);
                        for (int i = 0; i < JGEngine.this.el.objects.size; ++i) {
                            JGEngine.this.drawObject(graphics2, (JGObject)JGEngine.this.el.objects.values[i]);
                        }
                        JGEngine.this.buf_gfx = null;
                        if (graphics2 != null) {
                            JGEngine.this.paintFrame(graphics2);
                        }
                        graphics.drawImage(JGEngine.this.buffer, 0, 0, this);
                    }
                    Toolkit.getDefaultToolkit().sync();
                }
                catch (JGameError jGameError) {
                    JGEngine.this.exitEngine("Error during paint:\n" + JGEngine.this.dbgExceptionToString(jGameError));
                }
            }
        }
    }
}

