/*
 * Decompiled with CFR 0.152.
 */
package jgame.platform;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.JOptionPane;
import jgame.Highscore;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGPoint;
import jgame.JGTimer;
import jgame.platform.AppConfig;
import jgame.platform.JGEngine;

public abstract class StdGame
extends JGEngine {
    public boolean audioenabled = true;
    public int key_startgame = 32;
    public int key_gamesettings = 10;
    public int key_continuegame = 32;
    public int key_quitgame = 27;
    public int key_quitprogram = 27;
    public int key_pausegame = 80;
    public int key_left = 37;
    public int key_right = 39;
    public int key_up = 38;
    public int key_down = 40;
    public int key_fire = 90;
    public int key_fireleft = 65;
    public int key_fireright = 68;
    public int key_fireup = 87;
    public int key_firedown = 83;
    public int key_action = 88;
    public double gametime = 0.0;
    public double seqtimer = 0.0;
    public double timer = 0.0;
    public int score = 0;
    public int level = 0;
    public int stage = 0;
    public int lives = 0;
    public int initial_lives = 4;
    public int startgame_ticks = 80;
    public int leveldone_ticks = 80;
    public int lifelost_ticks = 80;
    public int gameover_ticks = 120;
    public boolean startgame_ingame = false;
    public boolean leveldone_ingame = false;
    public boolean lifelost_ingame = false;
    public boolean gameover_ingame = false;
    public int status_l_margin = 12;
    public int status_r_margin = 12;
    public JGFont status_font = new JGFont("Courier", 1, 12.0);
    public JGColor status_color = JGColor.white;
    public String lives_img = null;
    public JGFont title_font = new JGFont("Courier", 0, 18.0);
    public JGColor title_color = JGColor.white;
    public JGColor title_bg_color = JGColor.blue;
    boolean just_inited = true;
    public AppConfig appconfig = null;
    public Highscore[] highscores = null;
    public int highscore_maxnamelen = 15;
    public String playername = "";
    public int highscore_waittime = 500;
    public int highscore_showtime = 600;
    public JGFont highscore_font = new JGFont("Courier", 1, 16.0);
    public JGColor highscore_color = JGColor.white;
    public JGFont highscore_title_font = new JGFont("Courier", 1, 16.0);
    public JGColor highscore_title_color = JGColor.white;
    public String highscore_title = "Highest Scores";
    public String highscore_entry = "You have a high score!";

    public void setStatusDisplay(JGFont jGFont, JGColor jGColor, String string) {
        this.status_font = jGFont;
        this.status_color = jGColor;
        this.lives_img = string;
    }

    public void setSequences(boolean bl, int n, boolean bl2, int n2, boolean bl3, int n3, boolean bl4, int n4) {
        this.startgame_ingame = bl;
        this.leveldone_ingame = bl2;
        this.lifelost_ingame = bl3;
        this.gameover_ingame = bl4;
        this.startgame_ticks = n;
        this.leveldone_ticks = n2;
        this.lifelost_ticks = n3;
        this.gameover_ticks = n4;
    }

    public void setHighscores(int n, Highscore highscore, int n2) {
        this.highscores = new Highscore[n];
        for (int i = 0; i < n; ++i) {
            this.highscores[i] = highscore;
        }
        this.highscore_maxnamelen = n2;
    }

    public void setHighscoreDisplay(int n, int n2, JGFont jGFont, JGColor jGColor, String string, String string2, JGFont jGFont2, JGColor jGColor2) {
        this.highscore_waittime = n;
        this.highscore_showtime = n2;
        this.highscore_font = jGFont;
        this.highscore_color = jGColor;
        this.highscore_title = string;
        this.highscore_entry = string2;
        this.highscore_title_font = jGFont2;
        this.highscore_title_color = jGColor2;
    }

    public static JGPoint parseSizeArgs(String[] stringArray, int n) {
        JGPoint jGPoint = new JGPoint(0, 0);
        if (stringArray.length == n + 2) {
            try {
                jGPoint.x = Integer.parseInt(stringArray[n]);
                jGPoint.y = Integer.parseInt(stringArray[n + 1]);
            }
            catch (Exception exception) {
                System.out.println("\nError parsing width/height arguments.They should be integers.\n");
                System.exit(0);
            }
        } else if (stringArray.length != n) {
            System.out.println("\nYou can supply either no arguments, or [width] [height].\n");
            System.exit(0);
        }
        return jGPoint;
    }

    public void initNewGame(int n) {
        this.stage = this.level = n;
        this.score = 0;
        this.lives = this.initial_lives;
    }

    public void initNewLife() {
    }

    public void defineLevel() {
    }

    public void decrementLives() {
        --this.lives;
    }

    public void incrementLevel() {
        ++this.level;
        ++this.stage;
    }

    public void startGame() {
        this.startGame(0);
    }

    public void startGame(int n) {
        this.gametime = 0.0;
        this.initNewGame(n);
        this.defineLevel();
        this.initNewLife();
        this.clearKey(this.key_continuegame);
        this.seqtimer = 0.0;
        if (this.startgame_ticks > 0) {
            this.setGameState("StartLevel");
            this.addGameState("StartGame");
            if (this.startgame_ingame) {
                this.addGameState("InGame");
            }
            new JGTimer(this.startgame_ticks, true, "StartLevel"){

                public void alarm() {
                    StdGame.this.setGameState("InGame");
                }
            };
        } else {
            this.setGameState("InGame");
        }
    }

    public final void lifeLost() {
        if (!this.inGameState("InGame") || this.inGameState("LevelDone") || this.inGameState("LifeLost") || this.inGameState("GameOver")) {
            return;
        }
        this.clearKey(this.key_continuegame);
        this.removeGameState("StartLevel");
        this.removeGameState("StartGame");
        this.seqtimer = 0.0;
        if (this.lifelost_ticks > 0) {
            if (this.lifelost_ingame) {
                this.addGameState("LifeLost");
            } else {
                this.setGameState("LifeLost");
            }
            new JGTimer(this.lifelost_ticks, true, "LifeLost"){

                public void alarm() {
                    StdGame.this.endLifeLost();
                }
            };
        } else {
            this.endLifeLost();
        }
    }

    private void endLifeLost() {
        this.clearKey(this.key_continuegame);
        this.decrementLives();
        if (this.lives <= 0) {
            this.gameOver();
        } else {
            this.initNewLife();
            this.seqtimer = 0.0;
            if (this.startgame_ticks > 0) {
                this.setGameState("StartGame");
                if (this.startgame_ingame) {
                    this.addGameState("InGame");
                }
                new JGTimer(this.startgame_ticks, true, "StartGame"){

                    public void alarm() {
                        StdGame.this.setGameState("InGame");
                    }
                };
            } else {
                this.clearGameState();
                this.setGameState("InGame");
            }
        }
    }

    public final void levelDone() {
        if (!this.inGameState("InGame") || this.inGameState("LevelDone") || this.inGameState("LifeLost") || this.inGameState("GameOver")) {
            return;
        }
        this.clearKey(this.key_continuegame);
        this.removeGameState("StartLevel");
        this.removeGameState("StartGame");
        this.seqtimer = 0.0;
        if (this.leveldone_ticks > 0) {
            if (this.leveldone_ingame) {
                this.addGameState("LevelDone");
            } else {
                this.setGameState("LevelDone");
            }
            new JGTimer(this.leveldone_ticks, true, "LevelDone"){

                public void alarm() {
                    StdGame.this.levelDoneToStartLevel();
                }
            };
        } else {
            this.levelDoneToStartLevel();
        }
    }

    private void levelDoneToStartLevel() {
        this.clearKey(this.key_continuegame);
        this.gametime = 0.0;
        this.incrementLevel();
        this.defineLevel();
        this.seqtimer = 0.0;
        if (this.startgame_ticks > 0) {
            this.setGameState("StartLevel");
            this.addGameState("StartGame");
            if (this.startgame_ingame) {
                this.addGameState("InGame");
            }
            new JGTimer(this.startgame_ticks, true, "StartLevel"){

                public void alarm() {
                    StdGame.this.setGameState("InGame");
                }
            };
        } else {
            this.clearGameState();
            this.setGameState("InGame");
        }
    }

    public final void gameOver() {
        if (this.inGameState("GameOver") || !this.inGameState("InGame") && !this.inGameState("LifeLost")) {
            return;
        }
        this.clearKey(this.key_continuegame);
        this.removeGameState("StartLevel");
        this.removeGameState("StartGame");
        this.removeGameState("LifeLost");
        this.seqtimer = 0.0;
        if (this.gameover_ticks > 0) {
            if (this.gameover_ingame) {
                this.addGameState("GameOver");
            } else {
                this.setGameState("GameOver");
            }
            new JGTimer(this.gameover_ticks, true, "GameOver"){

                public void alarm() {
                    StdGame.this.gotoTitle();
                }
            };
        } else {
            this.gotoTitle();
        }
    }

    private void gotoTitle() {
        this.seqtimer = 0.0;
        this.clearKey(this.key_startgame);
        if (this.highscores != null && Highscore.findPos(this.highscores, this.score) >= 0) {
            this.setGameState("EnterHighscore");
        } else {
            this.setGameState("Title");
        }
    }

    public void initAppConfig() {
        this.appconfig = new AppConfig(this.getClass().getName().substring(this.getClass().getName().indexOf(46) + 1) + " settings", this, this.getConfigPath(this.getClass().getName() + ".cfg"));
        this.appconfig.defineField("audioenabled", "Enable Sound", "boolean");
        this.appconfig.defineFields("key_", "", "", "", "key");
        this.appconfig.loadFromFile();
        this.appconfig.saveToObject();
    }

    public void doFrame() {
        if (this.audioenabled) {
            this.enableAudio();
        } else {
            this.disableAudio();
        }
        if (this.inGameState("Paused")) {
            this.clearKey(this.key_pausegame);
            this.removeGameState("Paused");
            this.stop();
        }
        if (this.getKey(this.key_pausegame) && !this.inGameState("EnterHighscore")) {
            this.addGameState("Paused");
            this.clearKey(this.key_pausegame);
            this.wakeUpOnKey(this.key_pausegame);
        }
        this.timer += this.getGameSpeed();
        this.seqtimer += this.getGameSpeed();
        if (this.just_inited) {
            this.setGameState("Title");
            this.just_inited = false;
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    StdGame.this.initAppConfig();
                    if (StdGame.this.appconfig != null) {
                        StdGame.this.appconfig.setListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                StdGame.this.start();
                                StdGame.this.requestGameFocus();
                            }
                        });
                    }
                }
            });
            thread.start();
            try {
                Highscore[] highscoreArray = Highscore.load(new FileInputStream(this.getConfigPath(this.getClass().getName() + ".hsc")));
                if (highscoreArray.length > 0) {
                    this.highscores = highscoreArray;
                }
            }
            catch (Exception exception) {}
        } else if (this.inGameState("InGame")) {
            this.gametime += this.getGameSpeed();
            if (this.getKey(this.key_quitgame)) {
                this.gameOver();
            }
        } else if (this.inGameState("Title") || this.inGameState("Highscores")) {
            if (this.getKey(this.key_quitprogram) && !this.isApplet()) {
                this.clearKey(this.key_quitprogram);
                new Thread(new QuitgameThread()).start();
                this.stop();
            }
            if (this.getKey(this.key_gamesettings) && this.appconfig != null) {
                this.appconfig.openGui();
                this.clearKey(this.key_gamesettings);
                this.stop();
            }
            if (this.getKey(this.key_startgame)) {
                this.startGame();
            }
            if (this.highscores != null) {
                if (this.getKey(this.key_continuegame)) {
                    this.clearKey(this.key_continuegame);
                    this.seqtimer = 0.0;
                    if (this.inGameState("Title")) {
                        this.setGameState("Highscores");
                    } else {
                        this.setGameState("Title");
                    }
                }
                if (this.inGameState("Title") && this.seqtimer >= (double)this.highscore_waittime) {
                    this.seqtimer = 0.0;
                    this.setGameState("Highscores");
                } else if (this.inGameState("Highscores") && this.seqtimer >= (double)this.highscore_showtime) {
                    this.seqtimer = 0.0;
                    this.setGameState("Title");
                }
            }
        } else if (this.inGameState("StartGame")) {
            if (this.getKey(this.key_continuegame)) {
                this.setGameState("InGame");
            }
        } else if (this.inGameState("LevelDone")) {
            if (this.getKey(this.key_continuegame)) {
                this.levelDoneToStartLevel();
            }
        } else if (this.inGameState("LifeLost")) {
            if (this.getKey(this.key_continuegame)) {
                this.endLifeLost();
            }
        } else if (this.inGameState("GameOver") && this.getKey(this.key_continuegame)) {
            this.gotoTitle();
        }
    }

    public void doFrameEnterHighscore() {
        char c = this.getLastKeyChar();
        this.clearLastKey();
        if (c == '\b' && this.playername.length() > 0) {
            this.playername = this.playername.substring(0, this.playername.length() - 1);
        }
        if (c == '\n') {
            this.highscores = Highscore.insert(this.highscores, new Highscore(this.score, this.playername));
            this.clearLastKey();
            this.clearKey(10);
            this.saveHighscores();
            this.seqtimer = 0.0;
            this.setGameState("Highscores");
        }
        if (c >= ' ' && c < '\u007f' && this.playername.length() < this.highscore_maxnamelen) {
            this.playername = this.playername + c;
        }
    }

    public boolean saveHighscores() {
        try {
            Highscore.save(this.highscores, new FileOutputStream(this.getConfigPath(this.getClass().getName() + ".hsc")));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void startTitle() {
    }

    public void startHighscores() {
    }

    public void startInGame() {
    }

    public void startStartLevel() {
    }

    public void startStartGame() {
    }

    public void startLevelDone() {
    }

    public void startLifeLost() {
    }

    public void startGameOver() {
    }

    public void startEnterHighscore() {
        this.clearLastKey();
        this.playername = "";
    }

    public void paintFrame() {
        this.setFont(this.status_font);
        this.setColor(this.status_color);
        this.drawString("Score " + this.score, this.status_l_margin, 0.0, -1);
        if (this.lives_img == null) {
            this.drawString("Lives " + this.lives, this.viewWidth() - this.status_r_margin, 0.0, 1);
        } else {
            this.drawCount(this.lives - 1, this.lives_img, this.viewWidth() - this.status_r_margin, 0, -this.getImageSize((String)this.lives_img).x - 2);
        }
    }

    public void paintFrameTitle() {
        this.drawString(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1), this.viewWidth() / 2, (double)(this.viewHeight() / 3), 0, this.title_font, this.title_color);
        this.drawString("Press " + this.getKeyDesc(this.key_startgame) + " to start", this.viewWidth() / 2, (double)(6 * this.viewHeight() / 10), 0, this.title_font, this.title_color);
        this.drawString("Press " + this.getKeyDesc(this.key_gamesettings) + " for settings", this.viewWidth() / 2, (double)(7 * this.viewHeight() / 10), 0, this.title_font, this.title_color);
    }

    public void paintFramePaused() {
        this.setColor(this.title_bg_color);
        this.drawRect(this.viewWidth() / 20, 15 * this.viewHeight() / 36, 18 * this.viewWidth() / 20, 5 * this.viewHeight() / 36 + (int)this.getFontHeight(this.title_font), true, false, false);
        this.drawString("Paused", this.viewWidth() / 2, (double)(16 * this.viewHeight() / 36), 0, this.title_font, this.title_color);
        this.drawString("Press " + this.getKeyDesc(this.key_pausegame) + " to continue", this.viewWidth() / 2, (double)(19 * this.viewHeight() / 36), 0, this.title_font, this.title_color);
    }

    public void paintFrameStartLevel() {
        this.drawString("Level " + (this.stage + 1), this.viewWidth() / 2, (double)(3 * this.viewHeight() / 5), 0, this.title_font, this.title_color);
    }

    public void paintFrameStartGame() {
        this.drawString("Start !", this.viewWidth() / 2, (double)(this.viewHeight() / 3), 0, this.title_font, this.title_color);
    }

    public void paintFrameLevelDone() {
        this.drawString("Level Done !", this.viewWidth() / 2, (double)(this.viewHeight() / 3), 0, this.title_font, this.title_color);
    }

    public void paintFrameLifeLost() {
        this.drawString("Life Lost !", this.viewWidth() / 2, (double)(this.viewHeight() / 3), 0, this.title_font, this.title_color);
    }

    public void paintFrameGameOver() {
        this.drawString("Game Over !", this.viewWidth() / 2, (double)(this.viewHeight() / 3), 0, this.title_font, this.title_color);
    }

    public void paintFrameEnterHighscore() {
        this.drawString(this.highscore_entry, this.viewWidth() / 2, (double)(this.viewHeight() / 3), 0, this.highscore_title_font, this.highscore_title_color);
        this.drawString("" + this.score, this.viewWidth() / 2, (double)(this.viewHeight() / 2), 0, this.highscore_font, this.highscore_color);
        this.drawString(this.playername + "|", this.viewWidth() / 2, (double)(2 * this.viewHeight() / 3), 0, this.highscore_font, this.highscore_color);
    }

    public void paintFrameHighscores() {
        this.drawString(this.highscore_title, this.viewWidth() / 2, (double)(this.viewHeight() / 7), 0, this.highscore_title_font, this.highscore_title_color);
        double d = 0.7 * (double)this.viewHeight() / (double)this.highscores.length;
        double d2 = 0.6 * (double)this.viewHeight() - d * ((double)this.highscores.length / 2.0);
        for (int i = 0; i < this.highscores.length; ++i) {
            this.drawString("" + this.highscores[i].score, 0.35 * (double)this.viewWidth(), d2 + (double)i * d, 1, this.highscore_font, this.highscore_color);
            this.drawString(this.highscores[i].name, 0.6 * (double)this.viewWidth(), d2 + (double)i * d, 0, this.highscore_font, this.highscore_color);
        }
    }

    public boolean checkTime(int n, int n2, int n3) {
        return this.gametime > (double)n && this.gametime < (double)n2 && (this.gametime - 1.0) % (double)n3 < this.getGameSpeed();
    }

    public boolean checkTime(int n) {
        return (this.gametime - 1.0) % (double)n < this.getGameSpeed();
    }

    public void drawCount(int n, String string, int n2, int n3, int n4) {
        if (n4 < 0) {
            n2 += n4;
        }
        for (int i = 0; i < n; ++i) {
            this.drawImage(n2 + i * n4, n3, string, false);
        }
    }

    public void drawWavyString(String string, int n, int n2, int n3, int n4, double d, double d2, double d3, double d4, JGFont jGFont, JGColor jGColor) {
        this.setFont(jGFont);
        this.setColor(jGColor);
        if (n3 == 0) {
            n -= n4 * string.length() / 2;
        } else if (n3 == 1) {
            n -= n4 * string.length();
        }
        for (int i = 0; i < string.length(); ++i) {
            this.drawString(string.substring(i, i + 1), n + i * n4, n2 + (int)(d2 * -Math.cos(Math.PI * (d3 * (double)i + d * d4))), 0);
        }
    }

    public JGFont getZoomingFont(JGFont jGFont, double d, double d2, double d3) {
        return new JGFont(jGFont.name, jGFont.style, jGFont.size * (d2 + 0.5 - 0.5 * Math.cos(Math.PI * d3 * d)));
    }

    public JGColor cycleColor(JGColor[] jGColorArray, double d, double d2) {
        return jGColorArray[(int)(d * d2) % jGColorArray.length];
    }

    public int posWalkForwards(int n, int n2, double d, int n3, int n4, int n5, int n6) {
        if (d < (double)n5) {
            double d2 = (double)(n4 - n) / (double)n5;
            return n + (int)(d * d2);
        }
        if (d >= (double)n5 && d < (double)(n5 + n6)) {
            return n4;
        }
        if (d >= (double)(n5 + n6) && d < (double)n3) {
            int n7 = n5 + n6;
            double d3 = (double)(n2 - n4) / (double)(n3 - n7);
            return n4 + (int)((d - (double)n7) * d3);
        }
        return n2;
    }

    class QuitgameThread
    implements Runnable {
        public void run() {
            int n = JOptionPane.showConfirmDialog(null, "Really quit?", "Quit Game", 2);
            if (n == 0) {
                System.exit(0);
            }
            StdGame.this.start();
        }
    }
}

