/*
 * Decompiled with CFR 0.152.
 */
package jgame;

import jgame.JGPoint;
import jgame.JGRectangle;
import jgame.impl.Animation;
import jgame.impl.JGEngineInterface;

public class JGObject {
    static int next_id = 0;
    static JGEngineInterface default_engine = null;
    public static int viewwidth;
    public static int viewheight;
    public static int tilewidth;
    public static int tileheight;
    public static boolean pfwrapx;
    public static boolean pfwrapy;
    public static double gamespeed;
    public static int pfwidth;
    public static int pfheight;
    public static int viewxofs;
    public static int viewyofs;
    public static final int expire_never = -1;
    public static final int expire_off_pf = -2;
    public static final int expire_off_view = -3;
    public static final int suspend_off_view = -4;
    public static final int suspend_off_view_expire_off_pf = -5;
    public double x = 0.0;
    public double y = 0.0;
    public double xspeed = 0.0;
    public double yspeed = 0.0;
    public int xdir = 1;
    public int ydir = 1;
    public int colid;
    String name;
    public double expiry = -1.0;
    public boolean resume_in_view = true;
    private boolean is_alive = true;
    public boolean is_suspended = false;
    String imgname = null;
    Animation anim = null;
    String animid = null;
    JGRectangle imgbbox = null;
    JGRectangle tilebbox = null;
    JGRectangle bbox = null;
    public JGEngineInterface eng;
    double lastx = 0.0;
    double lasty = 0.0;
    JGRectangle lastbbox_copy = new JGRectangle();
    JGRectangle lasttilebbox_copy = new JGRectangle();
    JGRectangle lastbbox = null;
    JGRectangle lasttilebbox = null;
    JGRectangle temp_bbox_copy = new JGRectangle();
    JGRectangle tiles_copy = null;
    JGRectangle last_tiles_copy = null;
    JGRectangle center_tiles_copy = new JGRectangle();
    JGRectangle last_center_tiles_copy = null;
    JGPoint center_tile_copy = null;
    JGPoint tl_tile_copy = null;

    public static boolean setEngine(JGEngineInterface jGEngineInterface) {
        if (jGEngineInterface == null) {
            default_engine = null;
            return true;
        }
        if (default_engine != null) {
            return false;
        }
        default_engine = jGEngineInterface;
        viewwidth = jGEngineInterface.viewWidth();
        viewheight = jGEngineInterface.viewHeight();
        tilewidth = jGEngineInterface.tileWidth();
        tileheight = jGEngineInterface.tileHeight();
        JGObject.updateEngineSettings();
        return true;
    }

    public static void updateEngineSettings() {
        pfwrapx = default_engine.pfWrapX();
        pfwrapy = default_engine.pfWrapY();
        gamespeed = default_engine.getGameSpeed();
        pfwidth = default_engine.pfWidth();
        pfheight = default_engine.pfHeight();
        viewxofs = default_engine.viewXOfs();
        viewyofs = default_engine.viewYOfs();
    }

    public void dbgPrint(String string) {
        this.eng.dbgPrint(this.name, string);
    }

    public String getName() {
        return this.name;
    }

    public String getImageName() {
        return this.imgname;
    }

    private void initObject(JGEngineInterface jGEngineInterface, String string, int n) {
        this.eng = jGEngineInterface;
        this.name = string;
        this.colid = n;
        if (!((int)this.expiry != -4 && (int)this.expiry != -5 || this.isInView(this.eng.getOffscreenMarginX(), this.eng.getOffscreenMarginY()))) {
            this.suspend();
        }
        this.eng.markAddObject(this);
    }

    public void clearTileBBox() {
        this.tilebbox = null;
    }

    public void setTileBBox(int n, int n2, int n3, int n4) {
        this.tilebbox = new JGRectangle(n, n2, n3, n4);
    }

    public void setBBox(int n, int n2, int n3, int n4) {
        this.bbox = new JGRectangle(n, n2, n3, n4);
    }

    public void clearBBox() {
        this.bbox = null;
    }

    public void setPos(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void setSpeedAbs(double d, double d2) {
        if (d < 0.0) {
            this.xdir = -1;
            this.xspeed = -d;
        } else if (d == 0.0) {
            this.xdir = 0;
            this.xspeed = 0.0;
        } else {
            this.xdir = 1;
            this.xspeed = d;
        }
        if (d2 < 0.0) {
            this.ydir = -1;
            this.yspeed = -d2;
        } else if (d2 == 0.0) {
            this.ydir = 0;
            this.yspeed = 0.0;
        } else {
            this.ydir = 1;
            this.yspeed = d2;
        }
    }

    public void setDirSpeed(int n, int n2, double d, double d2) {
        this.xdir = n;
        this.ydir = n2;
        this.xspeed = d;
        this.yspeed = d2;
    }

    public void setDirSpeed(int n, int n2, double d) {
        this.xdir = n;
        this.ydir = n2;
        this.xspeed = d;
        this.yspeed = d;
    }

    public void setSpeed(double d, double d2) {
        this.xspeed = d;
        this.yspeed = d2;
    }

    public void setSpeed(double d) {
        this.xspeed = d;
        this.yspeed = d;
    }

    public void setDir(int n, int n2) {
        this.xdir = n;
        this.ydir = n2;
    }

    public void setGraphic(String string) {
        if (string == null) {
            this.setImage(string);
        } else {
            Animation animation = this.eng.getAnimation(string);
            if (animation != null) {
                this.setAnim(string);
            } else {
                this.setImage(string);
            }
        }
    }

    public void setImage(String string) {
        this.imgname = string;
        this.imgbbox = null;
        this.anim = null;
        this.animid = null;
    }

    public String getGraphic() {
        if (this.animid != null) {
            return this.animid;
        }
        return this.imgname;
    }

    public void setAnim(String string) {
        if (this.animid == null || !this.animid.equals(string)) {
            this.anim = this.eng.getAnimation(string);
            if (this.anim == null) {
                this.eng.dbgPrint(this.name, "Warning: animation " + string + " not found.");
                return;
            }
            this.anim = this.anim.copy();
            this.animid = string;
            this.imgname = this.anim.getCurrentFrame();
        }
    }

    public void resetAnim(String string) {
        this.anim = this.eng.getAnimation(string).copy();
        this.animid = string;
    }

    public void clearAnim() {
        this.anim = null;
        this.animid = null;
    }

    public String getAnimId() {
        return this.animid;
    }

    public void setAnimSpeed(double d) {
        if (this.anim != null) {
            if (d >= 0.0) {
                this.anim.speed = d;
                this.anim.increment = 1;
            } else {
                this.anim.speed = -d;
                this.anim.increment = -1;
            }
        }
    }

    public void setAnimPingpong(boolean bl) {
        if (this.anim != null) {
            this.anim.pingpong = bl;
        }
    }

    public void startAnim() {
        if (this.anim != null) {
            this.anim.start();
        }
    }

    public void stopAnim() {
        if (this.anim != null) {
            this.anim.stop();
        }
    }

    public void resetAnim() {
        if (this.anim != null) {
            this.anim.reset();
        }
    }

    public JGObject(String string, boolean bl, double d, double d2, int n, String string2) {
        this.initObject(default_engine, string + (bl ? "" + next_id++ : ""), n);
        this.setPos(d, d2);
        this.setGraphic(string2);
    }

    public JGObject(String string, boolean bl, double d, double d2, int n, String string2, int n2) {
        this.initObject(default_engine, string + (bl ? "" + next_id++ : ""), n);
        this.setPos(d, d2);
        this.setGraphic(string2);
        this.expiry = n2;
    }

    public JGObject(String string, boolean bl, double d, double d2, int n, String string2, int n2, int n3, int n4, int n5) {
        this.setPos(d, d2);
        this.initObject(default_engine, string + (bl ? "" + next_id++ : ""), n);
        this.setGraphic(string2);
        this.setTileBBox(n2, n3, n4, n5);
    }

    public JGObject(String string, boolean bl, double d, double d2, int n, String string2, int n2, int n3, int n4, int n5, int n6) {
        this.setPos(d, d2);
        this.initObject(default_engine, string + (bl ? "" + next_id++ : ""), n);
        this.setGraphic(string2);
        this.setTileBBox(n2, n3, n4, n5);
        this.expiry = n6;
    }

    public JGObject(String string, boolean bl, double d, double d2, int n, String string2, double d3, double d4) {
        this.setPos(d, d2);
        this.initObject(default_engine, string + (bl ? "" + next_id++ : ""), n);
        this.setGraphic(string2);
        this.setSpeedAbs(d3, d4);
    }

    public JGObject(String string, boolean bl, double d, double d2, int n, String string2, double d3, double d4, int n2) {
        this.setPos(d, d2);
        this.initObject(default_engine, string + (bl ? "" + next_id++ : ""), n);
        this.setGraphic(string2);
        this.setSpeedAbs(d3, d4);
        this.expiry = n2;
    }

    public JGObject(String string, boolean bl, double d, double d2, int n, String string2, int n2, int n3, int n4, int n5, double d3, double d4) {
        this.setPos(d, d2);
        this.initObject(default_engine, string + (bl ? "" + next_id++ : ""), n);
        this.setGraphic(string2);
        this.setTileBBox(n2, n3, n4, n5);
        this.setSpeedAbs(d3, d4);
    }

    public JGObject(String string, boolean bl, double d, double d2, int n, String string2, int n2, int n3, int n4, int n5, double d3, double d4, int n6) {
        this.setPos(d, d2);
        this.initObject(default_engine, string + (bl ? "" + next_id++ : ""), n);
        this.setGraphic(string2);
        this.setTileBBox(n2, n3, n4, n5);
        this.setSpeedAbs(d3, d4);
        this.expiry = n6;
    }

    public JGObject(String string, boolean bl, double d, double d2, int n, String string2, int n2, int n3, double d3, double d4, int n4) {
        this.setPos(d, d2);
        this.initObject(default_engine, string + (bl ? "" + next_id++ : ""), n);
        this.setGraphic(string2);
        this.setDirSpeed(n2, n3, d3, d4);
        this.expiry = n4;
    }

    public JGObject(String string, boolean bl, double d, double d2, int n, String string2, int n2, int n3, int n4, int n5, int n6, int n7, double d3, double d4, int n8) {
        this.setPos(d, d2);
        this.initObject(default_engine, string + (bl ? "" + next_id++ : ""), n);
        this.setGraphic(string2);
        this.setTileBBox(n2, n3, n4, n5);
        this.setDirSpeed(n6, n7, d3, d4);
        this.expiry = n8;
    }

    public boolean getBBox(JGRectangle jGRectangle) {
        if (this.bbox != null) {
            jGRectangle.x = this.bbox.x + (int)this.x;
            jGRectangle.y = this.bbox.y + (int)this.y;
            jGRectangle.width = this.bbox.width;
            jGRectangle.height = this.bbox.height;
            return true;
        }
        if (this.imgbbox == null && this.imgname != null) {
            this.imgbbox = this.eng.getImageBBox(this.imgname);
        }
        if (this.imgbbox != null) {
            jGRectangle.x = this.imgbbox.x + (int)this.x;
            jGRectangle.y = this.imgbbox.y + (int)this.y;
            jGRectangle.width = this.imgbbox.width;
            jGRectangle.height = this.imgbbox.height;
            return true;
        }
        return false;
    }

    public JGRectangle getBBox() {
        if (this.bbox != null) {
            return new JGRectangle(this.bbox.x + (int)this.x, this.bbox.y + (int)this.y, this.bbox.width, this.bbox.height);
        }
        this.updateImageBBox();
        if (this.imgbbox != null) {
            return new JGRectangle(this.imgbbox.x + (int)this.x, this.imgbbox.y + (int)this.y, this.imgbbox.width, this.imgbbox.height);
        }
        return null;
    }

    public boolean getTileBBox(JGRectangle jGRectangle) {
        if (this.tilebbox == null) {
            return this.getBBox(jGRectangle);
        }
        jGRectangle.x = (int)this.x + this.tilebbox.x;
        jGRectangle.y = (int)this.y + this.tilebbox.y;
        jGRectangle.width = this.tilebbox.width;
        jGRectangle.height = this.tilebbox.height;
        return true;
    }

    public JGRectangle getTileBBox() {
        if (this.tilebbox == null) {
            return this.getBBox();
        }
        return new JGRectangle((int)this.x + this.tilebbox.x, (int)this.y + this.tilebbox.y, this.tilebbox.width, this.tilebbox.height);
    }

    public JGRectangle getImageBBox() {
        this.updateImageBBox();
        if (this.imgbbox == null) {
            return null;
        }
        return new JGRectangle(this.imgbbox);
    }

    public JGRectangle getImageBBoxConst() {
        this.updateImageBBox();
        return this.imgbbox;
    }

    void updateImageBBox() {
        if (this.imgbbox == null && this.imgname != null) {
            this.imgbbox = this.eng.getImageBBox(this.imgname);
        }
    }

    public double getLastX() {
        return this.lastx;
    }

    public double getLastY() {
        return this.lasty;
    }

    public void snapToGrid() {
        this.x = this.eng.snapToGridX(this.x, Math.abs(this.xspeed * gamespeed - 0.001));
        this.y = this.eng.snapToGridY(this.y, Math.abs(this.yspeed * gamespeed - 0.001));
    }

    public void snapToGrid(double d, double d2) {
        this.x = this.eng.snapToGridX(this.x, d);
        this.y = this.eng.snapToGridY(this.y, d2);
    }

    public void snapBBoxToGrid(double d, double d2, boolean bl, boolean bl2) {
        JGRectangle jGRectangle = this.getTileBBox();
        double d3 = this.x + (double)jGRectangle.x;
        double d4 = this.y + (double)jGRectangle.y;
        if (bl) {
            d3 += (double)jGRectangle.width;
        }
        if (bl2) {
            d4 += (double)jGRectangle.height;
        }
        double d5 = this.eng.snapToGridX(d3, d);
        double d6 = this.eng.snapToGridY(d4, d2);
        d5 -= (double)jGRectangle.x;
        d6 -= (double)jGRectangle.y;
        if (bl) {
            d5 -= (double)jGRectangle.width;
        }
        if (bl2) {
            d6 -= (double)jGRectangle.height;
        }
        this.x = d5;
        this.y = d6;
    }

    public JGRectangle getTiles() {
        if (!this.getTileBBox(this.temp_bbox_copy)) {
            return null;
        }
        if (this.tiles_copy == null) {
            this.tiles_copy = new JGRectangle();
        }
        if (this.eng.getTiles(this.tiles_copy, this.temp_bbox_copy)) {
            return this.tiles_copy;
        }
        return null;
    }

    private JGRectangle getCenterTiles(JGRectangle jGRectangle, JGRectangle jGRectangle2) {
        if (jGRectangle.x >= 0) {
            int n = (jGRectangle.x + jGRectangle.width / 2) / tilewidth * tilewidth + tilewidth / 2;
            jGRectangle.x = tilewidth * ((n - jGRectangle.width / 2) / tilewidth);
        } else {
            int n = (jGRectangle.x + jGRectangle.width / 2 - tilewidth + 1) / tilewidth * tilewidth + tilewidth / 2;
            jGRectangle.x = tilewidth * ((n - jGRectangle.width / 2 - tilewidth + 1) / tilewidth);
        }
        if (jGRectangle.y >= 0) {
            int n = (jGRectangle.y + jGRectangle.height / 2) / tileheight * tileheight + tileheight / 2;
            jGRectangle.y = tileheight * ((n - jGRectangle.height / 2) / tileheight);
        } else {
            int n = (jGRectangle.y + jGRectangle.height / 2 - tileheight + 1) / tileheight * tileheight + tileheight / 2;
            jGRectangle.y = tileheight * ((n - jGRectangle.height / 2 - tileheight + 1) / tileheight);
        }
        this.eng.getTiles(jGRectangle2, jGRectangle);
        return jGRectangle2;
    }

    public JGRectangle getCenterTiles() {
        if (!this.getTileBBox(this.temp_bbox_copy)) {
            return null;
        }
        return this.getCenterTiles(this.temp_bbox_copy, this.center_tiles_copy);
    }

    public JGPoint getCenterTile() {
        if (!this.getTileBBox(this.temp_bbox_copy)) {
            return null;
        }
        if (this.center_tile_copy == null) {
            this.center_tile_copy = new JGPoint();
        }
        this.getCenterTiles(this.temp_bbox_copy, this.center_tiles_copy);
        this.center_tile_copy.x = this.center_tiles_copy.x;
        this.center_tile_copy.y = this.center_tiles_copy.y;
        return this.center_tile_copy;
    }

    public JGPoint getTopLeftTile() {
        JGRectangle jGRectangle = this.getTiles();
        if (jGRectangle == null) {
            return null;
        }
        if (this.tl_tile_copy == null) {
            this.tl_tile_copy = new JGPoint();
        }
        this.tl_tile_copy.x = jGRectangle.x;
        this.tl_tile_copy.y = jGRectangle.y;
        return this.tl_tile_copy;
    }

    public boolean isAligned() {
        return this.isXAligned() && this.isYAligned();
    }

    public boolean isXAligned() {
        return this.eng.isXAligned(this.x, Math.abs(this.xspeed * gamespeed - 0.001));
    }

    public boolean isYAligned() {
        return this.eng.isYAligned(this.y, Math.abs(this.yspeed * gamespeed - 0.001));
    }

    public boolean isXAligned(double d) {
        return this.eng.isXAligned(this.x, d);
    }

    public boolean isYAligned(double d) {
        return this.eng.isYAligned(this.y, d);
    }

    public boolean isLeftAligned(double d) {
        JGRectangle jGRectangle = this.getTileBBox();
        if (jGRectangle != null) {
            return this.eng.isXAligned(jGRectangle.x, d);
        }
        return this.eng.isXAligned(this.x, d);
    }

    public boolean isTopAligned(double d) {
        JGRectangle jGRectangle = this.getTileBBox();
        if (jGRectangle != null) {
            return this.eng.isYAligned(jGRectangle.y, d);
        }
        return this.eng.isYAligned(this.y, d);
    }

    public boolean isRightAligned(double d) {
        JGRectangle jGRectangle = this.getTileBBox();
        if (jGRectangle != null) {
            return this.eng.isXAligned(jGRectangle.x + jGRectangle.width, d);
        }
        return this.eng.isXAligned(this.x, d);
    }

    public boolean isBottomAligned(double d) {
        JGRectangle jGRectangle = this.getTileBBox();
        if (jGRectangle != null) {
            return this.eng.isYAligned(jGRectangle.y + jGRectangle.height, d);
        }
        return this.eng.isYAligned(this.y, d);
    }

    public int checkCollision(int n, double d, double d2) {
        double d3 = this.x;
        double d4 = this.y;
        this.x += d;
        this.y += d2;
        int n2 = this.eng.checkCollision(n, this);
        this.x = d3;
        this.y = d4;
        return n2;
    }

    public int checkBGCollision(JGRectangle jGRectangle) {
        return this.eng.checkBGCollision(jGRectangle);
    }

    public int checkBGCollision(double d, double d2) {
        double d3 = this.x;
        double d4 = this.y;
        this.x += d;
        this.y += d2;
        JGRectangle jGRectangle = this.getTileBBox();
        this.x = d3;
        this.y = d4;
        if (jGRectangle == null) {
            return 0;
        }
        return this.checkBGCollision(jGRectangle);
    }

    public boolean isOnScreen(int n, int n2) {
        return this.isOnPF(n, n2);
    }

    public boolean isInView(int n, int n2) {
        if (!this.getTileBBox(this.temp_bbox_copy)) {
            this.temp_bbox_copy.x = (int)this.x;
            this.temp_bbox_copy.y = (int)this.y;
            this.temp_bbox_copy.width = 0;
            this.temp_bbox_copy.height = 0;
        }
        if (this.temp_bbox_copy.x + this.temp_bbox_copy.width < viewxofs - n) {
            return false;
        }
        if (this.temp_bbox_copy.y + this.temp_bbox_copy.height < viewyofs - n2) {
            return false;
        }
        if (this.temp_bbox_copy.x > viewxofs + viewwidth + n) {
            return false;
        }
        return this.temp_bbox_copy.y <= viewyofs + viewheight + n2;
    }

    public boolean isOnPF(int n, int n2) {
        if (!this.getTileBBox(this.temp_bbox_copy)) {
            this.temp_bbox_copy.x = (int)this.x;
            this.temp_bbox_copy.y = (int)this.y;
            this.temp_bbox_copy.width = 0;
            this.temp_bbox_copy.height = 0;
        }
        if (!pfwrapx) {
            if (this.temp_bbox_copy.x + this.temp_bbox_copy.width < -n) {
                return false;
            }
            if (this.temp_bbox_copy.x > pfwidth + n) {
                return false;
            }
        }
        if (!pfwrapy) {
            if (this.temp_bbox_copy.y + this.temp_bbox_copy.height < -n2) {
                return false;
            }
            if (this.temp_bbox_copy.y > pfheight + n2) {
                return false;
            }
        }
        return true;
    }

    public static boolean and(int n, int n2) {
        return (n & n2) != 0;
    }

    public void updateAnimation(double d) {
        if (this.anim != null) {
            this.imgname = this.anim.animate(d);
            this.imgbbox = null;
        }
    }

    public void frameFinished() {
        this.lastx = this.x;
        this.lasty = this.y;
    }

    public void moduloPos() {
        if (pfwrapx) {
            this.x = this.eng.moduloXPos(this.x);
        }
        if (pfwrapy) {
            this.y = this.eng.moduloYPos(this.y);
        }
    }

    public void suspend() {
        this.is_suspended = true;
    }

    public void resume() {
        this.is_suspended = false;
    }

    public boolean isSuspended() {
        return this.is_suspended;
    }

    public void setResumeMode(boolean bl) {
        this.resume_in_view = bl;
    }

    public boolean isAlive() {
        return this.is_alive;
    }

    public final void removeDone() {
        this.destroy();
        this.is_alive = false;
    }

    public void remove() {
        if (this.isAlive()) {
            this.eng.removeObject(this);
        }
        this.is_alive = false;
    }

    public void destroy() {
    }

    public void move() {
    }

    public void hit(JGObject jGObject) {
    }

    public void hit_bg(int n) {
    }

    public void hit_bg(int n, int n2, int n3, int n4, int n5) {
    }

    public void hit_bg(int n, int n2, int n3) {
    }

    public void paint() {
    }
}

