/*
 * Decompiled with CFR 0.152.
 */
package jgame.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGImage;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.JGRectangle;
import jgame.JGTimer;
import jgame.impl.Animation;
import jgame.impl.ImageMap;
import jgame.impl.JGEngineInterface;
import jgame.impl.JGameError;
import jgame.impl.SortedArray;

public class EngineLogic {
    JGImage imageutil;
    Random random;
    boolean make_bitmask;
    boolean prescale;
    public boolean view_initialised = false;
    public JGColor fg_color = JGColor.white;
    public JGColor bg_color = JGColor.black;
    public JGFont msg_font = null;
    public int outline_thickness = 0;
    public JGColor outline_colour = JGColor.black;
    public double fps = 35.0;
    public double maxframeskip = 4.0;
    public double gamespeed = 1.00000000001;
    public Vector gamestate = new Vector(10, 20);
    public Vector gamestate_nextframe = new Vector(10, 20);
    public Vector gamestate_new = new Vector(10, 20);
    boolean in_parallel_upd = false;
    private Vector timers = new Vector(20, 40);
    public boolean is_inited = false;
    public boolean is_exited = false;
    public String exit_message = "JGEngine exited successfully";
    Hashtable animations = new Hashtable();
    public Hashtable images_orig = new Hashtable();
    public Hashtable image_orig_size = new Hashtable();
    public Hashtable images = new Hashtable();
    public Hashtable images_exists = new Hashtable();
    public Hashtable images_transp = new Hashtable();
    public Hashtable images_loaded = new Hashtable();
    public Hashtable images_tile = new Hashtable();
    public Hashtable images_bbox = new Hashtable();
    public Hashtable images_tilecid = new Hashtable();
    public Hashtable imagemaps = new Hashtable();
    public int alpha_thresh = 128;
    public JGColor render_bg_color = null;
    public SortedArray objects = new SortedArray(80);
    SortedArray obj_to_remove = new SortedArray(40);
    Vector obj_spec_to_remove = new Vector(20, 40);
    SortedArray obj_to_add = new SortedArray(40);
    public int nrtilesx;
    public int nrtilesy;
    public int tilex;
    public int tiley;
    public int viewnrtilesx;
    public int viewnrtilesy;
    public double min_aspect = 0.75;
    public double max_aspect = 1.3333333333333333;
    public int crop_top = 0;
    public int crop_left = 0;
    public int crop_bottom = 0;
    public int crop_right = 0;
    public boolean smooth_magnify = true;
    public int width;
    public int height;
    public int pfwidth_half;
    public int pfheight_half;
    public int pfwidth;
    public int pfheight;
    public int canvas_xofs = 0;
    public int canvas_yofs = 0;
    public int scaledtilex;
    public int scaledtiley;
    public int pendingxofs = 0;
    public int pendingyofs = 0;
    public int xofs = 0;
    public int yofs = 0;
    public int tilexofs = -1;
    public int tileyofs = -1;
    public int xofs_scaled = 0;
    public int yofs_scaled = 0;
    public int xofs_mid;
    public int yofs_mid;
    public double x_scale_fac = 1.0;
    public double y_scale_fac = 1.0;
    public double min_scale_fac = 1.0;
    public int winwidth = 0;
    public int winheight = 0;
    public int[][] tilemap = null;
    public int[][] tilecidmap = null;
    public boolean pf_wrapx = false;
    public boolean pf_wrapy = false;
    public int pf_wrapshiftx = 0;
    public int pf_wrapshifty = 0;
    public Vector bg_images = new Vector(8, 20);
    String out_of_bounds_tile = "";
    int out_of_bounds_cid = 0;
    int preserve_cids = 0;
    public int offscreen_margin_x = 16;
    public int offscreen_margin_y = 16;
    public boolean[][] bg_defined = null;
    JGRectangle tmprect1 = new JGRectangle();
    JGRectangle tmprect2 = new JGRectangle();
    JGObject[] srcobj = new JGObject[50];
    JGObject[] dstobj = new JGObject[50];
    public Hashtable audioclips = new Hashtable();

    public EngineLogic(JGImage jGImage, boolean bl, boolean bl2) {
        this.imageutil = jGImage;
        this.make_bitmask = bl;
        this.prescale = bl2;
        this.random = new Random();
        this.bg_images.addElement(null);
    }

    public int viewWidth() {
        return this.viewnrtilesx * this.tilex;
    }

    public int viewHeight() {
        return this.viewnrtilesy * this.tiley;
    }

    public int tileWidth() {
        return this.tilex;
    }

    public int tileHeight() {
        return this.tiley;
    }

    public static Vector tokenizeString(String string, char c) {
        int n;
        Vector<String> vector = new Vector<String>(20, 50);
        int n2 = 0;
        while ((n = string.indexOf(c, n2)) >= 0) {
            if (n > n2) {
                vector.addElement(string.substring(n2, n));
            }
            n2 = n + 1;
        }
        if (n2 < string.length()) {
            vector.addElement(string.substring(n2));
        }
        return vector;
    }

    public static String readline(InputStreamReader inputStreamReader) {
        StringBuffer stringBuffer = null;
        try {
            while (true) {
                int n;
                if ((n = inputStreamReader.read()) == -1) {
                    if (stringBuffer == null) {
                        return null;
                    }
                    return stringBuffer.toString();
                }
                if (n == 10 || n == 13) {
                    if (stringBuffer == null) continue;
                    return stringBuffer.toString();
                }
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append((char)n);
            }
        }
        catch (IOException iOException) {
            if (stringBuffer == null) {
                return null;
            }
            return stringBuffer.toString();
        }
    }

    public String getAbsolutePath(Object object, String string) {
        if (string.indexOf("/") == 0 || string.indexOf("://") >= 0 && string.indexOf("://") <= 5) {
            return string;
        }
        String string2 = object.getClass().getName();
        String string3 = "";
        Vector vector = EngineLogic.tokenizeString(string2, '.');
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (!enumeration.hasMoreElements()) continue;
            string3 = string3 + string4 + "/";
        }
        return "/" + string3 + string;
    }

    public boolean existsImage(String string) {
        return this.images_exists.containsKey(string);
    }

    public Object getTileImage(Integer n) {
        String string = (String)this.images_tile.get(n);
        if (string == null) {
            return null;
        }
        return this.images.get(string);
    }

    public JGPoint getImageSize(String string) {
        return (JGPoint)this.image_orig_size.get(string);
    }

    public JGImage getImageQuick(String string) {
        return (JGImage)this.images.get(string);
    }

    public JGImage getImage(String string) {
        if (!this.existsImage(string)) {
            throw new JGameError("Image '" + string + "' not defined.", true);
        }
        JGImage jGImage = (JGImage)this.images.get(string);
        if (jGImage == null) {
            jGImage = (JGImage)this.images_orig.get(string);
            if (jGImage == null) {
                return null;
            }
            JGColor jGColor = this.render_bg_color;
            if (jGColor == null) {
                jGColor = this.bg_color;
            }
            jGImage = jGImage.toDisplayCompatible(this.alpha_thresh, jGColor, true, this.make_bitmask);
            JGPoint jGPoint = jGImage.getSize();
            if (this.width > 0 && this.height > 0) {
                if (this.prescale) {
                    JGPoint jGPoint2 = this.scalePos(jGPoint.x, jGPoint.y, false);
                    jGImage = jGImage.scale(jGPoint2.x, jGPoint2.y);
                }
                this.images.put(string, jGImage);
            } else {
                throw new JGameError("Image width, height <= 0 !", true);
            }
        }
        return jGImage;
    }

    public JGImage getSubImage(String string, int n) {
        ImageMap imageMap = (ImageMap)this.imagemaps.get(string);
        if (imageMap == null) {
            throw new JGameError("Image map '" + string + "' not found.", true);
        }
        JGPoint jGPoint = imageMap.getImageCoord(n);
        if (jGPoint != null) {
            return imageMap.img.crop(jGPoint.x, jGPoint.y, imageMap.tilex, imageMap.tiley);
        }
        return null;
    }

    public void defineMedia(JGEngineInterface jGEngineInterface, String string) {
        int n = 1;
        int n2 = 0;
        string = this.getAbsolutePath(jGEngineInterface, string);
        try {
            String string2;
            InputStreamReader inputStreamReader;
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                jGEngineInterface.exitEngine("Cannot open `" + string + "'.");
            }
            if ((inputStreamReader = new InputStreamReader(inputStream)) == null) {
                jGEngineInterface.exitEngine("Cannot open `" + string + "'.");
            }
            while (EngineLogic.readline(inputStreamReader) != null) {
                ++n2;
            }
            if (n2 == 0) {
                jGEngineInterface.exitEngine("Cannot open `" + string + "'.");
            }
            inputStreamReader = new InputStreamReader(this.getClass().getResourceAsStream(string));
            String[] stringArray = new String[14];
            while ((string2 = EngineLogic.readline(inputStreamReader)) != null) {
                jGEngineInterface.setProgressBar((double)n / (double)n2);
                int n3 = 0;
                Vector vector = EngineLogic.tokenizeString(string2, '\t');
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    stringArray[n3++] = (String)enumeration.nextElement();
                }
                if (n3 == 8) {
                    this.defineImageMap(jGEngineInterface, stringArray[0], stringArray[1], Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]), Integer.parseInt(stringArray[5]), Integer.parseInt(stringArray[6]), Integer.parseInt(stringArray[7]));
                } else if (n3 == 9) {
                    this.defineImage(jGEngineInterface, stringArray[0], stringArray[1], Integer.parseInt(stringArray[2]), stringArray[3], stringArray[4], Integer.parseInt(stringArray[5]), Integer.parseInt(stringArray[6]), Integer.parseInt(stringArray[7]), Integer.parseInt(stringArray[8]));
                } else if (n3 == 5) {
                    this.defineImage(jGEngineInterface, stringArray[0], stringArray[1], Integer.parseInt(stringArray[2]), stringArray[3], stringArray[4], -1, -1, -1, -1);
                } else if (n3 == 10) {
                    this.defineImage(stringArray[0], stringArray[1], Integer.parseInt(stringArray[2]), this.getSubImage(stringArray[3], Integer.parseInt(stringArray[4])), stringArray[5], Integer.parseInt(stringArray[6]), Integer.parseInt(stringArray[7]), Integer.parseInt(stringArray[8]), Integer.parseInt(stringArray[9]));
                } else if (n3 == 6) {
                    this.defineImage(stringArray[0], stringArray[1], Integer.parseInt(stringArray[2]), this.getSubImage(stringArray[3], Integer.parseInt(stringArray[4])), stringArray[5], -1, -1, -1, -1);
                } else if (n3 == 3) {
                    this.defineAnimation(stringArray[0], this.splitList(stringArray[1]), Double.parseDouble(stringArray[2]));
                } else if (n3 == 4) {
                    this.defineAnimation(stringArray[0], this.splitList(stringArray[1]), Double.parseDouble(stringArray[2]), stringArray[3].equals("true"));
                } else if (n3 == 2) {
                    this.defineAudioClip(jGEngineInterface, stringArray[0], stringArray[1]);
                }
                ++n;
            }
        }
        catch (JGameError jGameError) {
            jGEngineInterface.exitEngine("Error in " + string + " line " + n + ": " + jGameError);
        }
        catch (Exception exception) {
            jGEngineInterface.exitEngine("Error in " + string + " line " + n + ":\n" + jGEngineInterface.dbgExceptionToString(exception));
        }
    }

    String[] splitList(String string) {
        Vector vector = EngineLogic.tokenizeString(string, ';');
        String[] stringArray = new String[vector.size()];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    void undefineImage(String string) {
        this.imageutil.purgeImage((String)this.images_loaded.get(string));
        this.images_orig.remove(string);
        this.image_orig_size.remove(string);
        this.images.remove(string);
        this.images_exists.remove(string);
        this.images_transp.remove(string);
        this.images_loaded.remove(string);
        this.images_bbox.remove(string);
        for (int i = this.bg_images.size() - 1; i >= 0; --i) {
            BGImage bGImage = (BGImage)this.bg_images.elementAt(i);
            if (bGImage == null || !bGImage.imgname.equals(string)) continue;
            this.bg_images.setElementAt(null, i);
        }
    }

    public void defineImage(Object object, String string, String string2, int n, String string3, String string4, int n2, int n3, int n4, int n5) {
        if (this.images_loaded.containsKey(string) && !this.images_loaded.get(string).equals(string3)) {
            this.undefineImage(string);
        }
        JGImage jGImage = null;
        if (!string3.equals("null")) {
            string3 = this.getAbsolutePath(object, string3);
            jGImage = this.imageutil.loadImage(string3);
            this.images_loaded.put(string, string3);
        }
        this.defineImage(string, string2, n, jGImage, string4, n2, n3, n4, n5);
    }

    public void defineImage(String string, String string2, int n, JGImage jGImage, String string3, int n2, int n3, int n4, int n5) {
        if (jGImage != null) {
            boolean bl;
            boolean bl2 = (string3 = string3.toLowerCase()).indexOf("x") >= 0;
            boolean bl3 = string3.indexOf("y") >= 0;
            boolean bl4 = string3.indexOf("r") >= 0;
            boolean bl5 = string3.indexOf("u") >= 0;
            boolean bl6 = bl = string3.indexOf("l") >= 0;
            if (bl2 || bl3) {
                jGImage = jGImage.flip(bl2, bl3);
            }
            if (bl4) {
                jGImage = jGImage.rotate(90);
            } else if (bl5) {
                jGImage = jGImage.rotate(180);
            } else if (bl) {
                jGImage = jGImage.rotate(270);
            }
            this.images_orig.put(string, jGImage);
            this.image_orig_size.put(string, jGImage.getSize());
        }
        this.images_exists.put(string, "yes");
        Integer n6 = new Integer(this.tileStrToID(string2));
        if (jGImage == null || !jGImage.isOpaque(this.alpha_thresh)) {
            this.images_transp.put(n6, "yes");
        }
        this.images_tile.put(n6, string);
        this.images_tilecid.put(n6, new Integer(n));
        if (n4 >= 0) {
            this.images_bbox.put(string, new JGRectangle(n2, n3, n4, n5));
        } else {
            JGPoint jGPoint = jGImage == null ? new JGPoint(0, 0) : jGImage.getSize();
            this.images_bbox.put(string, new JGRectangle(0, 0, jGPoint.x, jGPoint.y));
        }
        this.getImage(string);
        this.images_orig.remove(string);
    }

    public void defineImageRotated(Object object, String string, String string2, int n, String string3, double d) {
        String string4;
        if (this.images_loaded.containsKey(string)) {
            this.undefineImage(string);
        }
        if ((string4 = (String)this.images_loaded.get(string3)).equals("null")) {
            throw new JGameError("Source image '" + string3 + "' does not have a filename.", true);
        }
        string4 = this.getAbsolutePath(object, string4);
        JGImage jGImage = this.imageutil.loadImage(string4);
        this.defineImage(string, string2, n, jGImage.rotateAny(d), "-", 0, 0, -1, -1);
    }

    public void defineImageMap(Object object, String string, String string2, int n, int n2, int n3, int n4, int n5, int n6) {
        string2 = this.getAbsolutePath(object, string2);
        this.imagemaps.put(string, new ImageMap(this.imageutil, string2, n, n2, n3, n4, n5, n6));
    }

    public JGRectangle getImageBBox(String string) {
        return (JGRectangle)this.images_bbox.get(string);
    }

    public void defineImage(Object object, String string, String string2, int n, String string3, String string4) {
        this.defineImage(object, string, string2, n, string3, string4, -1, -1, -1, -1);
    }

    public void defineImage(String string, String string2, int n, String string3, int n2, String string4, int n3, int n4, int n5, int n6) {
        this.defineImage(string, string2, n, this.getSubImage(string3, n2), string4, n3, n4, n5, n6);
    }

    public void defineImage(String string, String string2, int n, String string3, int n2, String string4) {
        this.defineImage(string, string2, n, this.getSubImage(string3, n2), string4, 0, 0, -1, -1);
    }

    void setPendingViewOffset(int n, int n2) {
        BGImage bGImage;
        if (!this.pf_wrapx) {
            if (n < 0) {
                n = 0;
            }
            if (n > this.tilex * (this.nrtilesx - this.viewnrtilesx)) {
                n = this.tilex * (this.nrtilesx - this.viewnrtilesx);
            }
        }
        if (!this.pf_wrapy) {
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 > this.tiley * (this.nrtilesy - this.viewnrtilesy)) {
                n2 = this.tiley * (this.nrtilesy - this.viewnrtilesy);
            }
        }
        this.pendingxofs = n;
        this.pendingyofs = n2;
        if (this.bg_images.size() >= 1 && (bGImage = (BGImage)this.bg_images.elementAt(0)) != null) {
            bGImage.xofs = n;
            bGImage.yofs = n2;
        }
    }

    public void updateViewOffset() {
        if (this.pendingxofs != this.xofs || this.pendingyofs != this.yofs) {
            this.setViewOffset(this.pendingxofs, this.pendingyofs);
        }
    }

    void setViewOffset(int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (this.bg_defined == null) {
            return;
        }
        this.xofs = n;
        this.yofs = n2;
        int n6 = this.tilexofs;
        int n7 = this.tileyofs;
        this.tilexofs = this.divFloor(n, this.tilex) - 1;
        this.tileyofs = this.divFloor(n2, this.tiley) - 1;
        this.xofs_scaled = this.scaleXPos(n, false);
        this.yofs_scaled = this.scaleYPos(n2, false);
        this.calcPFWrapCenter();
        int n8 = Math.max(this.tilexofs, n6);
        int n9 = Math.max(this.tileyofs, n7);
        int n10 = Math.min(this.tilexofs, n6);
        for (n5 = n4 = Math.min(this.tileyofs, n7); n5 < n9; ++n5) {
            for (n3 = 0; n3 < this.viewnrtilesx + 3; ++n3) {
                this.bg_defined[n3][this.moduloFloor((int)n5, (int)(this.viewnrtilesy + 3))] = false;
            }
        }
        for (n5 = n10; n5 < n8; ++n5) {
            for (n3 = 0; n3 < this.viewnrtilesy + 3; ++n3) {
                this.bg_defined[this.moduloFloor((int)n5, (int)(this.viewnrtilesx + 3))][n3] = false;
            }
        }
    }

    void calcPFWrapCenter() {
        this.xofs_mid = this.xofs + this.viewnrtilesx * this.tilex / 2 + this.pf_wrapshiftx;
        this.yofs_mid = this.yofs + this.viewnrtilesy * this.tiley / 2 + this.pf_wrapshifty;
    }

    public void markAddObject(JGObject jGObject) {
        this.obj_to_add.put(jGObject.getName(), jGObject);
    }

    void addObject(JGObject jGObject) {
        int n = this.objects.get(jGObject.getName());
        if (n >= 0) {
            JGObject jGObject2 = (JGObject)this.objects.values[n];
            jGObject2.removeDone();
            jGObject2.remove();
        }
        this.objects.put(jGObject.getName(), jGObject);
    }

    void markRemoveObject(String string) {
        int n = this.objects.get(string);
        if (n < 0) {
            return;
        }
        this.obj_to_remove.put(string, (JGObject)this.objects.values[n]);
    }

    void markRemoveObject(JGObject jGObject) {
        this.obj_to_remove.put(jGObject.getName(), jGObject);
    }

    void doRemoveObject(JGObject jGObject) {
        jGObject.removeDone();
        this.objects.remove(jGObject.getName());
    }

    void markRemoveObjects(String string, int n, boolean bl) {
        this.obj_spec_to_remove.addElement(string);
        this.obj_spec_to_remove.addElement(new Integer(n));
        this.obj_spec_to_remove.addElement(new Boolean(bl));
    }

    void doRemoveObjects(String string, int n, boolean bl, boolean bl2) {
        JGObject jGObject;
        int n2;
        int n3 = this.getFirstObjectIndex(string);
        int n4 = this.getLastObjectIndex(string);
        for (n2 = n3; n2 < n4; ++n2) {
            jGObject = (JGObject)this.objects.values[n2];
            if (n != 0 && (jGObject.colid & n) == 0 || !bl && jGObject.is_suspended) continue;
            this.obj_to_remove.put(this.objects.keys[n2], jGObject);
        }
        if (bl2) {
            this.doRemoveList();
        }
        for (n2 = this.obj_to_add.size - 1; n2 >= 0; --n2) {
            jGObject = (JGObject)this.obj_to_add.values[n2];
            if (string != null && !this.obj_to_add.keys[n2].startsWith(string) || n != 0 && (jGObject.colid & n) == 0 || !bl && jGObject.is_suspended) continue;
            this.obj_to_add.remove(this.obj_to_add.keys[n2]);
        }
    }

    public void flushRemoveList() {
        if (this.obj_spec_to_remove.size() != 0) {
            Enumeration enumeration = this.obj_spec_to_remove.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                int n = (Integer)enumeration.nextElement();
                boolean bl = (Boolean)enumeration.nextElement();
                this.doRemoveObjects(string, n, bl, false);
            }
            this.obj_spec_to_remove.removeAllElements();
        }
        this.doRemoveList();
    }

    void doRemoveList() {
        for (int i = 0; i < this.obj_to_remove.size; ++i) {
            ((JGObject)this.obj_to_remove.values[i]).removeDone();
        }
        this.objects.remove(this.obj_to_remove);
        this.obj_to_remove.clear();
    }

    public void flushAddList() {
        for (int i = 0; i < this.obj_to_add.size; ++i) {
            this.addObject((JGObject)this.obj_to_add.values[i]);
        }
        this.obj_to_add.clear();
    }

    public boolean existsObject(String string) {
        return this.objects.get(string) >= 0;
    }

    public JGObject getObject(String string) {
        int n = this.objects.get(string);
        if (n < 0) {
            return null;
        }
        return (JGObject)this.objects.values[n];
    }

    public void moveObjects(JGEngineInterface jGEngineInterface, String string, int n) {
        if (this.in_parallel_upd) {
            throw new JGameError("Recursive call", true);
        }
        this.in_parallel_upd = true;
        int n2 = this.getFirstObjectIndex(string);
        int n3 = this.getLastObjectIndex(string);
        for (int i = n2; i < n3; ++i) {
            JGObject jGObject = (JGObject)this.objects.values[i];
            if (n != 0 && (jGObject.colid & n) == 0) continue;
            if (jGObject.is_suspended) {
                if (jGObject.resume_in_view && jGObject.isInView(this.offscreen_margin_x, this.offscreen_margin_y)) {
                    jGObject.resume();
                }
            } else if (!(jGObject.expiry != -4.0 && jGObject.expiry != -5.0 || jGObject.isInView(this.offscreen_margin_x, this.offscreen_margin_y))) {
                jGObject.suspend();
            }
            if (this.pf_wrapx) {
                jGObject.x = this.moduloXPos(jGObject.x);
            }
            if (this.pf_wrapy) {
                jGObject.y = this.moduloYPos(jGObject.y);
            }
            if (!jGObject.is_suspended) {
                if (this.pf_wrapx) {
                    jGObject.x = this.moduloXPos(jGObject.x);
                }
                if (this.pf_wrapy) {
                    jGObject.y = this.moduloYPos(jGObject.y);
                }
                try {
                    jGObject.move();
                }
                catch (JGameError jGameError) {
                    jGEngineInterface.exitEngine(jGEngineInterface.dbgExceptionToString(jGameError));
                }
                catch (Exception exception) {
                    jGEngineInterface.dbgShowException(jGObject.getName(), exception);
                }
                jGObject.updateAnimation(this.gamespeed);
                jGObject.x += (double)jGObject.xdir * jGObject.xspeed * this.gamespeed;
                jGObject.y += (double)jGObject.ydir * jGObject.yspeed * this.gamespeed;
                if (this.pf_wrapx) {
                    jGObject.x = this.moduloXPos(jGObject.x);
                }
                if (this.pf_wrapy) {
                    jGObject.y = this.moduloYPos(jGObject.y);
                }
            }
            if (jGObject.is_suspended) continue;
            int n4 = (int)jGObject.expiry;
            if (n4 >= 0) {
                jGObject.expiry -= this.gamespeed;
                if (!(jGObject.expiry < 0.0)) continue;
                jGObject.remove();
                continue;
            }
            if (!(n4 != -2 && n4 != -5 || jGObject.isOnPF(this.offscreen_margin_x, this.offscreen_margin_y))) {
                jGObject.remove();
            }
            if (n4 != -3 || jGObject.isInView(this.offscreen_margin_x, this.offscreen_margin_y)) continue;
            jGObject.remove();
        }
        this.flushRemoveList();
        this.in_parallel_upd = false;
    }

    public void moveObjects(JGEngineInterface jGEngineInterface) {
        this.moveObjects(jGEngineInterface, null, 0);
    }

    public void checkCollision(JGEngineInterface jGEngineInterface, int n, int n2) {
        JGObject jGObject;
        int n3;
        if (this.in_parallel_upd) {
            throw new JGameError("Recursive call", true);
        }
        this.in_parallel_upd = true;
        if (this.objects.size > this.srcobj.length) {
            this.srcobj = new JGObject[this.objects.size + 50];
            this.dstobj = new JGObject[this.objects.size + 50];
        }
        int n4 = 0;
        int n5 = 0;
        JGRectangle jGRectangle = this.tmprect1;
        JGRectangle jGRectangle2 = this.tmprect2;
        for (n3 = 0; n3 < this.objects.size; ++n3) {
            jGObject = (JGObject)this.objects.values[n3];
            if (jGObject.is_suspended || !jGObject.getBBox(jGRectangle)) continue;
            if ((jGObject.colid & n) != 0) {
                this.srcobj[n4++] = jGObject;
            }
            if ((jGObject.colid & n2) == 0) continue;
            this.dstobj[n5++] = jGObject;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            jGObject = this.srcobj[n3];
            if (!jGObject.getBBox(jGRectangle)) continue;
            for (int i = 0; i < n5; ++i) {
                JGObject jGObject2 = this.dstobj[i];
                if (jGObject2 == jGObject || !jGObject2.getBBox(jGRectangle2) || !jGRectangle.intersects(jGRectangle2)) continue;
                try {
                    jGObject2.hit(jGObject);
                    continue;
                }
                catch (JGameError jGameError) {
                    jGEngineInterface.exitEngine(jGEngineInterface.dbgExceptionToString(jGameError));
                    continue;
                }
                catch (Exception exception) {
                    jGEngineInterface.dbgShowException(jGObject2.getName(), exception);
                }
            }
        }
        this.flushRemoveList();
        this.in_parallel_upd = false;
    }

    public int checkCollision(int n, JGObject jGObject) {
        JGRectangle jGRectangle = jGObject.getBBox();
        if (jGRectangle == null) {
            return 0;
        }
        int n2 = 0;
        JGRectangle jGRectangle2 = this.tmprect1;
        for (int i = 0; i < this.objects.size; ++i) {
            JGObject jGObject2 = (JGObject)this.objects.values[i];
            if (jGObject2 == jGObject || jGObject2.is_suspended || n != 0 && (jGObject2.colid & n) == 0 || !jGObject2.getBBox(jGRectangle2) || !jGRectangle.intersects(jGRectangle2)) continue;
            n2 |= jGObject2.colid;
        }
        return n2;
    }

    public int checkBGCollision(JGRectangle jGRectangle) {
        return this.getTileCid(this.getTiles(jGRectangle));
    }

    public void checkBGCollision(JGEngineInterface jGEngineInterface, int n, int n2) {
        if (this.in_parallel_upd) {
            throw new JGameError("Recursive call", true);
        }
        this.in_parallel_upd = true;
        if (this.objects.size > this.srcobj.length) {
            this.srcobj = new JGObject[this.objects.size + 50];
        }
        int n3 = 0;
        JGRectangle jGRectangle = this.tmprect1;
        for (int i = 0; i < this.objects.size; ++i) {
            JGObject jGObject = (JGObject)this.objects.values[i];
            if (jGObject.is_suspended || !jGObject.getTileBBox(jGRectangle) || (jGObject.colid & n2) == 0) continue;
            this.srcobj[n3++] = jGObject;
        }
        JGRectangle jGRectangle2 = this.tmprect2;
        for (int i = 0; i < n3; ++i) {
            JGObject jGObject = this.srcobj[i];
            jGObject.getTileBBox(jGRectangle);
            this.getTiles(jGRectangle2, jGRectangle);
            int n4 = this.getTileCid(jGRectangle2);
            if ((n4 & n) == 0) continue;
            try {
                jGObject.hit_bg(n4);
                jGObject.hit_bg(n4, jGRectangle2.x, jGRectangle2.y, jGRectangle2.width, jGRectangle2.height);
                for (int j = 0; j < jGRectangle2.height; ++j) {
                    for (int k = 0; k < jGRectangle2.width; ++k) {
                        int n5 = this.getTileCid(jGRectangle2.x + k, jGRectangle2.y + j);
                        if ((n5 & n) == 0) continue;
                        jGObject.hit_bg(n5, jGRectangle2.x + k, jGRectangle2.y + j);
                    }
                }
                continue;
            }
            catch (JGameError jGameError) {
                jGEngineInterface.exitEngine(jGEngineInterface.dbgExceptionToString(jGameError));
                continue;
            }
            catch (Exception exception) {
                jGEngineInterface.dbgShowException(jGObject.getName(), exception);
            }
        }
        this.flushRemoveList();
        this.in_parallel_upd = false;
    }

    public Vector getObjects(String string, int n, boolean bl, JGRectangle jGRectangle) {
        Vector<JGObject> vector = new Vector<JGObject>(50, 100);
        boolean bl2 = false;
        JGRectangle jGRectangle2 = this.tmprect1;
        int n2 = this.getFirstObjectIndex(string);
        int n3 = this.getLastObjectIndex(string);
        for (int i = n2; i < n3; ++i) {
            JGObject jGObject = (JGObject)this.objects.values[i];
            if (n != 0 && (jGObject.colid & n) == 0 || !bl && jGObject.is_suspended) continue;
            if (jGRectangle != null) {
                if (!jGObject.getBBox(jGRectangle2) || !jGRectangle.intersects(jGRectangle2)) continue;
                vector.addElement(jGObject);
                continue;
            }
            vector.addElement(jGObject);
        }
        return vector;
    }

    public void removeObject(JGObject jGObject) {
        if (this.in_parallel_upd) {
            this.markRemoveObject(jGObject);
        } else {
            this.doRemoveObject(jGObject);
        }
    }

    public void removeObjects(String string, int n) {
        this.removeObjects(string, n, true);
    }

    public void removeObjects(String string, int n, boolean bl) {
        if (this.in_parallel_upd) {
            this.markRemoveObjects(string, n, bl);
        } else {
            this.doRemoveObjects(string, n, bl, true);
        }
    }

    public int countObjects(String string, int n) {
        return this.countObjects(string, n, true);
    }

    public int countObjects(String string, int n, boolean bl) {
        int n2 = 0;
        int n3 = this.getFirstObjectIndex(string);
        int n4 = this.getLastObjectIndex(string);
        for (int i = n3; i < n4; ++i) {
            JGObject jGObject = (JGObject)this.objects.values[i];
            if (n != 0 && (jGObject.colid & n) == 0 || !bl && jGObject.is_suspended) continue;
            ++n2;
        }
        return n2;
    }

    int getFirstObjectIndex(String string) {
        if (string == null) {
            return 0;
        }
        int n = this.objects.get(string);
        if (n < 0) {
            n = -1 - n;
        }
        return n;
    }

    int getLastObjectIndex(String string) {
        if (string == null) {
            return this.objects.size;
        }
        return -1 - this.objects.get(string + '\uffff');
    }

    public void frameFinished() {
        for (int i = 0; i < this.objects.size; ++i) {
            ((JGObject)this.objects.values[i]).frameFinished();
        }
    }

    public void repaintBG(JGEngineInterface jGEngineInterface) {
        if (this.bg_defined == null) {
            return;
        }
        int n = 0;
        int n2 = (this.viewnrtilesx + this.viewnrtilesy) / 5;
        for (int i = 0; i < this.viewnrtilesx + 3; ++i) {
            int n3 = i + this.tilexofs;
            if (!this.pf_wrapx && (n3 < 0 || n3 >= this.nrtilesx)) continue;
            int n4 = this.moduloFloor(n3, this.viewnrtilesx + 3);
            int n5 = n3;
            if (this.pf_wrapx) {
                n5 = this.moduloFloor(n3, this.nrtilesx);
            }
            int n6 = this.tileyofs;
            int n7 = this.tileyofs + this.viewnrtilesy + 3;
            if (!this.pf_wrapy) {
                if (n7 < 0) continue;
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n6 > this.nrtilesy) continue;
                if (n7 > this.nrtilesy) {
                    n7 = this.nrtilesy;
                }
            }
            int n8 = this.viewnrtilesy + 3;
            for (int j = n6; j < n7; ++j) {
                int n9;
                int n10 = n9 = j >= 0 ? j % n8 : n8 - 1 - (-1 - j) % n8;
                if (this.bg_defined[n4][n9]) continue;
                int n11 = j;
                if (this.pf_wrapy) {
                    n11 = this.moduloFloor(j, this.nrtilesy);
                }
                int n12 = j - this.tileyofs;
                if ((i == 0 || n12 == 0 || i == this.viewnrtilesx + 2 || n12 == this.viewnrtilesy + 2) && n > n2) continue;
                jGEngineInterface.drawTile(n3, j, this.tilemap[n5][n11]);
                ++n;
                this.bg_defined[n4][n9] = true;
            }
        }
    }

    public void setBGImage(String string, int n, boolean bl, boolean bl2) {
        while (this.bg_images.size() < n + 1) {
            this.bg_images.addElement(null);
        }
        if (string != null) {
            if (!this.images.containsKey(string)) {
                throw new JGameError("unknown BG image " + string);
            }
            BGImage bGImage = new BGImage(string, bl, bl2);
            this.bg_images.setElementAt(bGImage, n);
            if (n == 0) {
                bGImage.xofs = this.xofs;
                bGImage.yofs = this.yofs;
            }
        } else {
            this.bg_images.setElementAt(null, n);
        }
        this.invalidateBGTiles();
    }

    public void initBGTiles(int n, int n2, String string) {
        this.nrtilesx = n;
        this.nrtilesy = n2;
        this.pfwidth = n * this.tilex;
        this.pfheight = n2 * this.tiley;
        this.pfwidth_half = this.pfwidth / 2;
        this.pfheight_half = this.pfheight / 2;
        this.tilemap = new int[n][n2];
        this.tilecidmap = new int[n][n2];
        this.bg_defined = new boolean[this.viewnrtilesx + 3][this.viewnrtilesy + 3];
        this.fillBG(string);
        this.setViewOffset(0, 0);
    }

    public void invalidateBGTiles() {
        if (this.bg_defined == null) {
            return;
        }
        for (int i = 0; i < this.viewnrtilesx + 3; ++i) {
            for (int j = 0; j < this.viewnrtilesy + 3; ++j) {
                this.bg_defined[i][j] = false;
            }
        }
    }

    public void setTileSettings(String string, int n, int n2) {
        this.out_of_bounds_tile = string;
        this.out_of_bounds_cid = n;
        this.preserve_cids = n2;
    }

    public void fillBG(String string) {
        for (int i = 0; i < this.nrtilesy; ++i) {
            for (int j = 0; j < this.nrtilesx; ++j) {
                this.setTile(j, i, string);
            }
        }
    }

    public void setTileCid(int n, int n2, int n3, int n4) {
        if (this.pf_wrapx) {
            n = this.moduloFloor(n, this.nrtilesx);
        } else if (n < 0 || n >= this.nrtilesx) {
            return;
        }
        if (this.pf_wrapy) {
            n2 = this.moduloFloor(n2, this.nrtilesy);
        } else if (n2 < 0 || n2 >= this.nrtilesy) {
            return;
        }
        int[] nArray = this.tilecidmap[n];
        int n5 = n2;
        nArray[n5] = nArray[n5] & n3;
        int[] nArray2 = this.tilecidmap[n];
        int n6 = n2;
        nArray2[n6] = nArray2[n6] | n4;
    }

    public void setTile(int n, int n2, String string) {
        int n3;
        int n4;
        int n5 = n;
        int n6 = n2;
        if (this.pf_wrapx) {
            n5 = this.moduloFloor(n, this.nrtilesx);
        } else if (n < 0 || n >= this.nrtilesx) {
            return;
        }
        if (this.pf_wrapy) {
            n6 = this.moduloFloor(n2, this.nrtilesy);
        } else if (n2 < 0 || n2 >= this.nrtilesy) {
            return;
        }
        this.tilemap[n5][n6] = n4 = this.tileStrToID(string);
        int[] nArray = this.tilecidmap[n5];
        int n7 = n6;
        nArray[n7] = nArray[n7] & this.preserve_cids;
        int[] nArray2 = this.tilecidmap[n5];
        int n8 = n6;
        nArray2[n8] = nArray2[n8] | this.tileintToCid(n4);
        if (!(this.pf_wrapx || n5 >= this.tilexofs && n5 < this.tilexofs + this.viewnrtilesx + 3)) {
            return;
        }
        if (!(this.pf_wrapy || n6 >= this.tileyofs && n6 < this.tileyofs + this.viewnrtilesy + 3)) {
            return;
        }
        int n9 = n >= 0 ? n % (this.viewnrtilesx + 3) : this.viewnrtilesx + 2 - (-1 - n) % (this.viewnrtilesx + 3);
        int n10 = n3 = n2 >= 0 ? n2 % (this.viewnrtilesy + 3) : this.viewnrtilesy + 2 - (-1 - n2) % (this.viewnrtilesy + 3);
        if (n9 >= this.nrtilesx) {
            n9 -= this.nrtilesx;
        }
        if (n3 >= this.nrtilesy) {
            n3 -= this.nrtilesy;
        }
        this.bg_defined[n9][n3] = false;
        boolean bl = false;
        if (this.pf_wrapx && this.viewnrtilesx + 3 - this.nrtilesx > n9) {
            this.bg_defined[n9 + this.nrtilesx][n3] = false;
            if (this.pf_wrapy && this.viewnrtilesy + 3 - this.nrtilesy > n3) {
                this.bg_defined[n9 + this.nrtilesx][n3 + this.nrtilesy] = false;
                bl = true;
            }
        }
        if (bl) {
            this.bg_defined[n9][n3 + this.nrtilesy] = false;
        }
    }

    public int countTiles(int n) {
        int n2 = 0;
        for (int i = 0; i < this.nrtilesx; ++i) {
            for (int j = 0; j < this.nrtilesy; ++j) {
                if ((this.tilecidmap[i][j] & n) == 0) continue;
                ++n2;
            }
        }
        return n2;
    }

    public int getTileCid(int n, int n2) {
        if (this.pf_wrapx) {
            n = this.moduloFloor(n, this.nrtilesx);
        } else if (n < 0 || n >= this.nrtilesx) {
            return this.out_of_bounds_cid;
        }
        if (this.pf_wrapy) {
            n2 = this.moduloFloor(n2, this.nrtilesy);
        } else if (n2 < 0 || n2 >= this.nrtilesy) {
            return this.out_of_bounds_cid;
        }
        return this.tilecidmap[n][n2];
    }

    public String getTileStr(int n, int n2) {
        if (this.pf_wrapx) {
            n = this.moduloFloor(n, this.nrtilesx);
        } else if (n < 0 || n >= this.nrtilesx) {
            return this.out_of_bounds_tile;
        }
        if (this.pf_wrapy) {
            n2 = this.moduloFloor(n2, this.nrtilesy);
        } else if (n2 < 0 || n2 >= this.nrtilesy) {
            return this.out_of_bounds_tile;
        }
        return this.tileIDToStr(this.tilemap[n][n2]);
    }

    public int getTileCid(JGRectangle jGRectangle) {
        int n = 0;
        for (int i = jGRectangle.x; i < jGRectangle.x + jGRectangle.width; ++i) {
            for (int j = jGRectangle.y; j < jGRectangle.y + jGRectangle.height; ++j) {
                n |= this.getTileCid(i, j);
            }
        }
        return n;
    }

    private int tilestrToCid(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        Integer n = (Integer)this.images_tilecid.get(new Integer(this.tileStrToID(string)));
        if (n == null) {
            System.out.println("Warning: unknown tile '" + string + "'.");
            return 0;
        }
        return n;
    }

    private int tileintToCid(int n) {
        if (n == 0) {
            return 0;
        }
        Integer n2 = (Integer)this.images_tilecid.get(new Integer(n));
        if (n2 == null) {
            System.out.println("Warning: unknown tile '" + n + "'.");
            return 0;
        }
        return n2;
    }

    public int tileStrToID(String string) {
        if (string == null) {
            return 0;
        }
        switch (string.length()) {
            case 0: {
                return 0;
            }
            case 1: {
                return string.charAt(0);
            }
            case 2: {
                return string.charAt(0) + string.charAt(1) * 256;
            }
            case 3: {
                return string.charAt(0) + string.charAt(1) * 256 + string.charAt(2) * 256 * 256;
            }
            case 4: {
                return string.charAt(0) + string.charAt(1) * 256 + string.charAt(2) * 256 * 256 + string.charAt(3) * 256 * 256 * 256;
            }
        }
        System.out.println("Warning: string '" + string + " has wrong size.");
        return 0;
    }

    public String tileIDToStr(int n) {
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("" + (char)(n & 0xFF));
        if (n >= 256) {
            stringBuffer.append((char)(n / 256 & 0xFF));
        }
        if (n >= 65536) {
            stringBuffer.append((char)(n / 65536 & 0xFF));
        }
        if (n >= 0x1000000) {
            stringBuffer.append((char)(n / 0x1000000 & 0xFF));
        }
        return stringBuffer.toString();
    }

    public boolean getTiles(JGRectangle jGRectangle, JGRectangle jGRectangle2) {
        if (jGRectangle2 == null) {
            return false;
        }
        jGRectangle.copyFrom(jGRectangle2);
        this.convertToTiles(jGRectangle, jGRectangle2);
        return true;
    }

    void convertToTiles(JGRectangle jGRectangle, JGRectangle jGRectangle2) {
        if (jGRectangle.x >= 0) {
            jGRectangle.x /= this.tilex;
            jGRectangle.width = 1 - jGRectangle.x + (jGRectangle2.x + jGRectangle2.width - 1) / this.tilex;
        } else {
            jGRectangle.x = (jGRectangle.x - this.tilex + 1) / this.tilex;
            jGRectangle.width = 1 - jGRectangle.x + (jGRectangle2.x + jGRectangle2.width - 1 - this.tilex + 1) / this.tilex;
        }
        if (jGRectangle.y >= 0) {
            jGRectangle.y /= this.tiley;
            jGRectangle.height = 1 - jGRectangle.y + (jGRectangle2.y + jGRectangle2.height - 1) / this.tiley;
        } else {
            jGRectangle.y = (jGRectangle.y - this.tiley + 1) / this.tiley;
            jGRectangle.height = 1 - jGRectangle.y + (jGRectangle2.y + jGRectangle2.height - 1 - this.tilex + 1) / this.tiley;
        }
    }

    public JGRectangle getTiles(JGRectangle jGRectangle) {
        if (jGRectangle == null) {
            return null;
        }
        JGRectangle jGRectangle2 = new JGRectangle(jGRectangle);
        this.convertToTiles(jGRectangle2, jGRectangle);
        return jGRectangle2;
    }

    public void setTileCid(int n, int n2, int n3) {
        this.setTileCid(n, n2, 0, n3);
    }

    public void orTileCid(int n, int n2, int n3) {
        this.setTileCid(n, n2, -1, n3);
    }

    public void andTileCid(int n, int n2, int n3) {
        this.setTileCid(n, n2, n3, 0);
    }

    public void setTile(JGPoint jGPoint, String string) {
        this.setTile(jGPoint.x, jGPoint.y, string);
    }

    public void setTiles(int n, int n2, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length(); ++j) {
                this.setTile(j + n, i + n2, new String(stringArray[i].substring(j, j + 1)));
            }
        }
    }

    public void setTilesMulti(int n, int n2, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            Vector vector = EngineLogic.tokenizeString(stringArray[i], ' ');
            int n3 = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.setTile(n3 + n, i + n2, (String)enumeration.nextElement());
                ++n3;
            }
        }
    }

    public int getTileCidAtCoord(double d, double d2) {
        int n = (int)d / this.tilex;
        int n2 = (int)d2 / this.tiley;
        return this.getTileCid(n, n2);
    }

    public int getTileCid(JGPoint jGPoint, int n, int n2) {
        return this.getTileCid(jGPoint.x + n, jGPoint.y + n2);
    }

    public String getTileStrAtCoord(double d, double d2) {
        int n = (int)d / this.tilex;
        int n2 = (int)d2 / this.tiley;
        return this.getTileStr(n, n2);
    }

    public String getTileStr(JGPoint jGPoint, int n, int n2) {
        return this.getTileStr(jGPoint.x + n, jGPoint.y + n2);
    }

    public void drawImageString(JGEngineInterface jGEngineInterface, String string, double d, double d2, int n, String string2, int n2, int n3, boolean bl) {
        ImageMap imageMap = (ImageMap)this.imagemaps.get(string2);
        if (imageMap == null) {
            throw new JGameError("Font image map '" + string2 + "' not found.", true);
        }
        if (n == 0) {
            d -= (double)((imageMap.tilex + n3) * string.length() / 2);
        } else if (n == 1) {
            d -= (double)((imageMap.tilex + n3) * string.length());
        }
        StringBuffer stringBuffer = new StringBuffer(string2 + "# ");
        int n4 = stringBuffer.length() - 1;
        String string3 = null;
        for (int i = 0; i < string.length(); ++i) {
            int n5 = -n2 + string.charAt(i);
            stringBuffer.setCharAt(n4, string.charAt(i));
            string3 = stringBuffer.toString();
            if (!this.existsImage(string3)) {
                this.defineImage(string3, "FONT", 0, this.getSubImage(string2, n5), "-", 0, 0, 0, 0);
            }
            JGImage jGImage = this.getImage(string3);
            jGEngineInterface.drawImage(d, d2, string3, bl);
            d += (double)(imageMap.tilex + n3);
        }
    }

    public double moduloXPos(double d) {
        while (d - (double)this.xofs_mid > (double)this.pfwidth_half) {
            d -= (double)(this.pfwidth_half * 2);
        }
        while (d - (double)this.xofs_mid < (double)(-this.pfwidth_half)) {
            d += (double)(this.pfwidth_half * 2);
        }
        return d;
    }

    public double moduloYPos(double d) {
        while (d - (double)this.yofs_mid > (double)this.pfheight_half) {
            d -= (double)(this.pfheight_half * 2);
        }
        while (d - (double)this.yofs_mid < (double)(-this.pfheight_half)) {
            d += (double)(this.pfheight_half * 2);
        }
        return d;
    }

    public int divFloor(int n, int n2) {
        return (int)Math.floor((double)n / (double)n2);
    }

    public double moduloFloor(double d, int n) {
        return d - (double)n * Math.floor(d / (double)n);
    }

    public int moduloFloor(int n, int n2) {
        if (n >= 0) {
            return n % n2;
        }
        return n2 - 1 - (-1 - n) % n2;
    }

    public int scaleXPos(double d, boolean bl) {
        if (!bl) {
            return (int)Math.floor(this.x_scale_fac * d);
        }
        if (this.pf_wrapx) {
            d = this.moduloXPos(d);
        }
        return (int)Math.floor(this.x_scale_fac * d) - this.xofs_scaled;
    }

    public int scaleYPos(double d, boolean bl) {
        if (!bl) {
            return (int)Math.floor(this.y_scale_fac * d);
        }
        if (this.pf_wrapy) {
            d = this.moduloYPos(d);
        }
        return (int)Math.floor(this.y_scale_fac * d) - this.yofs_scaled;
    }

    public JGPoint scalePos(double d, double d2, boolean bl) {
        return new JGPoint(this.scaleXPos(d, bl), this.scaleYPos(d2, bl));
    }

    public JGRectangle scalePos(double d, double d2, double d3, double d4, boolean bl) {
        JGPoint jGPoint = this.scalePos(d, d2, bl);
        JGPoint jGPoint2 = this.scalePos(d + d3, d2 + d4, bl);
        if (jGPoint2.x < jGPoint.x) {
            jGPoint2.x = jGPoint.x + this.scaleXPos(d3, bl);
        }
        if (jGPoint2.y < jGPoint.y) {
            jGPoint2.y = jGPoint.y + this.scaleYPos(d4, bl);
        }
        return new JGRectangle(jGPoint.x, jGPoint.y, jGPoint2.x - jGPoint.x - 1, jGPoint2.y - jGPoint.y - 1);
    }

    public JGRectangle scalePos(JGRectangle jGRectangle, boolean bl) {
        if (jGRectangle == null) {
            return null;
        }
        return this.scalePos(jGRectangle.x, jGRectangle.y, jGRectangle.width, jGRectangle.height, bl);
    }

    public void initPF() {
        int n = this.winwidth + this.crop_left + this.crop_right;
        int n2 = this.winheight + this.crop_top + this.crop_bottom;
        this.viewnrtilesx = this.nrtilesx;
        this.viewnrtilesy = this.nrtilesy;
        if (this.prescale) {
            this.scaledtilex = n / this.nrtilesx;
            this.scaledtiley = n2 / this.nrtilesy;
            double d = (double)this.scaledtilex / (double)this.scaledtiley / ((double)this.tilex / (double)this.tiley);
            if (d < this.min_aspect) {
                this.scaledtiley = (int)((double)this.scaledtilex / this.min_aspect);
            } else if (d > this.max_aspect) {
                this.scaledtilex = (int)(this.max_aspect * (double)this.scaledtiley);
            }
            this.width = this.scaledtilex * this.nrtilesx;
            this.height = this.scaledtiley * this.nrtilesy;
        } else {
            this.scaledtilex = this.tilex;
            this.scaledtiley = this.tiley;
            this.width = this.winwidth;
            this.height = this.winheight;
        }
        this.x_scale_fac = (double)this.width / (double)(this.tilex * this.nrtilesx);
        this.y_scale_fac = (double)this.height / (double)(this.tiley * this.nrtilesy);
        this.min_scale_fac = Math.min(this.x_scale_fac, this.y_scale_fac);
        this.initBGTiles(this.nrtilesx, this.nrtilesy, "");
        if (this.prescale) {
            int n3 = this.width - this.winwidth;
            int n4 = this.height - this.winheight;
            double d = 0.0;
            double d2 = 0.0;
            if (this.crop_left + this.crop_right > 0 && n3 > 0) {
                d = (this.crop_right - this.crop_left) / (this.crop_left + this.crop_right);
            }
            if (this.crop_top + this.crop_bottom > 0 && n4 > 0) {
                d2 = (this.crop_bottom - this.crop_top) / (this.crop_top + this.crop_bottom);
            }
            this.canvas_xofs = (int)((double)(-n3) * (0.5 - 0.5 * d));
            this.canvas_yofs = (int)((double)(-n4) * (0.5 - 0.5 * d2));
        }
    }

    public void setViewOffset(int n, int n2, boolean bl) {
        if (bl) {
            n -= this.viewWidth() / 2;
            n2 -= this.viewHeight() / 2;
        }
        this.setPendingViewOffset(n, n2);
        JGObject.updateEngineSettings();
    }

    public void setBGImgOffset(int n, double d, double d2, boolean bl) {
        if (bl) {
            d -= (double)(this.viewWidth() / 2);
            d2 -= (double)(this.viewHeight() / 2);
        }
        if (this.bg_images.size() < n) {
            throw new JGameError("Parallax depth " + n + " not defined.");
        }
        BGImage bGImage = (BGImage)this.bg_images.elementAt(n);
        bGImage.xofs = d;
        bGImage.yofs = d2;
    }

    public void setPFSize(int n, int n2) {
        this.initBGTiles(n, n2, "");
        JGObject.updateEngineSettings();
    }

    public void setPFWrap(boolean bl, boolean bl2, int n, int n2) {
        this.pf_wrapx = bl;
        this.pf_wrapy = bl2;
        this.pf_wrapshiftx = n;
        this.pf_wrapshifty = n2;
        this.setViewOffset(this.pendingxofs, this.pendingyofs, false);
        this.calcPFWrapCenter();
        JGObject.updateEngineSettings();
    }

    public void setFrameRate(double d, double d2) {
        this.fps = d;
        this.maxframeskip = d2;
    }

    public void setRenderSettings(int n, JGColor jGColor) {
        this.alpha_thresh = n;
        this.render_bg_color = jGColor;
    }

    public void setOffscreenMargin(int n, int n2) {
        this.offscreen_margin_x = n;
        this.offscreen_margin_y = n2;
    }

    public void setGameSpeed(double d) {
        this.gamespeed = d + 1.0E-11;
        JGObject.updateEngineSettings();
    }

    public void removeAllTimers() {
        this.timers.removeAllElements();
    }

    public void registerTimer(JGTimer jGTimer) {
        this.timers.addElement(jGTimer);
    }

    public void tickTimers() {
        for (int i = this.timers.size() - 1; i >= 0; --i) {
            JGTimer jGTimer = (JGTimer)this.timers.elementAt(i);
            if (!jGTimer.tick(this.gamespeed)) continue;
            this.timers.removeElement(jGTimer);
        }
    }

    public void setGameState(String string) {
        boolean bl = this.inGameStateNextFrame(string);
        this.gamestate_nextframe.removeAllElements();
        this.gamestate_nextframe.addElement(string);
        this.gamestate_new.removeAllElements();
        if (!bl) {
            this.gamestate_new.addElement(string);
        }
    }

    public void addGameState(String string) {
        if (!this.inGameStateNextFrame(string)) {
            this.gamestate_nextframe.addElement(string);
            this.gamestate_new.addElement(string);
        }
    }

    public void removeGameState(String string) {
        this.gamestate_nextframe.removeElement(string);
        this.gamestate_new.removeElement(string);
    }

    public void clearGameState() {
        this.gamestate_nextframe.removeAllElements();
    }

    public boolean inGameState(String string) {
        for (int i = this.gamestate.size() - 1; i >= 0; --i) {
            if (!((String)this.gamestate.elementAt(i)).equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean inGameStateNextFrame(String string) {
        for (int i = this.gamestate_nextframe.size() - 1; i >= 0; --i) {
            if (!((String)this.gamestate_nextframe.elementAt(i)).equals(string)) continue;
            return true;
        }
        return false;
    }

    public void defineAnimation(String string, String[] stringArray, double d) {
        this.animations.put(string, new Animation(stringArray, d));
    }

    public void defineAnimation(String string, String[] stringArray, double d, boolean bl) {
        this.animations.put(string, new Animation(stringArray, d, bl));
    }

    public Animation getAnimation(String string) {
        return (Animation)this.animations.get(string);
    }

    public boolean and(int n, int n2) {
        return (n & n2) != 0;
    }

    public double random(double d, double d2) {
        return d + this.random.nextDouble() * (d2 - d);
    }

    public double random(double d, double d2, double d3) {
        int n = (int)Math.floor(1.0E-5 + (d2 - d) / d3);
        return d + (double)((int)(this.random.nextDouble() * ((double)n + 0.99))) * d3;
    }

    public int random(int n, int n2, int n3) {
        int n4 = (n2 - n) / n3;
        return n + (int)(this.random.nextDouble() * ((double)n4 + 0.99)) * n3;
    }

    public JGPoint getTileIndex(double d, double d2) {
        return new JGPoint((int)Math.floor(d / (double)this.tilex), (int)Math.floor(d2 / (double)this.tiley));
    }

    public JGPoint getTileCoord(int n, int n2) {
        return new JGPoint(n * this.tileWidth(), n2 * this.tileHeight());
    }

    public JGPoint getTileCoord(JGPoint jGPoint) {
        return new JGPoint(jGPoint.x * this.tileWidth(), jGPoint.y * this.tileHeight());
    }

    public double snapToGridX(double d, double d2) {
        if (d2 <= 0.0) {
            return d;
        }
        int n = this.tilex * (int)Math.floor((d + (double)this.tilex / 2.0) / (double)this.tilex);
        double d3 = Math.abs(d - (double)n);
        if (d3 <= d2 + 2.0E-4) {
            return n;
        }
        return d;
    }

    public double snapToGridY(double d, double d2) {
        if (d2 <= 0.0) {
            return d;
        }
        int n = this.tiley * (int)Math.floor((d + (double)this.tiley / 2.0) / (double)this.tiley);
        double d3 = Math.abs(d - (double)n);
        if (d3 <= d2 + 2.0E-4) {
            return n;
        }
        return d;
    }

    public void snapToGrid(JGPoint jGPoint, int n, int n2) {
        if (n == 0 && n2 == 0) {
            return;
        }
        int n3 = this.tilex * (int)Math.floor(((double)jGPoint.x + (double)this.tilex / 2.0) / (double)this.tilex);
        int n4 = this.tiley * (int)Math.floor(((double)jGPoint.y + (double)this.tiley / 2.0) / (double)this.tiley);
        int n5 = Math.abs(jGPoint.x - n3);
        int n6 = Math.abs(jGPoint.y - n4);
        if (n5 <= n) {
            jGPoint.x = n3;
        }
        if (n6 <= n2) {
            jGPoint.y = n4;
        }
    }

    public boolean isXAligned(double d, double d2) {
        int n;
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        return Math.abs(d - (double)(n = this.tilex * (((int)d + this.tilex / 2) / this.tilex))) <= d2 + 5.0E-5;
    }

    public boolean isYAligned(double d, double d2) {
        int n;
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        return Math.abs(d - (double)(n = this.tiley * (((int)d + this.tiley / 2) / this.tiley))) <= d2 + 5.0E-5;
    }

    public double getXAlignOfs(double d) {
        int n = this.tilex * (((int)d + this.tilex / 2) / this.tilex);
        return d - (double)n;
    }

    public double getYAlignOfs(double d) {
        int n = this.tiley * (((int)d + this.tiley / 2) / this.tiley);
        return d - (double)n;
    }

    public double getXDist(double d, double d2) {
        if (this.pf_wrapx) {
            double d3 = this.moduloFloor(d, this.pfwidth);
            double d4 = this.moduloFloor(d2, this.pfwidth);
            return Math.min(Math.abs(d3 - d4), Math.abs(d3 + (double)this.pfwidth - d4));
        }
        return Math.abs(d - d2);
    }

    public double getYDist(double d, double d2) {
        if (this.pf_wrapy) {
            int n = this.pfheight_half * 2;
            double d3 = this.moduloFloor(d, n);
            double d4 = this.moduloFloor(d2, n);
            return Math.min(Math.abs(d3 - d4), Math.abs(d3 + (double)n - d4));
        }
        return Math.abs(d - d2);
    }

    public void defineAudioClip(Object object, String string, String string2) {
        string2 = this.getAbsolutePath(object, string2);
        this.audioclips.put(string, string2);
    }

    public class BGImage {
        public String imgname;
        public boolean wrapx;
        public boolean wrapy;
        public JGPoint tiles;
        public double xofs = 0.0;
        public double yofs = 0.0;

        public BGImage(String string, boolean bl, boolean bl2) {
            this.imgname = string;
            this.wrapx = bl;
            this.wrapy = bl2;
            this.tiles = new JGPoint((JGPoint)EngineLogic.this.image_orig_size.get(string));
            this.tiles.x /= EngineLogic.this.tilex;
            this.tiles.y /= EngineLogic.this.tiley;
        }
    }
}

