/*
 * Decompiled with CFR 0.152.
 */
package tutorial;

import jgame.JGColor;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.platform.JGEngine;

public class Example4
extends JGEngine {
    public static void main(String[] stringArray) {
        new Example4(new JGPoint(640, 480));
    }

    public Example4(JGPoint jGPoint) {
        this.initEngine(jGPoint.x, jGPoint.y);
    }

    public Example4() {
        this.initEngineApplet();
    }

    public void initCanvas() {
        this.setCanvasSettings(20, 15, 16, 16, JGColor.black, new JGColor(255, 246, 199), null);
    }

    public void initGame() {
        this.setFrameRate(35.0, 2.0);
        this.defineMedia("example3.tbl");
        this.setBGImage("mybackground");
        for (int i = 0; i < 20; ++i) {
            new MyObject();
        }
        this.setTiles(2, 2, new String[]{"#####", "#", "#", "#"});
        this.setTiles(13, 2, new String[]{"#####", "....#", "....#", "....#"});
        this.setTiles(13, 9, new String[]{"....#", "....#", "....#", "#####"});
        this.setTiles(2, 9, new String[]{"#....", "#....", "#....", "#####"});
        this.setTileSettings("#", 2, 0);
    }

    public void doFrame() {
        this.moveObjects(null, 0);
        this.checkCollision(1, 1);
        this.checkBGCollision(3, 1);
    }

    class MyObject
    extends JGObject {
        MyObject() {
            super("myobject", true, Example4.this.random(48.0, Example4.this.pfWidth() - 64), Example4.this.random(48.0, Example4.this.pfHeight() - 64), 1, "myanim_l");
            this.xspeed = Example4.this.random(-2.0, 2.0);
            this.yspeed = Example4.this.random(-2.0, 2.0);
        }

        public void move() {
            if (this.xspeed < 0.0) {
                this.setGraphic("myanim_l");
            } else {
                this.setGraphic("myanim_r");
            }
        }

        public void hit_bg(int n) {
            if (!MyObject.and(this.checkBGCollision(-this.xspeed, this.yspeed), 3)) {
                this.xspeed = -this.xspeed;
            } else if (!MyObject.and(this.checkBGCollision(this.xspeed, -this.yspeed), 3)) {
                this.yspeed = -this.yspeed;
            } else if (!MyObject.and(this.checkBGCollision(this.xspeed, -this.yspeed), 3) && !MyObject.and(this.checkBGCollision(-this.xspeed, -this.yspeed), 3)) {
                this.xspeed = -this.xspeed;
                this.yspeed = -this.yspeed;
            }
        }

        public void hit(JGObject jGObject) {
            if (this.checkCollision(1, -3.0 * this.xspeed, -3.0 * this.yspeed) == 0) {
                this.xspeed = -this.xspeed;
                this.yspeed = -this.yspeed;
            }
        }
    }
}

