/*
 * Decompiled with CFR 0.152.
 */
package jgame.platform;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jgame.impl.JGameError;
import jgame.platform.JGEngine;

public class AppConfig {
    Vector fields = new Vector(20, 50);
    Hashtable fieldtypes = new Hashtable();
    Hashtable fieldguinames = new Hashtable();
    Hashtable fieldcomponents = new Hashtable();
    Hashtable fieldvalues = new Hashtable();
    Object obj = null;
    Class cls = null;
    String filename = null;
    String title;
    Object gui_lock = new Object();
    boolean gui_open = false;
    ActionListener listener = null;
    Font mainfont = new Font("Helvetica", 0, 16);
    Font bigfont = new Font("Helvetica", 1, 20);
    Color textcolor = new Color(0, 0, 100);
    Color bgcolor = new Color(180, 180, 255);
    Color hltcolor = new Color(230, 230, 255);
    Border border = BorderFactory.createEtchedBorder(this.hltcolor, this.textcolor);
    JPanel mainpanel = new JPanel();
    JPanel butpanel = new JPanel();
    JPanel toppanel = new JPanel();
    JButton save_but = new JButton("Save");
    JButton apply_but = new JButton("Apply");
    JButton cancel_but = new JButton("Close");
    JFrame topframe = new JFrame("Application Config");
    JScrollPane scrollpane = null;

    public String toString() {
        return this.title;
    }

    public void setGuiSettings(Font font, Font font2, Color color, Color color2, Color color3) {
        this.mainfont = font;
        this.bigfont = font2;
        this.textcolor = color;
        this.bgcolor = color2;
        this.hltcolor = color3;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Please supply filename of config to edit.");
        }
        AppConfig appConfig = new AppConfig(stringArray[0], stringArray[0]);
        appConfig.loadFromFile();
        appConfig.openGui();
        appConfig.waitUntilGuiClosed();
        System.exit(0);
    }

    public Object getObject() {
        return this.obj;
    }

    public void setObject(Object object) {
        this.obj = object;
        this.cls = object.getClass();
    }

    public Class getObjectClass() {
        return this.cls;
    }

    public String getFilename() {
        return this.filename;
    }

    public AppConfig(String string, String string2) {
        this.title = string;
        this.filename = string2;
        this.initGui();
    }

    public AppConfig(String string, Object object, String string2) {
        this.title = string;
        this.filename = string2;
        this.obj = object;
        this.cls = object.getClass();
        this.initGui();
    }

    public AppConfig(String string, Class clazz, String string2) {
        this.title = string;
        this.filename = string2;
        this.cls = clazz;
        this.initGui();
    }

    public AppConfig(String string, Object object) {
        this.title = string;
        this.obj = object;
        this.cls = object.getClass();
        this.initGui();
    }

    public AppConfig(String string, Class clazz) {
        this.title = string;
        this.cls = clazz;
        this.initGui();
    }

    void initGui() {
        this.mainpanel.setBackground(this.bgcolor);
        this.butpanel.setBackground(this.bgcolor);
        this.toppanel.setBackground(this.bgcolor);
        this.save_but.setBackground(this.bgcolor);
        this.save_but.setForeground(this.textcolor);
        this.save_but.setFont(this.bigfont);
        this.apply_but.setBackground(this.bgcolor);
        this.apply_but.setForeground(this.textcolor);
        this.apply_but.setFont(this.bigfont);
        this.cancel_but.setBackground(this.bgcolor);
        this.cancel_but.setForeground(this.textcolor);
        this.cancel_but.setFont(this.bigfont);
        this.mainpanel.setLayout(new BoxLayout(this.mainpanel, 1));
        if (this.filename != null) {
            this.butpanel.add(this.save_but);
            this.save_but.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppConfig.this.saveToFile();
                    if (AppConfig.this.cls != null) {
                        AppConfig.this.saveToObject();
                    }
                    AppConfig.this.topframe.setVisible(false);
                    AppConfig.this.signalCloseGui();
                }
            });
        }
        if (this.cls != null) {
            this.butpanel.add(this.apply_but);
            this.apply_but.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppConfig.this.saveToObject();
                    AppConfig.this.topframe.setVisible(false);
                    AppConfig.this.signalCloseGui();
                }
            });
        }
        this.butpanel.add(this.cancel_but);
        this.cancel_but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AppConfig.this.topframe.setVisible(false);
                AppConfig.this.signalCloseGui();
            }
        });
        this.toppanel.setLayout(new BoxLayout(this.toppanel, 1));
        JLabel jLabel = new JLabel(this.title);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.bgcolor);
        jLabel.setForeground(this.textcolor);
        jLabel.setFont(this.bigfont);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jLabel);
        this.toppanel.add(jPanel);
        this.toppanel.add(this.mainpanel);
        this.toppanel.add(this.butpanel);
        this.scrollpane = new JScrollPane(this.toppanel);
        this.topframe.getContentPane().add(this.scrollpane);
        this.topframe.setLocation(50, 50);
        this.topframe.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AppConfig.this.topframe.setVisible(false);
                AppConfig.this.signalCloseGui();
            }
        });
    }

    public void setListener(ActionListener actionListener) {
        this.listener = actionListener;
    }

    public void loadFromFile() {
        if (this.filename == null) {
            return;
        }
        try {
            Object object;
            BufferedReader bufferedReader;
            Object object2;
            try {
                object2 = new File(this.filename);
                if (!((File)object2).exists()) {
                    return;
                }
                bufferedReader = new BufferedReader(new FileReader((File)object2));
            }
            catch (AccessControlException accessControlException) {
                object = new URL(this.filename);
                bufferedReader = new BufferedReader(new InputStreamReader(((URL)object).openStream()));
            }
            while ((object2 = bufferedReader.readLine()) != null) {
                object = ((String)object2).substring(0, ((String)object2).indexOf("\t"));
                String string = ((String)object2).substring(((String)object2).indexOf("\t") + 1);
                String string2 = string.substring(0, string.indexOf("\t"));
                String string3 = string.substring(string.indexOf("\t") + 1);
                String string4 = string3.substring(0, string3.indexOf("\t"));
                String string5 = string3.substring(string3.indexOf("\t") + 1);
                this.defineField((String)object, string2, string4);
                this.setField((String)object, string5, true);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new JGameError("Error reading file '" + this.filename + "'.", false);
        }
    }

    public void saveToFile() {
        try {
            if (this.filename == null) {
                return;
            }
            PrintWriter printWriter = new PrintWriter(new FileWriter(new File(this.filename)));
            for (int i = 0; i < this.fields.size(); ++i) {
                String string = (String)this.fields.get(i);
                String string2 = (String)this.fieldguinames.get(string);
                Object v = this.fieldvalues.get(string);
                String string3 = (String)this.fieldtypes.get(string);
                printWriter.println(string + "\t" + string2 + "\t" + string3 + "\t" + v);
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new JGameError("Error writing file '" + this.filename + "'.", false);
        }
    }

    public void loadFromObject() {
        try {
            if (this.cls == null) {
                return;
            }
            for (int i = 0; i < this.fields.size(); ++i) {
                String string = (String)this.fields.get(i);
                String string2 = (String)this.fieldtypes.get(string);
                if (string2.equals("key") || string2.equals("int") || string2.equals("double") || string2.equals("boolean") || string2.equals("String")) {
                    Field field = this.cls.getField(string);
                    this.fieldvalues.put(string, field.get(this.obj));
                    continue;
                }
                System.out.println("not implemented!");
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new JGameError("Field not found.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JGameError("Field cannot be accessed.");
        }
    }

    public void saveToObject() {
        String string = null;
        try {
            if (this.cls == null) {
                return;
            }
            for (int i = 0; i < this.fields.size(); ++i) {
                string = (String)this.fields.get(i);
                Object v = this.fieldvalues.get(string);
                String string2 = (String)this.fieldtypes.get(string);
                if (string2.equals("key") || string2.equals("int") || string2.equals("double") || string2.equals("boolean") || string2.equals("String")) {
                    Field field = this.cls.getField(string);
                    field.set(this.obj, v);
                    continue;
                }
                System.out.println("not implemented!");
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            System.out.println("Cls:" + this.cls);
            throw new JGameError("Field " + string + " not found.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JGameError("Field " + string + " cannot be accessed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JGameError("Illegal field argument for field " + string + ".");
        }
    }

    public void defineField(String string, String string2, String string3) {
        try {
            if (this.fields.contains(string)) {
                return;
            }
            if (string2 == null) {
                string2 = string;
            }
            this.fields.add(string);
            this.fieldtypes.put(string, string3);
            this.fieldguinames.put(string, string2);
            this.addGuiComponent(string);
            if (this.cls != null) {
                Field field = this.cls.getField(string);
                this.setField(string, field.get(this.obj), true);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            System.out.println("Cls:" + this.cls);
            throw new JGameError("Field " + string + " not found.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JGameError("Field " + string + " has access error.");
        }
    }

    String classToType(Class clazz) {
        if (clazz == Point.class) {
            return "int2";
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return "int";
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return "double";
        }
        if (clazz == String.class) {
            return "String";
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return "boolean";
        }
        return null;
    }

    public void defineFields(String string, String string2, String string3, String string4) {
        this.defineFields(string, string2, string3, string4, null);
    }

    public void defineFields(String string, String string2, String string3, String string4, String string5) {
        Field[] fieldArray = this.cls.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string6;
            if (!Modifier.isPublic(fieldArray[i].getModifiers()) || !(string6 = fieldArray[i].getName()).startsWith(string) || !string6.endsWith(string2)) continue;
            String string7 = string3 + string6.substring(string.length(), string6.length() - string2.length()) + string4;
            String string8 = string5;
            if (string8 == null) {
                string8 = this.classToType(fieldArray[i].getType());
            }
            this.defineField(string6, string7, string8);
        }
    }

    public void setField(String string, Object object, boolean bl) {
        String string2 = (String)this.fieldtypes.get(string);
        if (string2.equals("String")) {
            if (object != null) {
                this.fieldvalues.put(string, object);
            } else {
                this.fieldvalues.remove(string);
            }
        } else if (!(object instanceof String)) {
            this.fieldvalues.put(string, object);
        } else {
            String string3 = (String)object;
            if (string2.equals("int")) {
                try {
                    this.fieldvalues.put(string, new Integer(Integer.parseInt(string3)));
                }
                catch (Exception exception) {}
            } else if (string2.equals("key")) {
                try {
                    this.fieldvalues.put(string, new Integer(Integer.parseInt(string3)));
                }
                catch (Exception exception) {}
            } else if (string2.equals("double")) {
                try {
                    this.fieldvalues.put(string, new Double(Double.parseDouble(string3)));
                }
                catch (Exception exception) {}
            } else if (string2.equals("boolean")) {
                this.fieldvalues.put(string, new Boolean(string3.equals("true")));
            } else {
                if (string2.equals("int2")) {
                    throw new JGameError("Unimplemented type " + string2, false);
                }
                if (string2.equals("int4")) {
                    throw new JGameError("Unimplemented type " + string2, false);
                }
                if (string2.equals("File")) {
                    throw new JGameError("Unimplemented type " + string2, false);
                }
                if (string2.equals("Color")) {
                    throw new JGameError("Unimplemented type " + string2, false);
                }
                if (string2.equals("Font")) {
                    throw new JGameError("Unimplemented type " + string2, false);
                }
                throw new JGameError("Unknown type " + string2, false);
            }
        }
        if (bl) {
            this.updateGui(string);
        }
    }

    void addGuiComponent(String string) {
        String string2 = (String)this.fieldguinames.get(string) + "  ";
        String string3 = (String)this.fieldtypes.get(string);
        Object v = this.fieldvalues.get(string);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setBackground(this.bgcolor);
        this.mainpanel.add(jPanel);
        JLabel jLabel = new JLabel(string2, 4);
        jLabel.setBackground(this.bgcolor);
        jLabel.setForeground(this.textcolor);
        jLabel.setFont(this.mainfont);
        if (string3.equals("int") || string3.equals("double")) {
            JTextField jTextField = new JTextField("" + v, 8);
            jTextField.addCaretListener(new FieldChangeHandler(string){

                public void caretUpdate(CaretEvent caretEvent) {
                    JTextField jTextField = (JTextField)AppConfig.this.fieldcomponents.get(this.fieldname);
                    AppConfig.this.processAction(this.fieldname, jTextField.getText());
                }
            });
            if (string3.equals("int")) {
                jTextField.setToolTipText("Enter an integer.");
            } else {
                jTextField.setToolTipText("Enter a real number.");
            }
            jTextField.setFont(this.mainfont);
            jTextField.setForeground(this.textcolor);
            jTextField.setBackground(this.hltcolor);
            this.fieldcomponents.put(string, jTextField);
            jPanel.add(jLabel);
            jPanel.add(jTextField);
        } else if (string3.equals("String")) {
            JTextField jTextField = new JTextField("" + v, 8);
            jTextField.addCaretListener(new FieldChangeHandler(string){

                public void caretUpdate(CaretEvent caretEvent) {
                    JTextField jTextField = (JTextField)AppConfig.this.fieldcomponents.get(this.fieldname);
                    AppConfig.this.processAction(this.fieldname, jTextField.getText());
                }
            });
            jTextField.setToolTipText("Enter a text.");
            jTextField.setFont(this.mainfont);
            jTextField.setForeground(this.textcolor);
            jTextField.setBackground(this.hltcolor);
            this.fieldcomponents.put(string, jTextField);
            jPanel.add(jLabel);
            jPanel.add(jTextField);
        } else if (string3.equals("boolean")) {
            JCheckBox jCheckBox = new JCheckBox("yes");
            jCheckBox.addItemListener(new FieldChangeHandler(string){

                public void itemStateChanged(ItemEvent itemEvent) {
                    Boolean bl = new Boolean(itemEvent.getStateChange() == 1);
                    AppConfig.this.processAction(this.fieldname, bl);
                }
            });
            jCheckBox.setFont(this.mainfont);
            jCheckBox.setForeground(this.textcolor);
            jCheckBox.setBackground(this.bgcolor);
            this.fieldcomponents.put(string, jCheckBox);
            jPanel.add(jLabel);
            jPanel.add(jCheckBox);
        } else if (string3.equals("key")) {
            KeyField keyField = new KeyField(string, this.bgcolor, this.hltcolor);
            this.fieldcomponents.put(string, keyField);
            keyField.setToolTipText("Click then press a key to define keystroke.");
            keyField.setFont(this.mainfont);
            keyField.setForeground(this.textcolor);
            jPanel.add(jLabel);
            jPanel.add(keyField);
        }
    }

    void processAction(String string, Object object) {
        this.setField(string, object, false);
    }

    public void openGui() {
        this.gui_open = true;
        this.topframe.pack();
        this.topframe.setVisible(true);
        this.topframe.requestFocus();
    }

    public void closeGui() {
        this.topframe.setVisible(false);
        this.signalCloseGui();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalCloseGui() {
        Object object = this.gui_lock;
        synchronized (object) {
            this.gui_open = false;
            this.gui_lock.notifyAll();
        }
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
    }

    public boolean isGuiOpen() {
        return this.gui_open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilGuiClosed() {
        Object object = this.gui_lock;
        synchronized (object) {
            try {
                while (this.gui_open) {
                    this.gui_lock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void updateGui(String string) {
        Object v = this.fieldvalues.get(string);
        Object v2 = this.fieldcomponents.get(string);
        String string2 = (String)this.fieldtypes.get(string);
        if (v2 instanceof JCheckBox) {
            ((JCheckBox)v2).setSelected((Boolean)v);
        } else if (v2 instanceof JColorChooser) {
            JColorChooser jColorChooser = (JColorChooser)v2;
            jColorChooser.setColor((Color)v);
        } else if (v2 instanceof KeyField) {
            ((KeyField)v2).setValue((Integer)v);
        } else if (v2 instanceof JTextField) {
            JTextField jTextField = (JTextField)v2;
            if (string2.equals("int") || string2.equals("double")) {
                jTextField.setText("" + v);
            } else if (string2.equals("String")) {
                jTextField.setText("" + v);
            }
        }
    }

    class KeyField
    extends JTextField
    implements KeyListener,
    FocusListener {
        String fieldname;
        Color norm_bg;
        Color hlt_bg;

        public KeyField(String string, Color color, Color color2) {
            super(10);
            this.fieldname = string;
            this.setEditable(true);
            this.addKeyListener(this);
            this.addFocusListener(this);
            this.norm_bg = color;
            this.hlt_bg = color2;
            this.setBackground(color);
            this.setBorder(AppConfig.this.border);
        }

        public void setValue(int n) {
            this.setText(JGEngine.getKeyDescStatic(n));
        }

        public int getValue() {
            return JGEngine.getKeyCodeStatic(this.getText());
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n != 0) {
                this.setText(JGEngine.getKeyDescStatic(n));
                AppConfig.this.processAction(this.fieldname, new Integer(n));
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
            this.setBackground(this.hlt_bg);
        }

        public void focusLost(FocusEvent focusEvent) {
            this.setBackground(this.norm_bg);
        }
    }

    class FieldChangeHandler
    implements ActionListener,
    ChangeListener,
    ItemListener,
    CaretListener {
        String fieldname = null;
        Component component;

        public FieldChangeHandler(String string) {
            this.fieldname = string;
        }

        public FieldChangeHandler(String string, Component component) {
            this.fieldname = string;
            this.component = component;
        }

        public FieldChangeHandler(Component component) {
            this.component = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println(actionEvent);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            System.out.println(changeEvent);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            System.out.println(itemEvent);
        }

        public void caretUpdate(CaretEvent caretEvent) {
            System.out.println(caretEvent);
        }
    }
}

