/*
 * Decompiled with CFR 0.152.
 */
package jgame.platform;

import com.sun.opengl.util.Animator;
import com.sun.opengl.util.j2d.TextRenderer;
import com.sun.opengl.util.j2d.TextureRenderer;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureIO;
import java.applet.Applet;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGImage;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.JGRectangle;
import jgame.JGTimer;
import jgame.impl.Animation;
import jgame.impl.EngineLogic;
import jgame.impl.ImageMap;
import jgame.impl.JGEngineInterface;
import jgame.impl.JGameError;
import jgame.impl.SortedArray;
import jgame.platform.JREEngine;
import jgame.platform.JREImage;

public abstract class JGEngine
extends Applet
implements JGEngineInterface {
    JREImage imageutil = new JREImage();
    EngineLogic el = new EngineLogic(this.imageutil, false, false);
    JREEngine jre = new JREEngine(this.el, this);
    private Thread thread = null;
    Animator anim = null;
    GLU glu = new GLU();
    JGCanvas canvas = null;
    double viewzoom = 1.0;
    double viewrotate = 0.0;
    boolean running = true;
    boolean i_am_applet = false;
    public static final int KeyBackspace = 8;
    public static final int KeyTab = 9;
    boolean gl_driven_update = false;
    boolean enable_npot = false;
    TextureRenderer background = null;
    TextureRenderer buffer = null;
    Graphics2D bgg = null;
    Graphics2D bufg = null;
    Graphics buf_gfx = null;
    GL cur_gl = null;
    int debugflags = 8;
    static final int BBOX_DEBUG = 1;
    static final int GAMESTATE_DEBUG = 2;
    static final int FULLSTACKTRACE_DEBUG = 4;
    static final int MSGSINPF_DEBUG = 8;
    private static int dbgframelog_expiry = 80;
    private JGFont debugmessage_font = new JGFont("Arial", 0, 12.0);
    JGColor debug_auxcolor1 = JGColor.green;
    JGColor debug_auxcolor2 = JGColor.magenta;
    private Hashtable dbgframelogs = new Hashtable();
    private Hashtable dbgnewframelogs = new Hashtable();
    private Hashtable dbgframelogs_new = new Hashtable();
    private Hashtable dbgframelogs_obj = new Hashtable();
    private Hashtable dbgframelogs_dead = new Hashtable();
    private BufferedImage null_image = new BufferedImage(1, 1, 2);
    boolean modelview_matrix_pf_relative = false;
    double[] ovalx = null;
    double[] ovaly = null;
    double[] ovalx_sm = null;
    double[] ovaly_sm = null;
    double[] ovalx_lg = null;
    double[] ovaly_lg = null;
    JGColor[] ovals;
    JGColor[] ovals_sm;
    JGColor[] ovals_lg;
    JGColor[] ovalshade;
    Hashtable textren = new Hashtable();
    Font cur_gl_font = new Font("Arial", 0, 12);
    JGColor cur_gl_color = JGColor.white;
    double cur_gl_stroke = 1.0;
    int cur_gl_blend_src = 1;
    int cur_gl_blend_dst = -1;

    public JGImage getImage(String string) {
        return this.el.getImage(string);
    }

    public JGPoint getImageSize(String string) {
        return this.el.getImageSize(string);
    }

    public void defineImage(String string, String string2, int n, String string3, String string4, int n2, int n3, int n4, int n5) {
        this.el.defineImage(this, string, string2, n, string3, string4, n2, n3, n4, n5);
    }

    public void defineImage(String string, String string2, int n, String string3, String string4) {
        this.el.defineImage(this, string, string2, n, string3, string4);
    }

    public void defineImage(String string, String string2, int n, String string3, int n2, String string4, int n3, int n4, int n5, int n6) {
        this.el.defineImage(string, string2, n, string3, n2, string4, n3, n4, n5, n6);
    }

    public void defineImage(String string, String string2, int n, String string3, int n2, String string4) {
        this.el.defineImage(string, string2, n, string3, n2, string4);
    }

    public void defineImageRotated(String string, String string2, int n, String string3, double d) {
        this.el.defineImageRotated(this, string, string2, n, string3, d);
    }

    public void defineImageMap(String string, String string2, int n, int n2, int n3, int n4, int n5, int n6) {
        this.el.defineImageMap(this, string, string2, n, n2, n3, n4, n5, n6);
    }

    public JGRectangle getImageBBox(String string) {
        return this.el.getImageBBox(string);
    }

    public void defineMedia(String string) {
        this.el.defineMedia(this, string);
    }

    public void markAddObject(JGObject jGObject) {
        this.el.markAddObject(jGObject);
    }

    public boolean existsObject(String string) {
        return this.el.existsObject(string);
    }

    public JGObject getObject(String string) {
        return this.el.getObject(string);
    }

    public void moveObjects(String string, int n) {
        this.el.moveObjects(this, string, n);
    }

    public void moveObjects() {
        this.el.moveObjects(this);
    }

    public void checkCollision(int n, int n2) {
        this.el.checkCollision(this, n, n2);
    }

    public int checkCollision(int n, JGObject jGObject) {
        return this.el.checkCollision(n, jGObject);
    }

    public int checkBGCollision(JGRectangle jGRectangle) {
        return this.el.checkBGCollision(jGRectangle);
    }

    public void checkBGCollision(int n, int n2) {
        this.el.checkBGCollision(this, n, n2);
    }

    public Vector getObjects(String string, int n, boolean bl, JGRectangle jGRectangle) {
        return this.el.getObjects(string, n, bl, jGRectangle);
    }

    public void removeObject(JGObject jGObject) {
        this.el.removeObject(jGObject);
    }

    public void removeObjects(String string, int n) {
        this.el.removeObjects(string, n);
    }

    public void removeObjects(String string, int n, boolean bl) {
        this.el.removeObjects(string, n, bl);
    }

    public int countObjects(String string, int n) {
        return this.el.countObjects(string, n);
    }

    public int countObjects(String string, int n, boolean bl) {
        return this.el.countObjects(string, n, bl);
    }

    void drawObject(Graphics graphics, GL gL, JGObject jGObject) {
        if (!jGObject.is_suspended) {
            this.drawImage(gL, (int)jGObject.x, (int)jGObject.y, jGObject.getImageName(), null, 1.0, 0.0, 1.0, true);
            try {
                jGObject.paint();
            }
            catch (JGameError jGameError) {
                this.exitEngine(this.dbgExceptionToString(jGameError));
            }
            catch (Exception exception) {
                this.dbgShowException(jGObject.getName(), exception);
            }
        }
        if ((this.debugflags & 1) != 0) {
            JGColor jGColor = this.cur_gl_color;
            double d = this.cur_gl_stroke;
            this.setStroke(1.0);
            this.setColor(this.el.fg_color);
            JGRectangle jGRectangle = jGObject.getBBox();
            if (jGRectangle != null) {
                this.drawRect(jGRectangle.x, jGRectangle.y, jGRectangle.width, jGRectangle.height, false, false);
            }
            if ((jGRectangle = jGObject.getTileBBox()) != null) {
                this.drawRect(jGRectangle.x, jGRectangle.y, jGRectangle.width, jGRectangle.height, false, false);
                this.setColor(this.debug_auxcolor1);
                jGRectangle = jGObject.getTileBBox();
                jGRectangle = this.getTiles(jGRectangle);
                jGRectangle.x *= this.el.tilex;
                jGRectangle.y *= this.el.tiley;
                jGRectangle.width *= this.el.tilex;
                jGRectangle.height *= this.el.tiley;
                this.drawRect(jGRectangle.x, jGRectangle.y, jGRectangle.width, jGRectangle.height, false, false);
                this.setColor(this.debug_auxcolor2);
                jGRectangle = jGObject.getCenterTiles();
                jGRectangle.x *= this.el.tilex;
                jGRectangle.y *= this.el.tiley;
                jGRectangle.width *= this.el.tilex;
                jGRectangle.height *= this.el.tiley;
                this.drawRect(jGRectangle.x + 2, jGRectangle.y + 2, jGRectangle.width - 4, jGRectangle.height - 4, false, false);
            }
            this.setColor(jGColor);
            this.setStroke(d);
        }
    }

    public void setBGImage(String string) {
        this.el.setBGImage(string, 0, true, true);
    }

    public void setBGImage(int n, String string, boolean bl, boolean bl2) {
        this.el.setBGImage(string, n, bl, bl2);
    }

    public void setTileSettings(String string, int n, int n2) {
        this.el.setTileSettings(string, n, n2);
    }

    public void fillBG(String string) {
        this.el.fillBG(string);
    }

    public void setTileCid(int n, int n2, int n3, int n4) {
        this.el.setTileCid(n, n2, n3, n4);
    }

    public void setTile(int n, int n2, String string) {
        this.el.setTile(n, n2, string);
    }

    void setColor(Graphics graphics, JGColor jGColor) {
        this.cur_gl_color = jGColor;
        jGColor.impl = new Color(jGColor.r, jGColor.g, jGColor.b);
        graphics.setColor((Color)jGColor.impl);
    }

    void setColor(GL gL, JGColor jGColor) {
        this.cur_gl_color = jGColor;
        gL.glColor4d((double)jGColor.r / 255.0, (double)jGColor.g / 255.0, (double)jGColor.b / 255.0, (double)jGColor.alpha / 255.0);
    }

    public void drawTile(int n, int n2, int n3) {
        Integer n4;
        JREImage jREImage;
        if (this.background == null) {
            return;
        }
        int n5 = this.el.moduloFloor(n + 1, this.el.viewnrtilesx + 3) * this.el.scaledtilex;
        int n6 = this.el.moduloFloor(n2 + 1, this.el.viewnrtilesy + 3) * this.el.scaledtiley;
        if (this.bgg == null) {
            this.bgg = this.background.createGraphics();
            this.bgg.setComposite(AlphaComposite.getInstance(2));
        }
        if ((jREImage = (JREImage)this.el.getTileImage(n4 = new Integer(n3))) == null || this.el.images_transp.containsKey(n4)) {
            this.bgg.setColor(new Color(this.el.bg_color.r, this.el.bg_color.g, this.el.bg_color.b, 0));
            this.bgg.fillRect(n5, n6, this.el.scaledtilex, this.el.scaledtiley);
        }
        if (jREImage != null) {
            this.bgg.drawImage(jREImage.img, n5, n6, this);
        }
        this.background.markDirty(n5, n6, this.el.scaledtilex, this.el.scaledtiley);
    }

    public int countTiles(int n) {
        return this.el.countTiles(n);
    }

    public int getTileCid(int n, int n2) {
        return this.el.getTileCid(n, n2);
    }

    public String getTileStr(int n, int n2) {
        return this.el.getTileStr(n, n2);
    }

    public int getTileCid(JGRectangle jGRectangle) {
        return this.el.getTileCid(jGRectangle);
    }

    public JGRectangle getTiles(JGRectangle jGRectangle) {
        return this.el.getTiles(jGRectangle);
    }

    public boolean getTiles(JGRectangle jGRectangle, JGRectangle jGRectangle2) {
        return this.el.getTiles(jGRectangle, jGRectangle2);
    }

    public void setTileCid(int n, int n2, int n3) {
        this.el.setTileCid(n, n2, n3);
    }

    public void orTileCid(int n, int n2, int n3) {
        this.el.orTileCid(n, n2, n3);
    }

    public void andTileCid(int n, int n2, int n3) {
        this.el.andTileCid(n, n2, n3);
    }

    public void setTile(JGPoint jGPoint, String string) {
        this.el.setTile(jGPoint, string);
    }

    public void setTiles(int n, int n2, String[] stringArray) {
        this.el.setTiles(n, n2, stringArray);
    }

    public void setTilesMulti(int n, int n2, String[] stringArray) {
        this.el.setTilesMulti(n, n2, stringArray);
    }

    public int getTileCidAtCoord(double d, double d2) {
        return this.el.getTileCidAtCoord(d, d2);
    }

    public int getTileCid(JGPoint jGPoint, int n, int n2) {
        return this.el.getTileCid(jGPoint, n, n2);
    }

    public String getTileStrAtCoord(double d, double d2) {
        return this.el.getTileStrAtCoord(d, d2);
    }

    public String getTileStr(JGPoint jGPoint, int n, int n2) {
        return this.el.getTileStr(jGPoint, n, n2);
    }

    public int tileStrToID(String string) {
        return this.el.tileStrToID(string);
    }

    public String tileIDToStr(int n) {
        return this.el.tileIDToStr(n);
    }

    public double moduloXPos(double d) {
        return this.el.moduloXPos(d);
    }

    public double moduloYPos(double d) {
        return this.el.moduloYPos(d);
    }

    public void setProgressBar(double d) {
        this.canvas.setProgressBar(d);
    }

    public void setProgressMessage(String string) {
        this.canvas.setProgressMessage(string);
    }

    public void setAuthorMessage(String string) {
        this.canvas.setAuthorMessage(string);
    }

    private void refreshDbgFrameLogs() {
        this.dbgframelogs_new = new Hashtable();
        Enumeration enumeration = this.dbgnewframelogs.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = this.dbgnewframelogs.get(string);
            this.dbgframelogs.put(string, v);
            this.dbgframelogs_new.put(string, "yes");
        }
        this.dbgnewframelogs = new Hashtable();
    }

    void paintDbgFrameLogs() {
        Font font = this.cur_gl_font;
        JGColor jGColor = this.cur_gl_color;
        this.cur_gl_font = new Font(this.debugmessage_font.name, this.debugmessage_font.style, (int)this.debugmessage_font.size);
        Enumeration enumeration = this.dbgframelogs.keys();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2;
            double d;
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)this.dbgframelogs.get(string);
            if (this.dbgframelogs_new.containsKey(string)) {
                this.setColor(this.el.fg_color);
            } else {
                this.setColor(this.debug_auxcolor1);
            }
            JGObject jGObject = this.el.getObject(string);
            if (jGObject == null) {
                jGObject = (JGObject)this.dbgframelogs_obj.get(string);
                this.setColor(this.debug_auxcolor2);
                if (jGObject != null) {
                    int n = 0;
                    if (this.dbgframelogs_dead.containsKey(string)) {
                        n = (Integer)this.dbgframelogs_dead.get(string);
                    }
                    if (n < dbgframelog_expiry) {
                        this.dbgframelogs_dead.put(string, new Integer(n + 1));
                    } else {
                        this.dbgframelogs_obj.remove(string);
                        this.dbgframelogs_dead.remove(string);
                    }
                }
            }
            double d2 = (double)(this.debugmessage_font.getSize() + 1) / this.el.y_scale_fac;
            if (jGObject != null) {
                d = jGObject.y - d2 * (double)vector.size();
                enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    this.drawString((String)enumeration2.nextElement(), jGObject.x, d, -1, true);
                    d += d2;
                }
                continue;
            }
            if (!string.equals("MAIN")) {
                this.dbgframelogs.remove(string);
                continue;
            }
            if (this.dbgframelogs_new.containsKey(string)) {
                this.setColor(this.el.fg_color);
            } else {
                this.setColor(this.debug_auxcolor1);
            }
            d = (double)this.el.viewHeight() - d2 * (double)vector.size();
            enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                this.drawString((String)enumeration2.nextElement(), 0.0, d, -1, false);
                d += d2;
            }
        }
        this.cur_gl_font = font;
        this.cur_gl_color = jGColor;
    }

    public void dbgShowBoundingBox(boolean bl) {
        this.debugflags = bl ? (this.debugflags |= 1) : (this.debugflags &= 0xFFFFFFFE);
    }

    public void dbgShowGameState(boolean bl) {
        this.debugflags = bl ? (this.debugflags |= 2) : (this.debugflags &= 0xFFFFFFFD);
    }

    public void dbgShowFullStackTrace(boolean bl) {
        this.debugflags = bl ? (this.debugflags |= 4) : (this.debugflags &= 0xFFFFFFFB);
    }

    public void dbgShowMessagesInPf(boolean bl) {
        this.debugflags = bl ? (this.debugflags |= 8) : (this.debugflags &= 0xFFFFFFF7);
    }

    public void dbgSetMessageExpiry(int n) {
        dbgframelog_expiry = n;
    }

    public void dbgSetMessageFont(JGFont jGFont) {
        this.debugmessage_font = jGFont;
    }

    public void dbgSetDebugColor1(JGColor jGColor) {
        this.debug_auxcolor1 = jGColor;
    }

    public void dbgSetDebugColor2(JGColor jGColor) {
        this.debug_auxcolor2 = jGColor;
    }

    public void dbgPrint(String string) {
        this.dbgPrint("MAIN", string);
    }

    public void dbgPrint(String string, String string2) {
        if ((this.debugflags & 8) != 0) {
            Vector<String> vector = (Vector<String>)this.dbgnewframelogs.get(string);
            if (vector == null) {
                vector = new Vector<String>(5, 15);
            }
            if (vector.size() < 19) {
                vector.add(string2);
            } else if (vector.size() == 19) {
                vector.add("<messages truncated>");
            }
            this.dbgnewframelogs.put(string, vector);
            JGObject jGObject = this.el.getObject(string);
            if (jGObject != null) {
                this.dbgframelogs_obj.put(string, jGObject);
                this.dbgframelogs_dead.remove(string);
            }
        } else {
            System.out.println(string + ": " + string2);
        }
    }

    public void dbgShowException(String string, Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
        if ((this.debugflags & 4) != 0) {
            this.dbgPrint(string, byteArrayOutputStream.toString());
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(byteArrayOutputStream.toString(), "\n");
            this.dbgPrint(string, stringTokenizer.nextToken());
            this.dbgPrint(string, stringTokenizer.nextToken());
            if (stringTokenizer.hasMoreTokens()) {
                this.dbgPrint(string, stringTokenizer.nextToken());
            }
        }
    }

    public String dbgExceptionToString(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
        if ((this.debugflags & 4) != 0) {
            return byteArrayOutputStream.toString();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(byteArrayOutputStream.toString(), "\n");
        String string = stringTokenizer.nextToken() + "\n";
        string = string + stringTokenizer.nextToken() + "\n";
        if (stringTokenizer.hasMoreTokens()) {
            string = string + stringTokenizer.nextToken();
        }
        return string;
    }

    public void exitEngine(String string) {
        if (string != null) {
            System.err.println(string);
            this.el.exit_message = string;
        }
        System.err.println("Exiting JGEngine.");
        if (!this.i_am_applet) {
            System.exit(0);
        }
        this.destroy();
        this.canvas.repaint();
    }

    public JGEngine() {
        this.imageutil.setComponent(this);
    }

    public void initEngineComponent(int n, int n2) {
        this.i_am_applet = false;
        this.jre.create_frame = false;
        this.el.winwidth = n;
        this.el.winheight = n2;
        this.init();
    }

    public void initEngineApplet() {
        this.i_am_applet = true;
    }

    public void initEngine(int n, int n2) {
        this.i_am_applet = false;
        this.jre.create_frame = true;
        if (n == 0) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.el.winwidth = dimension.width;
            this.el.winheight = dimension.height;
            this.jre.win_decoration = false;
        } else {
            this.el.winwidth = n;
            this.el.winheight = n2;
            this.jre.win_decoration = true;
        }
        this.init();
    }

    public void setCanvasSettings(int n, int n2, int n3, int n4, JGColor jGColor, JGColor jGColor2, JGFont jGFont) {
        this.el.nrtilesx = n;
        this.el.nrtilesy = n2;
        this.el.viewnrtilesx = n;
        this.el.viewnrtilesy = n2;
        this.el.tilex = n3;
        this.el.tiley = n4;
        this.setColorsFont(jGColor, jGColor2, jGFont);
        this.el.view_initialised = true;
    }

    public void setScalingPreferences(double d, double d2, int n, int n2, int n3, int n4) {
        this.el.min_aspect = d;
        this.el.max_aspect = d2;
        this.el.crop_top = n;
        this.el.crop_left = n2;
        this.el.crop_bottom = n3;
        this.el.crop_right = n4;
    }

    public void setSmoothing(boolean bl) {
        this.el.smooth_magnify = bl;
    }

    public void requestGameFocus() {
        this.canvas.requestFocus();
    }

    public boolean isApplet() {
        return this.i_am_applet;
    }

    public boolean isMidlet() {
        return false;
    }

    public boolean isOpenGL() {
        return true;
    }

    public int viewWidth() {
        return this.el.viewnrtilesx * this.el.tilex;
    }

    public int viewHeight() {
        return this.el.viewnrtilesy * this.el.tiley;
    }

    public int viewTilesX() {
        return this.el.viewnrtilesx;
    }

    public int viewTilesY() {
        return this.el.viewnrtilesy;
    }

    public int viewXOfs() {
        return this.el.pendingxofs;
    }

    public int viewYOfs() {
        return this.el.pendingyofs;
    }

    public int pfWidth() {
        return this.el.nrtilesx * this.el.tilex;
    }

    public int pfHeight() {
        return this.el.nrtilesy * this.el.tiley;
    }

    public int pfTilesX() {
        return this.el.nrtilesx;
    }

    public int pfTilesY() {
        return this.el.nrtilesy;
    }

    public boolean pfWrapX() {
        return this.el.pf_wrapx;
    }

    public boolean pfWrapY() {
        return this.el.pf_wrapy;
    }

    public int tileWidth() {
        return this.el.tilex;
    }

    public int tileHeight() {
        return this.el.tiley;
    }

    public int displayWidth() {
        return this.el.winwidth;
    }

    public int displayHeight() {
        return this.el.winheight;
    }

    public double getFrameRate() {
        return this.el.fps;
    }

    public double getGameSpeed() {
        return this.el.gamespeed;
    }

    public double getFrameSkip() {
        return this.el.maxframeskip;
    }

    public boolean getVideoSyncedUpdate() {
        return this.gl_driven_update;
    }

    public int getOffscreenMarginX() {
        return this.el.offscreen_margin_x;
    }

    public int getOffscreenMarginY() {
        return this.el.offscreen_margin_y;
    }

    public double getXScaleFactor() {
        return this.el.x_scale_fac;
    }

    public double getYScaleFactor() {
        return this.el.y_scale_fac;
    }

    public double getMinScaleFactor() {
        return this.el.min_scale_fac;
    }

    public void init() {
        this.jre.storeInit();
        if (this.el.winwidth == 0) {
            this.el.winwidth = this.getWidth();
            this.el.winheight = this.getHeight();
            if (this.el.winwidth <= 1 || this.el.winheight <= 1) {
                this.el.winwidth = Integer.parseInt(this.getParameter("canvaswidth"));
                this.el.winheight = Integer.parseInt(this.getParameter("canvasheight"));
            }
        }
        this.initCanvas();
        if (!this.el.view_initialised) {
            this.exitEngine("Canvas settings not initialised, use setCanvasSettings().");
        }
        if (!this.i_am_applet && this.jre.create_frame) {
            this.jre.createWindow(this, this.jre.win_decoration);
        }
        this.el.initPF();
        this.canvas = new JGCanvas(this.el.winwidth, this.el.winheight);
        this.canvas.addGLEventListener(this.canvas);
        this.jre.canvas = this.canvas;
        this.jre.clearKeymap();
        this.canvas.addMouseListener(this.jre);
        this.canvas.addMouseMotionListener(this.jre);
        this.canvas.addFocusListener(this.jre);
        this.canvas.setBackground(this.getAWTColor(this.el.bg_color));
        if (this.jre.my_win != null) {
            this.jre.my_win.setBackground(this.getAWTColor(this.el.bg_color));
        }
        this.el.msg_font = new JGFont("Helvetica", 0, (int)(16.0 / (640.0 / (double)(this.el.tilex * this.el.nrtilesx))));
        this.setLayout(new FlowLayout(3, 0, 0));
        this.add((Component)((Object)this.canvas));
        if (!JGObject.setEngine(this)) {
            this.canvas.setInitPainter(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    GL gL = (GL)object;
                    JGEngine.this.setFont(JGEngine.this.el.msg_font);
                    JGEngine.this.setColor(gL, JGEngine.this.el.fg_color);
                    JGEngine.this.drawString(gL, "JGame is already running in this VM", (double)(JGEngine.this.el.viewWidth() / 2), (double)(JGEngine.this.el.viewHeight() / 3), 0, false);
                    return null;
                }
            });
            return;
        }
        this.el.is_inited = true;
        this.canvas.setInitPainter(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JGImage jGImage;
                GL gL;
                JGEngine.this.cur_gl = gL = (GL)object;
                JGEngine.this.setFont(JGEngine.this.el.msg_font);
                JGEngine.this.setColor(JGEngine.this.el.fg_color);
                JGImage jGImage2 = jGImage = JGEngine.this.el.existsImage("splash_image") ? JGEngine.this.el.getImage("splash_image") : null;
                if (jGImage != null) {
                    gL.glEnable(3042);
                    gL.glBlendFunc(770, 771);
                    gL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                    JGPoint jGPoint = JGEngine.this.getImageSize("splash_image");
                    JGEngine.this.drawImage(gL, JGEngine.this.viewWidth() / 2 - jGPoint.x / 2, Math.max(0, JGEngine.this.viewHeight() / 4 - jGPoint.y / 2), "splash_image", null, 1.0, 0.0, 1.0, false);
                    gL.glDisable(3042);
                }
                JGEngine.this.drawString(JGEngine.this.canvas.progress_message, JGEngine.this.viewWidth() / 2, JGEngine.this.viewHeight() / 2, 0, false);
                JGEngine.this.setColor(JGEngine.this.el.bg_color);
                JGEngine.this.drawRect((int)((double)JGEngine.this.viewWidth() * (0.1 + 0.8 * JGEngine.this.canvas.progress_bar)), (int)((double)JGEngine.this.viewHeight() * 0.6), (int)((double)JGEngine.this.viewWidth() * 0.8 * (1.0 - JGEngine.this.canvas.progress_bar)), (int)((double)JGEngine.this.viewHeight() * 0.05), true, false, false);
                JGEngine.this.setColor(JGEngine.this.el.fg_color);
                JGEngine.this.drawRect((int)((double)JGEngine.this.viewWidth() * 0.1), (int)((double)JGEngine.this.viewHeight() * 0.6), (int)((double)JGEngine.this.viewWidth() * 0.8 * JGEngine.this.canvas.progress_bar), (int)((double)JGEngine.this.viewHeight() * 0.05), true, false, false);
                JGEngine.this.drawRect((int)((double)JGEngine.this.viewWidth() * 0.1), (int)((double)JGEngine.this.viewHeight() * 0.6), (int)((double)JGEngine.this.viewWidth() * 0.8), (int)((double)JGEngine.this.viewHeight() * 0.008), true, false, false);
                JGEngine.this.drawRect((int)((double)JGEngine.this.viewWidth() * 0.1), (int)((double)JGEngine.this.viewHeight() * 0.646), (int)((double)JGEngine.this.viewWidth() * 0.8), (int)((double)JGEngine.this.viewHeight() * 0.008), true, false, false);
                JGEngine.this.drawString(JGEngine.this.canvas.author_message, JGEngine.this.viewWidth() - 16, (double)JGEngine.this.viewHeight() - JGEngine.this.getFontHeight(JGEngine.this.el.msg_font) - 10.0, 1, false);
                return null;
            }
        });
        if (this.jre.my_win != null) {
            this.jre.my_win.setVisible(true);
            this.jre.my_win.validate();
            this.jre.setWindowSize(this.jre.win_decoration);
        }
        this.canvas.addKeyListener(this.jre);
        this.canvas.requestFocus();
        this.canvas.repaint();
        this.thread = new Thread(new JGEngineThread());
        this.thread.start();
    }

    public abstract void initCanvas();

    public abstract void initGame();

    public void start() {
        this.running = true;
        this.canvas.repaint();
    }

    public void stop() {
        this.running = false;
    }

    public void startApp() {
        if (!this.el.is_inited) {
            this.init();
        } else {
            this.start();
        }
    }

    public void pauseApp() {
        this.stop();
    }

    public void destroyApp(boolean bl) {
        this.destroy();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void wakeUpOnKey(int n) {
        this.jre.wakeUpOnKey(n);
    }

    public void destroy() {
        this.el.is_exited = true;
        if (this.anim != null) {
            this.anim.stop();
            this.anim = null;
        }
        if (this.thread != null) {
            if (!this.i_am_applet) {
                this.thread.interrupt();
            }
            try {
                this.thread.join(2000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (this.el.is_inited) {
            JGObject.setEngine(null);
        }
        this.disableAudio();
        System.out.println("JGame engine disposed.");
    }

    public void setViewOffset(int n, int n2, boolean bl) {
        this.el.setViewOffset(n, n2, bl);
    }

    public void setBGImgOffset(int n, double d, double d2, boolean bl) {
        this.el.setBGImgOffset(n, d, d2, bl);
    }

    public void setViewZoomRotate(double d, double d2) {
        this.viewzoom = d;
        this.viewrotate = d2;
    }

    public void setPFSize(int n, int n2) {
        this.el.setPFSize(n, n2);
    }

    public void setPFWrap(boolean bl, boolean bl2, int n, int n2) {
        this.el.setPFWrap(bl, bl2, n, n2);
    }

    public void setFrameRate(double d, double d2) {
        this.el.setFrameRate(d, d2);
    }

    public void setVideoSyncedUpdate(boolean bl) {
        this.gl_driven_update = bl;
        if (bl) {
            if (this.canvas != null) {
                this.canvas.repaint();
            }
        } else {
            if (this.anim != null) {
                this.anim.stop();
                this.anim = null;
            }
            this.setGameSpeed(1.0);
        }
    }

    public void setGameSpeed(double d) {
        this.el.setGameSpeed(d);
    }

    public void setRenderSettings(int n, JGColor jGColor) {
        this.el.setRenderSettings(n, jGColor);
    }

    public void setOffscreenMargin(int n, int n2) {
        this.el.setOffscreenMargin(n, n2);
    }

    public void setBGColor(JGColor jGColor) {
        Color color = new Color(jGColor.r, jGColor.g, jGColor.b);
        if (this.canvas != null) {
            this.canvas.setBackground(color);
        }
        if (this.jre.my_win != null) {
            this.jre.my_win.setBackground(color);
        }
        this.el.bg_color = jGColor;
    }

    public void setFGColor(JGColor jGColor) {
        this.el.fg_color = jGColor;
    }

    public void setMsgFont(JGFont jGFont) {
        this.el.msg_font = jGFont;
    }

    public void setColorsFont(JGColor jGColor, JGColor jGColor2, JGFont jGFont) {
        if (jGFont != null) {
            this.el.msg_font = jGFont;
        }
        if (jGColor != null) {
            this.el.fg_color = jGColor;
        }
        if (jGColor2 != null) {
            this.setBGColor(jGColor2);
        }
    }

    public void setTextOutline(int n, JGColor jGColor) {
        this.el.outline_colour = jGColor;
        this.el.outline_thickness = n;
    }

    public void setMouseCursor(int n) {
        if (n == 0) {
            this.canvas.setCursor(new Cursor(0));
        } else if (n == 1) {
            this.canvas.setCursor(new Cursor(1));
        } else if (n == 2) {
            this.canvas.setCursor(new Cursor(12));
        } else if (n == 3) {
            this.canvas.setCursor(new Cursor(3));
        }
    }

    public void setMouseCursor(Object object) {
        if (object == null) {
            this.canvas.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(this.null_image, new Point(0, 0), "hidden"));
        } else {
            this.canvas.setCursor((Cursor)object);
        }
    }

    public void removeAllTimers() {
        this.el.removeAllTimers();
    }

    public void registerTimer(JGTimer jGTimer) {
        this.el.registerTimer(jGTimer);
    }

    public void setGameState(String string) {
        this.el.setGameState(string);
    }

    public void addGameState(String string) {
        this.el.addGameState(string);
    }

    public void removeGameState(String string) {
        this.el.removeGameState(string);
    }

    public void clearGameState() {
        this.el.clearGameState();
    }

    public boolean inGameState(String string) {
        return this.el.inGameState(string);
    }

    public boolean inGameStateNextFrame(String string) {
        return this.el.inGameStateNextFrame(string);
    }

    private void doFrameAll() {
        this.jre.audioNewFrame();
        this.el.flushRemoveList();
        this.el.flushAddList();
        this.el.tickTimers();
        this.el.flushRemoveList();
        this.el.flushAddList();
        this.el.gamestate = this.el.gamestate_nextframe;
        this.el.gamestate_nextframe = new Vector(10, 20);
        this.el.gamestate_nextframe.addAll(this.el.gamestate);
        this.invokeGameStateMethods("start", this.el.gamestate_new);
        this.el.gamestate_new.clear();
        this.el.flushRemoveList();
        this.el.flushAddList();
        try {
            this.doFrame();
        }
        catch (JGameError jGameError) {
            this.exitEngine(this.dbgExceptionToString(jGameError));
        }
        catch (Exception exception) {
            this.dbgShowException("MAIN", exception);
        }
        this.invokeGameStateMethods("doFrame", this.el.gamestate);
        this.el.frameFinished();
    }

    private void invokeGameStateMethods(String string, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            this.jre.tryMethod(this, string + string2, new Object[0]);
        }
    }

    public void doFrame() {
    }

    void paintFrame(Graphics graphics) {
        this.buf_gfx = graphics;
        this.setColor(graphics, this.el.fg_color);
        this.setFont(this.el.msg_font);
        try {
            this.paintFrame();
        }
        catch (JGameError jGameError) {
            this.exitEngine(this.dbgExceptionToString(jGameError));
        }
        catch (Exception exception) {
            this.dbgShowException("MAIN", exception);
        }
        this.invokeGameStateMethods("paintFrame", this.el.gamestate);
        if ((this.debugflags & 2) != 0) {
            String string = "{";
            Enumeration enumeration = this.el.gamestate.elements();
            while (enumeration.hasMoreElements()) {
                string = string + (String)enumeration.nextElement();
                if (!enumeration.hasMoreElements()) continue;
                string = string + ",";
            }
            string = string + "}";
            this.setFont(this.el.msg_font);
            this.setColor(graphics, this.el.fg_color);
            this.drawString(string, this.el.viewWidth(), this.el.viewHeight() - (int)this.getFontHeight(this.el.msg_font), 1);
        }
        if ((this.debugflags & 8) != 0) {
            this.paintDbgFrameLogs();
        }
        this.buf_gfx = null;
    }

    public void paintFrame() {
    }

    public Graphics getBufferGraphics() {
        return this.buf_gfx;
    }

    public void setColor(JGColor jGColor) {
        if (this.buf_gfx != null) {
            this.setColor(this.buf_gfx, jGColor);
        }
        if (this.cur_gl != null) {
            this.setColor(this.cur_gl, jGColor);
        }
        this.cur_gl_color = jGColor;
    }

    public Color getAWTColor(JGColor jGColor) {
        return new Color(jGColor.r, jGColor.g, jGColor.b);
    }

    public void setFont(JGFont jGFont) {
        this.setFont(this.buf_gfx, jGFont);
    }

    public void setFont(Graphics graphics, JGFont jGFont) {
        Font font = new Font(jGFont.name, jGFont.style, (int)jGFont.size);
        this.cur_gl_font = font = font.deriveFont((float)(jGFont.size * this.el.min_scale_fac));
        if (this.canvas != null && graphics != null) {
            graphics.setFont(font);
        }
    }

    public void setStroke(double d) {
        this.cur_gl_stroke = d;
    }

    public void setBlendMode(int n, int n2) {
        int n3;
        this.cur_gl_blend_src = n;
        this.cur_gl_blend_dst = n2;
        if (this.cur_gl == null) {
            return;
        }
        int n4 = n == 0 ? 1 : (n3 = n == 1 ? 770 : 771);
        int n5 = n2 == 0 ? 1 : (n2 == 1 ? 770 : 771);
        this.cur_gl.glBlendFunc(n3, n5);
    }

    public double getFontHeight(JGFont jGFont) {
        Font font = jGFont == null ? this.cur_gl_font : new Font(jGFont.name, jGFont.style, (int)jGFont.size);
        TextRenderer textRenderer = this.getTextRenderer(font);
        FontRenderContext fontRenderContext = textRenderer.getFontRenderContext();
        Rectangle2D rectangle2D = font.getMaxCharBounds(fontRenderContext);
        return rectangle2D.getHeight();
    }

    static int smallestPowerOfTwo(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    Texture getTexture(JREImage jREImage) {
        if (jREImage.texture == null) {
            JGPoint jGPoint = jREImage.getSize();
            BufferedImage bufferedImage = JREImage.createRGBA8Image(jREImage.getPixels(), jGPoint.x, jGPoint.y);
            jREImage.texture = TextureIO.newTexture((BufferedImage)bufferedImage, (boolean)false);
        }
        return (Texture)jREImage.texture;
    }

    Texture getPOTStretchedTexture(JREImage jREImage) {
        if (jREImage.stretched_texture == null) {
            JGPoint jGPoint = jREImage.getSize();
            int n = JGEngine.smallestPowerOfTwo(jGPoint.x);
            int n2 = JGEngine.smallestPowerOfTwo(jGPoint.y);
            int[] nArray = jREImage.getPixels();
            IntBuffer intBuffer = IntBuffer.wrap(nArray);
            intBuffer.rewind();
            IntBuffer intBuffer2 = IntBuffer.allocate(n * n2);
            intBuffer2.rewind();
            GLU gLU = new GLU();
            if (gLU.gluScaleImage(6408, jGPoint.x, jGPoint.y, 5121, (Buffer)intBuffer, n, n2, 5121, (Buffer)intBuffer2) != 0) {
                throw new JGameError("Texture fails to stretch.");
            }
            BufferedImage bufferedImage = JREImage.createRGBA8Image(intBuffer2.array(), n, n2);
            jREImage.stretched_texture = TextureIO.newTexture((BufferedImage)bufferedImage, (boolean)false);
        }
        return (Texture)jREImage.stretched_texture;
    }

    void setupModelviewMatrix(GL gL, boolean bl) {
        if (bl == this.modelview_matrix_pf_relative) {
            return;
        }
        this.modelview_matrix_pf_relative = bl;
        gL.glMatrixMode(5888);
        gL.glLoadIdentity();
        if (!bl) {
            return;
        }
        int n = this.el.width;
        int n2 = this.el.height;
        gL.glTranslated((double)n / 2.0, (double)n2 / 2.0, 0.0);
        gL.glRotated(this.viewrotate / Math.PI * 180.0, 0.0, 0.0, 1.0);
        gL.glScaled(this.viewzoom, this.viewzoom, 1.0);
        gL.glTranslated((double)(-n) / 2.0, (double)(-n2) / 2.0, 0.0);
    }

    public void drawLine(double d, double d2, double d3, double d4, double d5, JGColor jGColor) {
        if (jGColor != null) {
            this.setColor(jGColor);
        }
        this.setStroke(d5);
        this.drawLine(d, d2, d3, d4, true);
    }

    public void drawLine(double d, double d2, double d3, double d4) {
        this.drawLine(d, d2, d3, d4, true);
    }

    public void drawLine(double d, double d2, double d3, double d4, boolean bl) {
        if (this.cur_gl == null) {
            return;
        }
        this.setColor(this.cur_gl, this.cur_gl_color);
        this.cur_gl.glLineWidth((float)this.cur_gl_stroke);
        this.cur_gl.glBegin(1);
        this.cur_gl.glVertex3d((double)this.el.scaleXPos(d, bl), (double)(this.el.height - this.el.scaleYPos(d2, bl)), 0.0);
        this.cur_gl.glVertex3d((double)this.el.scaleXPos(d3, bl), (double)(this.el.height - this.el.scaleYPos(d4, bl)), 0.0);
        this.cur_gl.glEnd();
    }

    public void drawPolygon(double[] dArray, double[] dArray2, JGColor[] jGColorArray, int n, boolean bl, boolean bl2) {
        if (this.cur_gl == null) {
            return;
        }
        this.setupModelviewMatrix(this.cur_gl, bl2);
        this.drawPolygonInner(dArray, dArray2, jGColorArray, n, bl, bl2);
    }

    void drawPolygonInner(double[] dArray, double[] dArray2, JGColor[] jGColorArray, int n, boolean bl, boolean bl2) {
        this.setColor(this.cur_gl, this.cur_gl_color);
        if (bl) {
            this.cur_gl.glBegin(9);
        } else {
            this.cur_gl.glLineWidth((float)this.cur_gl_stroke);
            this.cur_gl.glBegin(2);
        }
        JGColor jGColor = null;
        for (int i = 0; i < n; ++i) {
            if (jGColorArray != null) {
                if (jGColorArray[i] != jGColor) {
                    this.setColor(this.cur_gl, jGColorArray[i]);
                }
                jGColor = jGColorArray[i];
            }
            this.cur_gl.glVertex3d((double)this.el.scaleXPos(dArray[i], bl2), (double)(this.el.height - this.el.scaleYPos(dArray2[i], bl2)), 0.0);
        }
        this.cur_gl.glEnd();
    }

    public void drawRect(double d, double d2, double d3, double d4, boolean bl, boolean bl2, double d5, JGColor jGColor) {
        if (jGColor != null) {
            this.setColor(jGColor);
        }
        this.setStroke(d5);
        this.drawRect(d, d2, d3, d4, bl, bl2, true, null);
    }

    public void drawRect(double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
        this.drawRect(d, d2, d3, d4, bl, bl2, true, null);
    }

    public void drawRect(double d, double d2, double d3, double d4, boolean bl, boolean bl2, boolean bl3) {
        this.drawRect(d, d2, d3, d4, bl, bl2, bl3, null);
    }

    public void drawRect(double d, double d2, double d3, double d4, boolean bl, boolean bl2, boolean bl3, JGColor[] jGColorArray) {
        if (this.cur_gl == null) {
            return;
        }
        this.setupModelviewMatrix(this.cur_gl, bl3);
        if (bl2) {
            d -= d3 / 2.0;
            d2 -= d4 / 2.0;
        }
        JGRectangle jGRectangle = this.el.scalePos(d, d2, d3, d4, bl3);
        this.setColor(this.cur_gl, this.cur_gl_color);
        if (bl) {
            this.cur_gl.glBegin(7);
        } else {
            this.cur_gl.glLineWidth((float)this.cur_gl_stroke);
            this.cur_gl.glBegin(2);
        }
        if (jGColorArray != null) {
            this.setColor(this.cur_gl, jGColorArray[0]);
        }
        this.cur_gl.glVertex3d((double)jGRectangle.x, (double)(this.el.height - jGRectangle.y), 0.0);
        if (jGColorArray != null) {
            this.setColor(this.cur_gl, jGColorArray[1]);
        }
        this.cur_gl.glVertex3d((double)(jGRectangle.x + jGRectangle.width), (double)(this.el.height - jGRectangle.y), 0.0);
        if (jGColorArray != null) {
            this.setColor(this.cur_gl, jGColorArray[2]);
        }
        this.cur_gl.glVertex3d((double)(jGRectangle.x + jGRectangle.width), (double)(this.el.height - jGRectangle.y - jGRectangle.height), 0.0);
        if (jGColorArray != null) {
            this.setColor(this.cur_gl, jGColorArray[3]);
        }
        this.cur_gl.glVertex3d((double)jGRectangle.x, (double)(this.el.height - jGRectangle.y - jGRectangle.height), 0.0);
        this.cur_gl.glEnd();
    }

    public void drawOval(double d, double d2, double d3, double d4, boolean bl, boolean bl2, double d5, JGColor jGColor) {
        if (jGColor != null) {
            this.setColor(jGColor);
        }
        this.setStroke(d5);
        this.drawOval(d, d2, d3, d4, bl, bl2, true);
    }

    public void drawOval(double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
        this.drawOval(d, d2, d3, d4, bl, bl2, true);
    }

    public void drawOval(double d, double d2, double d3, double d4, boolean bl, boolean bl2, boolean bl3) {
        if (this.cur_gl == null) {
            return;
        }
        this.setupModelviewMatrix(this.cur_gl, bl3);
        d = this.el.scaleXPos(d, bl3);
        d2 = this.el.scaleYPos(d2, bl3);
        if (d3 < 0.0) {
            d3 = -d3;
        }
        if (d4 < 0.0) {
            d4 = -d4;
        }
        int n = this.el.scaleXPos(d3, false);
        int n2 = this.el.scaleYPos(d4, false);
        int n3 = Math.max(n, n2);
        if (!bl2) {
            d += (double)(n / 2);
            d2 += (double)(n2 / 2);
        }
        if (this.ovalx == null) {
            this.genOvalPolygons(256.0);
        }
        this.cur_gl.glPushMatrix();
        this.cur_gl.glTranslated(d, (double)this.el.height - d2, 0.0);
        this.cur_gl.glScaled(d3 / 512.0, d4 / 512.0, 1.0);
        this.cur_gl.glTranslated(0.0, (double)(-this.el.height), 0.0);
        if (n3 > 100) {
            this.drawPolygonInner(this.ovalx_lg, this.ovaly_lg, null, this.ovalx_lg.length, bl, false);
        } else if (n3 > 16) {
            this.drawPolygonInner(this.ovalx, this.ovaly, null, this.ovalx.length, bl, false);
        } else {
            this.drawPolygonInner(this.ovalx_sm, this.ovaly_sm, null, this.ovalx_sm.length, bl, false);
        }
        this.cur_gl.glPopMatrix();
    }

    void genOvalPolygons(double d) {
        this.ovalshade = new JGColor[4];
        for (int i = 0; i < this.ovalshade.length; ++i) {
            this.ovalshade[i] = new JGColor(50 * i, 30 * i, 60 * i, 255);
        }
        this.ovalx = new double[20];
        this.ovaly = new double[20];
        this.ovals = new JGColor[20];
        this.genOvalPolygon(this.ovalx, this.ovaly, this.ovals, d, 20);
        this.ovalx_sm = new double[8];
        this.ovaly_sm = new double[8];
        this.ovals_sm = new JGColor[8];
        this.genOvalPolygon(this.ovalx_sm, this.ovaly_sm, this.ovals_sm, d, 8);
        this.ovalx_lg = new double[50];
        this.ovaly_lg = new double[50];
        this.ovals_lg = new JGColor[50];
        this.genOvalPolygon(this.ovalx_lg, this.ovaly_lg, this.ovals_lg, d, 50);
    }

    void genOvalPolygon(double[] dArray, double[] dArray2, JGColor[] jGColorArray, double d, int n) {
        int n2 = 0;
        for (double d2 = 0.0; d2 < Math.PI * 2; d2 += 6.286326899833176 / (double)n) {
            dArray[n2] = d * Math.sin(d2);
            dArray2[n2] = d * Math.cos(d2);
            jGColorArray[n2] = this.ovalshade[(int)(d2 / Math.PI * 2.0)];
            ++n2;
        }
    }

    public void drawImage(double d, double d2, String string) {
        if (this.cur_gl == null) {
            return;
        }
        this.drawImage(this.cur_gl, d, d2, string, null, 1.0, 0.0, 1.0, true);
    }

    public void drawImage(double d, double d2, String string, boolean bl) {
        if (this.cur_gl == null) {
            return;
        }
        this.drawImage(this.cur_gl, d, d2, string, null, 1.0, 0.0, 1.0, bl);
    }

    public void drawImage(double d, double d2, String string, JGColor jGColor, double d3, double d4, double d5, boolean bl) {
        if (this.cur_gl == null) {
            return;
        }
        this.drawImage(this.cur_gl, d, d2, string, jGColor, d3, d4, d5, bl);
    }

    void drawImage(GL gL, double d, double d2, String string, JGColor jGColor, double d3, double d4, double d5, boolean bl) {
        this.setupModelviewMatrix(gL, bl);
        if (string == null) {
            return;
        }
        d = this.el.scaleXPos(d, bl);
        d2 = this.el.scaleYPos(d2, bl);
        JREImage jREImage = (JREImage)this.el.getImage(string);
        if (jREImage != null) {
            Texture texture = this.getTexture(jREImage);
            JGPoint jGPoint = jREImage.getSize();
            TextureCoords textureCoords = texture.getSubImageTexCoords(0, 0, jGPoint.x, jGPoint.y);
            double d6 = textureCoords.left();
            double d7 = textureCoords.top();
            double d8 = textureCoords.right();
            double d9 = textureCoords.bottom();
            texture.bind();
            texture.enable();
            gL.glTexParameteri(3553, 10240, this.el.smooth_magnify ? 9729 : 9728);
            if (jGColor == null) {
                gL.glColor4d(d3, d3, d3, d3);
            } else {
                gL.glColor4d((double)jGColor.r / 255.0, (double)jGColor.g / 255.0, (double)jGColor.b / 255.0, d3);
            }
            double d10 = (double)jGPoint.x * d5;
            double d11 = (double)jGPoint.y * d5;
            jGPoint = this.el.scalePos(jGPoint.x, jGPoint.y, false);
            double d12 = (double)jGPoint.x * d5;
            double d13 = (double)jGPoint.y * d5;
            d2 -= (d13 - (double)jGPoint.y) / 2.0;
            d2 = (double)this.el.height - d2 - d13;
            gL.glPushMatrix();
            gL.glTranslated((d -= (d12 - (double)jGPoint.x) / 2.0) + d12 / 2.0, d2 + d13 / 2.0, 0.0);
            gL.glScaled(d5 * this.el.x_scale_fac, d5 * this.el.y_scale_fac, 1.0);
            gL.glRotated(d4 / Math.PI * 180.0, 0.0, 0.0, 1.0);
            gL.glBegin(7);
            gL.glTexCoord2d(d6, d7);
            gL.glVertex3d(-d10 / 2.0, d11 / 2.0, 0.0);
            gL.glTexCoord2d(d8, d7);
            gL.glVertex3d(d10 / 2.0, d11 / 2.0, 0.0);
            gL.glTexCoord2d(d8, d9);
            gL.glVertex3d(d10 / 2.0, -d11 / 2.0, 0.0);
            gL.glTexCoord2d(d6, d9);
            gL.glVertex3d(-d10 / 2.0, -d11 / 2.0, 0.0);
            gL.glEnd();
            gL.glPopMatrix();
            texture.disable();
        }
    }

    public void drawString(String string, double d, double d2, int n, JGFont jGFont, JGColor jGColor) {
        if (jGFont != null) {
            this.setFont(jGFont);
        }
        if (jGColor != null) {
            this.setColor(jGColor);
        }
        this.drawString(this.cur_gl, string, d, d2, n, false);
    }

    public void drawString(String string, double d, double d2, int n) {
        this.drawString(this.cur_gl, string, d, d2, n, false);
    }

    public void drawString(String string, double d, double d2, int n, boolean bl) {
        this.drawString(this.cur_gl, string, d, d2, n, bl);
    }

    TextRenderer getTextRenderer(Font font) {
        TextRenderer textRenderer = (TextRenderer)this.textren.get(font);
        if (textRenderer == null) {
            textRenderer = new TextRenderer(font, true, true);
            this.textren.put(font, textRenderer);
        }
        return textRenderer;
    }

    void drawString(GL gL, String string, double d, double d2, int n, boolean bl) {
        JGColor jGColor;
        int n2;
        int n3;
        if (gL == null) {
            return;
        }
        this.setupModelviewMatrix(gL, bl);
        if (string.equals("")) {
            return;
        }
        d = this.el.scaleXPos(d, bl);
        d2 = this.el.scaleYPos(d2, bl);
        Font font = this.cur_gl_font;
        TextRenderer textRenderer = this.getTextRenderer(font);
        FontRenderContext fontRenderContext = textRenderer.getFontRenderContext();
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        if (n == -1) {
            n3 = (int)(d - rectangle2D.getMinX());
            n2 = (int)(d2 - rectangle2D.getMinY());
        } else if (n == 0) {
            n3 = (int)(d - rectangle2D.getCenterX());
            n2 = (int)(d2 - rectangle2D.getMinY());
        } else {
            n3 = (int)(d - rectangle2D.getMaxX());
            n2 = (int)(d2 - rectangle2D.getMinY());
        }
        textRenderer.begin3DRendering();
        if (this.el.outline_thickness > 0) {
            int n4;
            jGColor = this.el.outline_colour;
            textRenderer.setColor((float)jGColor.r / 255.0f, (float)jGColor.g / 255.0f, (float)jGColor.b / 255.0f, (float)jGColor.alpha / 255.0f);
            int n5 = Math.max(this.el.scaleXPos(this.el.outline_thickness, false), 1);
            for (n4 = -n5; n4 <= n5; ++n4) {
                if (n4 == 0) continue;
                textRenderer.draw3D(string, (float)(n3 + n4), (float)(this.el.height - n2), 0.0f, 1.0f);
            }
            for (n4 = -n5; n4 <= n5; ++n4) {
                if (n4 == 0) continue;
                textRenderer.draw3D(string, (float)n3, (float)(this.el.height - (n2 + n4)), 0.0f, 1.0f);
            }
        }
        jGColor = this.cur_gl_color;
        textRenderer.setColor((float)jGColor.r / 255.0f, (float)jGColor.g / 255.0f, (float)jGColor.b / 255.0f, (float)jGColor.alpha / 255.0f);
        try {
            textRenderer.draw3D(string, (float)n3, (float)(this.el.height - n2), 0.0f, 1.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        textRenderer.end3DRendering();
    }

    void drawString(Graphics graphics, String string, double d, double d2, int n, boolean bl) {
        int n2;
        int n3;
        if (graphics == null) {
            return;
        }
        if (string.equals("")) {
            return;
        }
        d = this.el.scaleXPos(d, bl);
        d2 = this.el.scaleYPos(d2, bl);
        Font font = graphics.getFont();
        FontRenderContext fontRenderContext = ((Graphics2D)graphics).getFontRenderContext();
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        if (n == -1) {
            n3 = (int)(d - rectangle2D.getMinX());
            n2 = (int)(d2 - rectangle2D.getMinY());
        } else if (n == 0) {
            n3 = (int)(d - rectangle2D.getCenterX());
            n2 = (int)(d2 - rectangle2D.getMinY());
        } else {
            n3 = (int)(d - rectangle2D.getMaxX());
            n2 = (int)(d2 - rectangle2D.getMinY());
        }
        if (this.el.outline_thickness > 0) {
            int n4;
            Color color = graphics.getColor();
            this.setColor(this.el.outline_colour);
            int n5 = Math.max(this.el.scaleXPos(this.el.outline_thickness, false), 1);
            for (n4 = -n5; n4 <= n5; ++n4) {
                if (n4 == 0) continue;
                graphics.drawString(string, n3 + n4, n2);
            }
            for (n4 = -n5; n4 <= n5; ++n4) {
                if (n4 == 0) continue;
                graphics.drawString(string, n3, n2 + n4);
            }
            graphics.setColor(color);
        }
        graphics.drawString(string, n3, n2);
    }

    public void drawImageString(String string, double d, double d2, int n, String string2, int n2, int n3) {
        this.el.drawImageString(this, string, d, d2, n, string2, n2, n3, false);
    }

    public void drawImageString(String string, double d, double d2, int n, String string2, int n2, int n3, boolean bl) {
        this.el.drawImageString(this, string, d, d2, n, string2, n2, n3, bl);
        ImageMap imageMap = (ImageMap)this.el.imagemaps.get(string2);
        if (imageMap == null) {
            throw new JGameError("Font image map '" + string2 + "' not found.", true);
        }
        if (n == 0) {
            d -= (double)((imageMap.tilex + n3) * string.length() / 2);
        } else if (n == 1) {
            d -= (double)((imageMap.tilex + n3) * string.length());
        }
        for (int i = 0; i < string.length(); ++i) {
            int n4 = -n2 + string.charAt(i);
            String string3 = string2 + "#" + string.charAt(i);
            if (!this.el.existsImage(string3)) {
                this.el.defineImage(string3, "FONT", 0, this.el.getSubImage(string2, n4), "-", 0, 0, 0, 0);
            }
            JGImage jGImage = this.getImage(string3);
            this.drawImage(this.cur_gl, d, d2, string3, null, 1.0, 0.0, 1.0, bl);
            d += (double)(imageMap.tilex + n3);
        }
    }

    public JGPoint getMousePos() {
        int n = this.el.tilex * this.el.viewnrtilesx;
        int n2 = this.el.tiley * this.el.viewnrtilesy;
        double d = this.jre.mousepos.x - n / 2;
        double d2 = this.jre.mousepos.y - n2 / 2;
        return new JGPoint(n / 2 + (int)(1.0 / this.viewzoom * (d * Math.cos(-this.viewrotate) + d2 * Math.sin(-this.viewrotate))), n2 / 2 + (int)(1.0 / this.viewzoom * (-d * Math.sin(-this.viewrotate) + d2 * Math.cos(-this.viewrotate))));
    }

    public int getMouseX() {
        return this.getMousePos().x;
    }

    public int getMouseY() {
        return this.getMousePos().y;
    }

    public boolean getMouseButton(int n) {
        return this.jre.mousebutton[n];
    }

    public void clearMouseButton(int n) {
        this.jre.mousebutton[n] = false;
    }

    public void setMouseButton(int n) {
        this.jre.mousebutton[n] = true;
    }

    public boolean getMouseInside() {
        return this.jre.mouseinside;
    }

    public boolean getKey(int n) {
        return this.jre.keymap[n];
    }

    public void clearKey(int n) {
        this.jre.keymap[n] = false;
    }

    public void setKey(int n) {
        this.jre.keymap[n] = true;
    }

    public int getLastKey() {
        return this.jre.lastkey;
    }

    public char getLastKeyChar() {
        return this.jre.lastkeychar;
    }

    public void clearLastKey() {
        this.jre.clearLastKey();
    }

    public String getKeyDesc(int n) {
        return JREEngine.getKeyDescStatic(n);
    }

    public static String getKeyDescStatic(int n) {
        return JREEngine.getKeyDescStatic(n);
    }

    public int getKeyCode(String string) {
        return JREEngine.getKeyCodeStatic(string);
    }

    public static int getKeyCodeStatic(String string) {
        return JREEngine.getKeyCodeStatic(string);
    }

    public void defineAnimation(String string, String[] stringArray, double d) {
        this.el.defineAnimation(string, stringArray, d);
    }

    public void defineAnimation(String string, String[] stringArray, double d, boolean bl) {
        this.el.defineAnimation(string, stringArray, d, bl);
    }

    public Animation getAnimation(String string) {
        return this.el.getAnimation(string);
    }

    public String getConfigPath(String string) {
        File file;
        if (this.isApplet()) {
            return null;
        }
        try {
            file = new File(System.getProperty("user.home"), ".jgame");
        }
        catch (Exception exception) {
            return null;
        }
        if (!file.exists() && !file.mkdir()) {
            return null;
        }
        if (!file.isDirectory()) {
            return null;
        }
        File file2 = new File(file, string);
        try {
            file2.createNewFile();
        }
        catch (IOException iOException) {
            return null;
        }
        if (!file2.canRead()) {
            return null;
        }
        if (!file2.canWrite()) {
            return null;
        }
        try {
            return file2.getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    void paintExitMessage(GL gL) {
        try {
            this.setFont(this.debugmessage_font);
            int n = (int)(this.getFontHeight(null) / this.el.y_scale_fac);
            this.cur_gl = gL;
            this.drawRect(this.el.viewWidth() / 2, this.el.viewHeight() / 2, 9 * this.el.viewWidth() / 10, n * 5, true, true, false);
            this.setColor(this.debug_auxcolor2);
            this.drawRect(this.el.viewWidth() / 2, this.el.viewHeight() / 2 - 5 * n / 2, 9 * this.viewWidth() / 10, 5.0, true, true, false);
            this.drawRect(this.el.viewWidth() / 2, this.el.viewHeight() / 2 + 5 * n / 2, 9 * this.viewWidth() / 10, 5.0, true, true, false);
            this.setColor(this.el.fg_color);
            int n2 = this.el.viewHeight() / 2 - 3 * n / 2;
            StringTokenizer stringTokenizer = new StringTokenizer(this.el.exit_message, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                this.drawString(stringTokenizer.nextToken(), this.el.viewWidth() / 2, n2, 0, false);
                n2 += n + 1;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean and(int n, int n2) {
        return this.el.and(n, n2);
    }

    public double random(double d, double d2) {
        return this.el.random(d, d2);
    }

    public double random(double d, double d2, double d3) {
        return this.el.random(d, d2, d3);
    }

    public int random(int n, int n2, int n3) {
        return this.el.random(n, n2, n3);
    }

    public double atan2(double d, double d2) {
        return Math.atan2(d, d2);
    }

    public JGPoint getTileIndex(double d, double d2) {
        return this.el.getTileIndex(d, d2);
    }

    public JGPoint getTileCoord(int n, int n2) {
        return this.el.getTileCoord(n, n2);
    }

    public JGPoint getTileCoord(JGPoint jGPoint) {
        return this.el.getTileCoord(jGPoint);
    }

    public double snapToGridX(double d, double d2) {
        return this.el.snapToGridX(d, d2);
    }

    public double snapToGridY(double d, double d2) {
        return this.el.snapToGridY(d, d2);
    }

    public void snapToGrid(JGPoint jGPoint, int n, int n2) {
        this.el.snapToGrid(jGPoint, n, n2);
    }

    public boolean isXAligned(double d, double d2) {
        return this.el.isXAligned(d, d2);
    }

    public boolean isYAligned(double d, double d2) {
        return this.el.isYAligned(d, d2);
    }

    public double getXAlignOfs(double d) {
        return this.el.getXAlignOfs(d);
    }

    public double getYAlignOfs(double d) {
        return this.el.getYAlignOfs(d);
    }

    public double getXDist(double d, double d2) {
        return this.el.getXDist(d, d2);
    }

    public double getYDist(double d, double d2) {
        return this.el.getYDist(d, d2);
    }

    public void enableAudio() {
        this.jre.enableAudio();
    }

    public void disableAudio() {
        this.jre.disableAudio();
    }

    public void defineAudioClip(String string, String string2) {
        this.el.defineAudioClip(this, string, string2);
    }

    public String lastPlayedAudio(String string) {
        return this.jre.lastPlayedAudio(string);
    }

    public void playAudio(String string) {
        this.jre.playAudio(this, string);
    }

    public void playAudio(String string, String string2, boolean bl) {
        this.jre.playAudio(this, string, string2, bl);
    }

    public void stopAudio(String string) {
        this.jre.stopAudio(string);
    }

    public void stopAudio() {
        this.jre.stopAudio();
    }

    public void storeWriteInt(String string, int n) {
        this.jre.storeWriteInt(string, n);
    }

    public void storeWriteDouble(String string, double d) {
        this.jre.storeWriteDouble(string, d);
    }

    public void storeWriteString(String string, String string2) {
        this.jre.storeWriteString(string, string2);
    }

    public void storeRemove(String string) {
        this.jre.storeRemove(string);
    }

    public boolean storeExists(String string) {
        return this.jre.storeExists(string);
    }

    public int storeReadInt(String string, int n) {
        return this.jre.storeReadInt(string, n);
    }

    public double storeReadDouble(String string, double d) {
        return this.jre.storeReadDouble(string, d);
    }

    public String storeReadString(String string, String string2) {
        return this.jre.storeReadString(string, string2);
    }

    class JGEngineThread
    implements Runnable {
        private long target_time = 0L;
        private int frames_skipped = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    JGEngine.this.initGame();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new JGameError("Exception during initGame(): " + exception);
                }
                JGEngine.this.canvas.setInitialised();
                this.target_time = System.currentTimeMillis() + (long)(1000.0 / JGEngine.this.el.fps);
                while (!JGEngine.this.el.is_exited) {
                    int n;
                    SortedArray sortedArray;
                    if (!JGEngine.this.gl_driven_update && (JGEngine.this.debugflags & 8) != 0) {
                        JGEngine.this.refreshDbgFrameLogs();
                    }
                    long l = System.currentTimeMillis();
                    if (!JGEngine.this.running) {
                        if (JGEngine.this.anim != null) {
                            JGEngine.this.anim.stop();
                            JGEngine.this.anim = null;
                        }
                        Thread.sleep(500L);
                        this.target_time = l + (long)(1000.0 / JGEngine.this.el.fps);
                        JGEngine.this.canvas.repaint();
                        continue;
                    }
                    if (JGEngine.this.gl_driven_update) {
                        if (JGEngine.this.anim == null) {
                            JGEngine.this.canvas.repaint();
                        }
                        Thread.sleep(500L);
                        this.target_time = l + (long)(1000.0 / JGEngine.this.el.fps);
                        continue;
                    }
                    if (l < this.target_time + (long)(500.0 / JGEngine.this.el.fps)) {
                        sortedArray = JGEngine.this.el.objects;
                        synchronized (sortedArray) {
                            JGEngine.this.doFrameAll();
                            JGEngine.this.el.updateViewOffset();
                        }
                        JGEngine.this.canvas.repaint();
                        this.frames_skipped = 0;
                        if (l + 3L < this.target_time) {
                            Thread.sleep(this.target_time - l);
                        } else {
                            Thread.yield();
                        }
                        this.target_time = (long)((double)this.target_time + 1000.0 / JGEngine.this.el.fps);
                        continue;
                    }
                    sortedArray = JGEngine.this.el.objects;
                    synchronized (sortedArray) {
                        JGEngine.this.doFrameAll();
                        JGEngine.this.el.updateViewOffset();
                    }
                    ++this.frames_skipped;
                    if ((double)n > JGEngine.this.el.maxframeskip) {
                        JGEngine.this.canvas.repaint();
                        this.frames_skipped = 0;
                        this.target_time = l + (long)(1000.0 / JGEngine.this.el.fps);
                    } else {
                        this.target_time += (long)(1000.0 / JGEngine.this.el.fps);
                    }
                    Thread.yield();
                }
            }
            catch (InterruptedException interruptedException) {
                System.out.println("JGame thread exited.");
            }
            catch (Exception exception) {
                JGEngine.this.dbgShowException("MAIN", exception);
            }
            catch (JGameError jGameError) {
                JGEngine.this.exitEngine("Error in main:\n" + JGEngine.this.dbgExceptionToString(jGameError));
            }
        }
    }

    class JGCanvas
    extends GLCanvas
    implements GLEventListener {
        int w;
        int h;
        long prev_gl_time;
        double max_gl_refresh_rate;
        int canvwidth;
        int canvheight;
        boolean is_initialised;
        private ListCellRenderer initpainter;
        String progress_message;
        String author_message;
        double progress_bar;

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
            System.out.println("glcanvas displayChanged()");
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            System.out.println("glcanvas init()");
            GL gL = gLAutoDrawable.getGL();
            gL.setSwapInterval(1);
            gL.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gL.glColor3f(1.0f, 1.0f, 1.0f);
            gL.glPointSize(1.0f);
            if (JGEngine.this.gl_driven_update && JGEngine.this.anim == null) {
                JGEngine.this.anim = new Animator(gLAutoDrawable);
                JGEngine.this.anim.start();
                this.prev_gl_time = System.currentTimeMillis();
            }
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            System.out.println("glcanvas reshape()");
            GL gL = gLAutoDrawable.getGL();
            GLU gLU = new GLU();
            gL.glViewport(0, 0, n3, n4);
            this.w = n3;
            this.h = n4;
            gL.glMatrixMode(5889);
            gL.glLoadIdentity();
            gLU.gluOrtho2D(0.0, (double)n3, 0.0, (double)n4);
            gL.glMatrixMode(5888);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void display(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            GLU gLU = new GLU();
            gL.glMatrixMode(5889);
            gL.glLoadIdentity();
            gLU.gluOrtho2D(0.0, (double)this.w, 0.0, (double)this.h);
            gL.glMatrixMode(5888);
            gL.glLoadIdentity();
            JGEngine.this.modelview_matrix_pf_relative = false;
            gL.glClearColor((float)JGEngine.this.el.bg_color.r, (float)JGEngine.this.el.bg_color.g, (float)JGEngine.this.el.bg_color.b, 1.0f);
            gL.glClear(16384);
            gL.glShadeModel(7425);
            if (!this.is_initialised) {
                if (this.initpainter != null) {
                    this.initpainter.getListCellRendererComponent(null, gL, 0, false, false);
                }
                return;
            }
            if (JGEngine.this.el.is_exited) {
                JGEngine.this.paintExitMessage(gL);
                return;
            }
            SortedArray sortedArray = JGEngine.this.el.objects;
            synchronized (sortedArray) {
                boolean bl;
                double d;
                double d2;
                double d3;
                double d4;
                TextureCoords textureCoords;
                int n;
                double d5;
                double d6;
                double d7;
                double d8;
                double d9;
                double d10;
                if (JGEngine.this.gl_driven_update && JGEngine.this.running) {
                    if (JGEngine.this.anim == null) {
                        JGEngine.this.anim = new Animator(gLAutoDrawable);
                        JGEngine.this.anim.start();
                        this.prev_gl_time = System.currentTimeMillis();
                    }
                    d10 = JGEngine.this.el.width;
                    d9 = JGEngine.this.el.height;
                    long l = System.currentTimeMillis();
                    long l2 = this.prev_gl_time + (long)(1000.0 / JGEngine.this.el.fps);
                    long l3 = l - this.prev_gl_time;
                    double d11 = 1000.0 / JGEngine.this.el.fps;
                    double d12 = 1000.0 / this.max_gl_refresh_rate;
                    d8 = 1000.0 / JGEngine.this.el.fps * (1.0 + JGEngine.this.el.maxframeskip);
                    d7 = (double)l3 / d11;
                    d6 = d12 / d11;
                    d5 = d8 / d11;
                    if (d7 < d6) {
                        d7 = d6;
                        long l4 = (long)(d12 - (double)l3);
                        if (l4 > 2L) {
                            try {
                                Thread.sleep(l4);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                    }
                    if (d7 > d5) {
                        d7 = d5;
                    }
                    JGEngine.this.setGameSpeed(d7);
                    this.prev_gl_time = l;
                    if ((JGEngine.this.debugflags & 8) != 0) {
                        JGEngine.this.refreshDbgFrameLogs();
                    }
                    JGEngine.this.doFrameAll();
                    JGEngine.this.el.updateViewOffset();
                }
                JGEngine.this.setupModelviewMatrix(gL, true);
                gL.glEnable(3042);
                gL.glBlendFunc(770, 771);
                gL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                d10 = 0.0;
                d9 = 0.0;
                double d13 = JGEngine.this.el.width;
                double d14 = JGEngine.this.el.height;
                for (n = JGEngine.this.el.bg_images.size() - 1; n >= 0; --n) {
                    double d15;
                    double d16;
                    EngineLogic.BGImage bGImage = (EngineLogic.BGImage)JGEngine.this.el.bg_images.get(n);
                    if (bGImage == null) continue;
                    JREImage jREImage = (JREImage)JGEngine.this.el.getImage(bGImage.imgname);
                    Texture texture = JGEngine.this.getTexture(jREImage);
                    textureCoords = texture.getImageTexCoords();
                    if ((double)Math.abs(textureCoords.right() - textureCoords.left()) != 1.0 || (double)Math.abs(textureCoords.bottom() - textureCoords.top()) != 1.0 || !JGEngine.this.enable_npot) {
                        texture = JGEngine.this.getPOTStretchedTexture(jREImage);
                        textureCoords = texture.getImageTexCoords();
                    }
                    texture.bind();
                    texture.enable();
                    gL.glTexParameterf(3553, 10242, bGImage.wrapx ? 10497.0f : 10496.0f);
                    gL.glTexParameterf(3553, 10243, bGImage.wrapy ? 10497.0f : 10496.0f);
                    gL.glTexParameteri(3553, 10241, 9729);
                    gL.glTexParameteri(3553, 10240, JGEngine.this.el.smooth_magnify ? 9729 : 9728);
                    JGPoint jGPoint = jREImage.getSize();
                    d4 = 0.0;
                    d3 = 0.0;
                    d2 = d13;
                    d = d14;
                    d8 = 1.0 / (double)jGPoint.x;
                    if (bGImage.wrapx) {
                        d6 = bGImage.xofs * d8;
                        d16 = d13 * d8 / JGEngine.this.el.x_scale_fac;
                    } else {
                        d4 = -bGImage.xofs * JGEngine.this.el.x_scale_fac;
                        d2 = (double)jGPoint.x * JGEngine.this.el.x_scale_fac;
                        d6 = 0.0;
                        d16 = 1.0;
                    }
                    d7 = 1.0 / (double)jGPoint.y;
                    if (bGImage.wrapy) {
                        d5 = bGImage.yofs * d7;
                        d15 = d14 * d7 / JGEngine.this.el.y_scale_fac;
                    } else {
                        d3 = d14 - ((double)jGPoint.y - bGImage.yofs) * JGEngine.this.el.y_scale_fac;
                        d = (double)jGPoint.y * JGEngine.this.el.y_scale_fac;
                        d5 = 0.0;
                        d15 = 1.0;
                    }
                    gL.glBegin(7);
                    gL.glTexCoord2d(d6, d5);
                    gL.glVertex3d(d4, d3 + d, 0.0);
                    gL.glTexCoord2d(d6 + d16, d5);
                    gL.glVertex3d(d4 + d2, d3 + d, 0.0);
                    gL.glTexCoord2d(d6 + d16, d5 + d15);
                    gL.glVertex3d(d4 + d2, d3, 0.0);
                    gL.glTexCoord2d(d6, d5 + d15);
                    gL.glVertex3d(d4, d3, 0.0);
                    gL.glEnd();
                    texture.disable();
                }
                n = JGEngine.this.el.tilex * (JGEngine.this.el.viewnrtilesx + 3);
                int n2 = JGEngine.this.el.tiley * (JGEngine.this.el.viewnrtilesy + 3);
                if (JGEngine.this.background == null) {
                    JGEngine.this.background = new TextureRenderer(n, n2, true);
                    JGEngine.this.background.setSmoothing(true);
                    JGEngine.this.el.invalidateBGTiles();
                }
                JGEngine.this.el.repaintBG(JGEngine.this);
                gL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                Texture texture = JGEngine.this.background.getTexture();
                textureCoords = texture.getSubImageTexCoords(0, 0, n, n2);
                int n3 = JGEngine.this.el.tilex + JGEngine.this.el.xofs;
                int n4 = JGEngine.this.el.tiley + JGEngine.this.el.yofs;
                int n5 = (JGEngine.this.el.viewnrtilesx + 1) * JGEngine.this.el.tilex + JGEngine.this.el.xofs;
                int n6 = (JGEngine.this.el.viewnrtilesy + 1) * JGEngine.this.el.tiley + JGEngine.this.el.yofs;
                int n7 = (int)Math.floor((double)n3 / (double)n);
                int n8 = (int)Math.floor((double)n4 / (double)n2);
                int n9 = (int)Math.floor((double)n5 / (double)n);
                int n10 = (int)Math.floor((double)n6 / (double)n2);
                n3 -= n7 * n;
                n4 -= n8 * n2;
                n5 -= n9 * n;
                n6 -= n10 * n2;
                boolean bl2 = n9 > n7;
                boolean bl3 = n10 > n8;
                double d17 = Math.abs(textureCoords.right() - textureCoords.left());
                double d18 = Math.abs(textureCoords.bottom() - textureCoords.top());
                d4 = Math.min(textureCoords.right(), textureCoords.left());
                d3 = Math.min(textureCoords.bottom(), textureCoords.top());
                d2 = (double)n / d17;
                d = (double)n2 / d18;
                boolean bl4 = d17 == 1.0 && JGEngine.this.enable_npot;
                boolean bl5 = bl = d18 == 1.0 && JGEngine.this.enable_npot;
                if (!bl4) {
                    d4 += 0.5 / d2;
                    d17 -= 1.0 / d2;
                }
                if (!bl) {
                    d3 += 0.5 / d;
                    d18 -= 1.0 / d;
                }
                boolean bl6 = bl2 && !bl4;
                boolean bl7 = bl3 && !bl;
                double d19 = d13;
                double d20 = d14;
                double d21 = d13;
                double d22 = d14;
                double d23 = d4 + (double)n3 / d2;
                double d24 = d3 + (double)n4 / d;
                double d25 = d4 + (double)n5 / d2;
                double d26 = d3 + (double)n6 / d;
                double d27 = d4;
                double d28 = d3;
                double d29 = d25;
                double d30 = d26;
                if (bl2) {
                    if (bl6) {
                        d19 = (double)(n - n3) * JGEngine.this.el.x_scale_fac;
                        d25 = d4 + d17;
                    } else {
                        d25 += 1.0;
                    }
                }
                if (bl3) {
                    if (bl7) {
                        d20 = (double)(n2 - n4) * JGEngine.this.el.y_scale_fac;
                        d26 = d3 + d18;
                    } else {
                        d26 += 1.0;
                    }
                }
                texture.bind();
                texture.enable();
                gL.glTexParameterf(3553, 10242, bl4 ? 10497.0f : 10496.0f);
                gL.glTexParameterf(3553, 10243, bl ? 10497.0f : 10496.0f);
                gL.glTexParameteri(3553, 10241, 9729);
                gL.glTexParameteri(3553, 10240, JGEngine.this.el.smooth_magnify ? 9729 : 9728);
                gL.glBegin(7);
                gL.glTexCoord2d(d23, d24);
                gL.glVertex3d(d10, d9 + d14, 0.0);
                gL.glTexCoord2d(d25, d24);
                gL.glVertex3d(d10 + d19, d9 + d14, 0.0);
                gL.glTexCoord2d(d25, d26);
                gL.glVertex3d(d10 + d19, d9 + d14 - d20, 0.0);
                gL.glTexCoord2d(d23, d26);
                gL.glVertex3d(d10, d9 + d14 - d20, 0.0);
                if (bl6) {
                    gL.glTexCoord2d(d27, d24);
                    gL.glVertex3d(d10 + d19, d9 + d14, 0.0);
                    gL.glTexCoord2d(d29, d24);
                    gL.glVertex3d(d10 + d21, d9 + d14, 0.0);
                    gL.glTexCoord2d(d29, d26);
                    gL.glVertex3d(d10 + d21, d9 + d14 - d20, 0.0);
                    gL.glTexCoord2d(d27, d26);
                    gL.glVertex3d(d10 + d19, d9 + d14 - d20, 0.0);
                }
                if (bl7) {
                    gL.glTexCoord2d(d23, d28);
                    gL.glVertex3d(d10, d9 + d14 - d20, 0.0);
                    gL.glTexCoord2d(d25, d28);
                    gL.glVertex3d(d10 + d19, d9 + d14 - d20, 0.0);
                    gL.glTexCoord2d(d25, d30);
                    gL.glVertex3d(d10 + d19, d9, 0.0);
                    gL.glTexCoord2d(d23, d30);
                    gL.glVertex3d(d10, d9, 0.0);
                }
                if (bl6 && bl7) {
                    gL.glTexCoord2d(d27, d28);
                    gL.glVertex3d(d10 + d19, d9 + d14 - d20, 0.0);
                    gL.glTexCoord2d(d29, d28);
                    gL.glVertex3d(d10 + d21, d9 + d14 - d20, 0.0);
                    gL.glTexCoord2d(d29, d30);
                    gL.glVertex3d(d10 + d21, d9, 0.0);
                    gL.glTexCoord2d(d27, d30);
                    gL.glVertex3d(d10 + d19, d9, 0.0);
                }
                gL.glEnd();
                texture.disable();
                gL.glDisable(3042);
                if (JGEngine.this.buffer == null) {
                    JGEngine.this.buffer = new TextureRenderer(JGEngine.this.el.tilex * JGEngine.this.el.nrtilesx, JGEngine.this.el.tiley * JGEngine.this.el.nrtilesy, true);
                    JGEngine.this.buffer.setSmoothing(true);
                    JGEngine.this.bufg = JGEngine.this.buffer.createGraphics();
                }
                JGEngine.this.bufg.setComposite(AlphaComposite.getInstance(1, 0.0f));
                JGEngine.this.bufg.setComposite(AlphaComposite.SrcOver);
                gL.glTexParameterf(3553, 10242, 10496.0f);
                gL.glTexParameterf(3553, 10243, 10496.0f);
                gL.glTexParameteri(3553, 10241, 9729);
                gL.glTexParameteri(3553, 10240, JGEngine.this.el.smooth_magnify ? 9729 : 9728);
                JGEngine.this.buf_gfx = JGEngine.this.bufg;
                JGEngine.this.cur_gl = gL;
                gL.glEnable(3042);
                JGEngine.this.setBlendMode(JGEngine.this.cur_gl_blend_src, JGEngine.this.cur_gl_blend_dst);
                JGEngine.this.drawString(gL, "   ", 0.0, 0.0, 0, false);
                for (int i = 0; i < JGEngine.this.el.objects.size; ++i) {
                    JGEngine.this.drawObject(JGEngine.this.bufg, gL, (JGObject)JGEngine.this.el.objects.values[i]);
                }
                JGEngine.this.buf_gfx = null;
                if (JGEngine.this.bufg != null) {
                    JGEngine.this.paintFrame(JGEngine.this.bufg);
                }
                gL.glDisable(3042);
                JGEngine.this.cur_gl = null;
                texture = JGEngine.this.buffer.getTexture();
                texture.bind();
                texture.enable();
                gL.glEnable(3042);
                gL.glBegin(7);
                gL.glEnd();
                gL.glDisable(3042);
                texture.disable();
            }
        }

        public boolean isFocusTraversable() {
            return true;
        }

        public JGCanvas(int n, int n2) {
            super(new GLCapabilities());
            this.w = 250;
            this.h = 250;
            this.prev_gl_time = 0L;
            this.max_gl_refresh_rate = 95.0;
            this.is_initialised = false;
            this.initpainter = null;
            this.progress_message = "Please wait, loading files .....";
            this.author_message = "JGame 3.4";
            this.progress_bar = 0.0;
            this.setSize(n, n2);
            this.canvwidth = n;
            this.canvheight = n2;
        }

        void setInitialised() {
            this.is_initialised = true;
            this.initpainter = null;
        }

        void setInitPainter(ListCellRenderer listCellRenderer) {
            this.initpainter = listCellRenderer;
        }

        void setProgressBar(double d) {
            this.progress_bar = d;
            if (!this.is_initialised && this.initpainter != null) {
                this.repaint(100L);
            }
        }

        void setProgressMessage(String string) {
            this.progress_message = string;
            if (!this.is_initialised && this.initpainter != null) {
                this.repaint(100L);
            }
        }

        void setAuthorMessage(String string) {
            this.author_message = string;
            if (!this.is_initialised && this.initpainter != null) {
                this.repaint(100L);
            }
        }
    }
}

